/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.pullLayout;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.widget.ImageViewCompat;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.skin.QMUISkinHelper;
import com.qmuiteam.qmui.skin.QMUISkinValueBuilder;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.widget.QMUILoadingView;
import com.qmuiteam.qmui.widget.pullLayout.QMUIPullLayout;

public class QMUIPullLoadMoreView
extends ConstraintLayout
implements QMUIPullLayout.ActionPullWatcherView {
    private boolean mIsLoading = false;
    private QMUILoadingView mLoadingView;
    private AppCompatImageView mArrowView;
    private AppCompatTextView mTextView;
    private int mHeight;
    private String mPullText;
    private String mReleaseText;
    private boolean mIsInReleaseState = false;

    public QMUIPullLoadMoreView(Context context) {
        this(context, null);
    }

    public QMUIPullLoadMoreView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.QMUIPullLoadMoreStyle);
    }

    public QMUIPullLoadMoreView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.QMUIPullLoadMoreView, defStyleAttr, 0);
        this.mPullText = array.getString(R.styleable.QMUIPullLoadMoreView_qmui_pull_load_more_pull_text);
        this.mReleaseText = array.getString(R.styleable.QMUIPullLoadMoreView_qmui_pull_load_more_release_text);
        this.mHeight = array.getDimensionPixelSize(R.styleable.QMUIPullLoadMoreView_qmui_pull_load_more_height, QMUIDisplayHelper.dp2px(context, 56));
        int loadSize = array.getDimensionPixelSize(R.styleable.QMUIPullLoadMoreView_qmui_pull_load_more_loading_size, QMUIDisplayHelper.dp2px(context, 20));
        int textSize = array.getDimensionPixelSize(R.styleable.QMUIPullLoadMoreView_qmui_pull_load_more_text_size, QMUIDisplayHelper.sp2px(context, 14));
        int arrowTextGap = array.getDimensionPixelSize(R.styleable.QMUIPullLoadMoreView_qmui_pull_load_more_arrow_text_gap, QMUIDisplayHelper.dp2px(context, 10));
        Drawable arrow = array.getDrawable(R.styleable.QMUIPullLoadMoreView_qmui_pull_load_more_arrow);
        int bgColor = array.getColor(R.styleable.QMUIPullLoadMoreView_qmui_skin_support_pull_load_more_bg_color, 0);
        int loadingTintColor = array.getColor(R.styleable.QMUIPullLoadMoreView_qmui_skin_support_pull_load_more_loading_tint_color, -16777216);
        int arrowTintColor = array.getColor(R.styleable.QMUIPullLoadMoreView_qmui_skin_support_pull_load_more_arrow_tint_color, -16777216);
        int textColor = array.getColor(R.styleable.QMUIPullLoadMoreView_qmui_skin_support_pull_load_more_text_color, -16777216);
        array.recycle();
        this.mLoadingView = new QMUILoadingView(context);
        this.mLoadingView.setSize(loadSize);
        this.mLoadingView.setColor(loadingTintColor);
        this.mLoadingView.setVisibility(8);
        ConstraintLayout.LayoutParams lp = new ConstraintLayout.LayoutParams(-2, -2);
        lp.leftToLeft = 0;
        lp.rightToRight = 0;
        lp.topToTop = 0;
        lp.bottomToBottom = 0;
        this.addView(this.mLoadingView, (ViewGroup.LayoutParams)lp);
        this.mArrowView = new AppCompatImageView(context);
        this.mArrowView.setId(View.generateViewId());
        this.mArrowView.setImageDrawable(arrow);
        this.mArrowView.setRotation(180.0f);
        ImageViewCompat.setImageTintList((ImageView)this.mArrowView, (ColorStateList)ColorStateList.valueOf((int)arrowTintColor));
        this.mTextView = new AppCompatTextView(context);
        this.mTextView.setId(View.generateViewId());
        this.mTextView.setTextSize(0, (float)textSize);
        this.mTextView.setTextColor(textColor);
        this.mTextView.setText((CharSequence)this.mPullText);
        lp = new ConstraintLayout.LayoutParams(-2, -2);
        lp.leftToLeft = 0;
        lp.rightToLeft = this.mTextView.getId();
        lp.topToTop = 0;
        lp.bottomToBottom = 0;
        lp.horizontalChainStyle = 2;
        this.addView((View)this.mArrowView, (ViewGroup.LayoutParams)lp);
        lp = new ConstraintLayout.LayoutParams(-2, -2);
        lp.leftToRight = this.mArrowView.getId();
        lp.rightToRight = 0;
        lp.topToTop = 0;
        lp.bottomToBottom = 0;
        lp.leftMargin = arrowTextGap;
        this.addView((View)this.mTextView, (ViewGroup.LayoutParams)lp);
        this.setBackgroundColor(bgColor);
        QMUISkinValueBuilder skinValueBuilder = QMUISkinValueBuilder.acquire();
        skinValueBuilder.background(R.attr.qmui_skin_support_pull_load_more_bg_color);
        QMUISkinHelper.setSkinValue((View)this, skinValueBuilder);
        skinValueBuilder.clear();
        skinValueBuilder.tintColor(R.attr.qmui_skin_support_pull_load_more_loading_tint_color);
        QMUISkinHelper.setSkinValue((View)this.mLoadingView, skinValueBuilder);
        skinValueBuilder.clear();
        skinValueBuilder.tintColor(R.attr.qmui_skin_support_pull_load_more_arrow_tint_color);
        QMUISkinHelper.setSkinValue((View)this.mArrowView, skinValueBuilder);
        skinValueBuilder.clear();
        skinValueBuilder.textColor(R.attr.qmui_skin_support_pull_load_more_text_color);
        QMUISkinHelper.setSkinValue((View)this.mTextView, skinValueBuilder);
        skinValueBuilder.release();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)this.mHeight, (int)0x40000000));
    }

    @Override
    public void onPull(QMUIPullLayout.PullAction pullAction, int currentTargetOffset) {
        if (this.mIsLoading) {
            return;
        }
        if (this.mIsInReleaseState) {
            if (pullAction.getTargetTriggerOffset() > currentTargetOffset) {
                this.mIsInReleaseState = false;
                this.mTextView.setText((CharSequence)this.mPullText);
                this.mArrowView.animate().rotation(180.0f).start();
            }
        } else if (pullAction.getTargetTriggerOffset() <= currentTargetOffset) {
            this.mIsInReleaseState = true;
            this.mTextView.setText((CharSequence)this.mReleaseText);
            this.mArrowView.animate().rotation(0.0f).start();
        }
    }

    @Override
    public void onActionTriggered() {
        this.mIsLoading = true;
        this.mLoadingView.setVisibility(0);
        this.mLoadingView.start();
        this.mArrowView.setVisibility(8);
        this.mTextView.setVisibility(8);
    }

    @Override
    public void onActionFinished() {
        this.mIsLoading = false;
        this.mLoadingView.stop();
        this.mLoadingView.setVisibility(8);
        this.mArrowView.setVisibility(0);
        this.mTextView.setVisibility(0);
    }
}

