/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.popup;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.AnimRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.layout.QMUIFrameLayout;
import com.qmuiteam.qmui.layout.QMUILayoutHelper;
import com.qmuiteam.qmui.skin.IQMUISkinDispatchInterceptor;
import com.qmuiteam.qmui.skin.QMUISkinHelper;
import com.qmuiteam.qmui.skin.QMUISkinValueBuilder;
import com.qmuiteam.qmui.util.QMUIResHelper;
import com.qmuiteam.qmui.widget.popup.QMUIBasePopup;
import com.qmuiteam.qmui.widget.popup.QMUINormalPopup;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.jetbrains.annotations.NotNull;

public class QMUINormalPopup<T extends QMUIBasePopup>
extends QMUIBasePopup<T> {
    public static final int ANIM_AUTO = 0;
    public static final int ANIM_GROW_FROM_LEFT = 1;
    public static final int ANIM_GROW_FROM_RIGHT = 2;
    public static final int ANIM_GROW_FROM_CENTER = 3;
    public static final int ANIM_SPEC = 4;
    public static final int DIRECTION_TOP = 0;
    public static final int DIRECTION_BOTTOM = 1;
    public static final int DIRECTION_CENTER_IN_SCREEN = 2;
    @AnimStyle
    protected int mAnimStyle;
    protected int mSpecAnimStyle;
    private int mEdgeProtectionTop;
    private int mEdgeProtectionLeft;
    private int mEdgeProtectionRight;
    private int mEdgeProtectionBottom;
    private boolean mShowArrow = true;
    private boolean mAddShadow = false;
    private int mRadius = -1;
    private int mBorderColor = 0;
    private int mBorderUsedColor = 0;
    private int mBorderColorAttr = R.attr.qmui_skin_support_popup_border_color;
    private boolean mIsBorderColorSet = false;
    private int mBorderWidth = -1;
    private int mShadowElevation = -1;
    private float mShadowAlpha = 0.0f;
    private int mShadowInset = -1;
    private int mBgColor = 0;
    private boolean mIsBgColorSet = false;
    private int mBgUsedColor = 0;
    private int mBgColorAttr = R.attr.qmui_skin_support_popup_bg;
    private int mOffsetX = 0;
    private int mOffsetYIfTop = 0;
    private int mOffsetYIfBottom = 0;
    private int mPreferredDirection = 1;
    protected final int mInitWidth;
    protected final int mInitHeight;
    private int mArrowWidth = -1;
    private int mArrowHeight = -1;
    private boolean mRemoveBorderWhenShadow = false;
    private View mContentView;

    public QMUINormalPopup(Context context, int width, int height) {
        super(context);
        this.mInitWidth = width;
        this.mInitHeight = height;
    }

    public T arrow(boolean showArrow) {
        this.mShowArrow = showArrow;
        return (T)this;
    }

    public T arrowSize(int width, int height) {
        this.mArrowWidth = width;
        this.mArrowHeight = height;
        return (T)this;
    }

    public T shadow(boolean addShadow) {
        this.mAddShadow = addShadow;
        return (T)this;
    }

    public T removeBorderWhenShadow(boolean removeBorderWhenShadow) {
        this.mRemoveBorderWhenShadow = removeBorderWhenShadow;
        return (T)this;
    }

    public T animStyle(@AnimStyle int animStyle) {
        this.mAnimStyle = animStyle;
        return (T)this;
    }

    public T customAnimStyle(@AnimRes int animStyle) {
        this.mAnimStyle = 4;
        this.mSpecAnimStyle = animStyle;
        return (T)this;
    }

    public T radius(int radius) {
        this.mRadius = radius;
        return (T)this;
    }

    public T shadowElevation(int shadowElevation, float shadowAlpha) {
        this.mShadowAlpha = shadowAlpha;
        this.mShadowElevation = shadowElevation;
        return (T)this;
    }

    public T shadowInset(int shadowInset) {
        this.mShadowInset = shadowInset;
        return (T)this;
    }

    public T edgeProtection(int distance) {
        this.mEdgeProtectionLeft = distance;
        this.mEdgeProtectionRight = distance;
        this.mEdgeProtectionTop = distance;
        this.mEdgeProtectionBottom = distance;
        return (T)this;
    }

    public T edgeProtection(int left, int top, int right, int bottom) {
        this.mEdgeProtectionLeft = left;
        this.mEdgeProtectionTop = top;
        this.mEdgeProtectionRight = right;
        this.mEdgeProtectionBottom = bottom;
        return (T)this;
    }

    public T offsetX(int offsetX) {
        this.mOffsetX = offsetX;
        return (T)this;
    }

    public T offsetYIfTop(int y) {
        this.mOffsetYIfTop = y;
        return (T)this;
    }

    public T offsetYIfBottom(int y) {
        this.mOffsetYIfBottom = y;
        return (T)this;
    }

    public T preferredDirection(int preferredDirection) {
        this.mPreferredDirection = preferredDirection;
        return (T)this;
    }

    public T view(View contentView) {
        this.mContentView = contentView;
        return (T)this;
    }

    public T view(@LayoutRes int contentViewResId) {
        return this.view(LayoutInflater.from((Context)this.mContext).inflate(contentViewResId, null));
    }

    public T borderWidth(int borderWidth) {
        this.mBorderWidth = borderWidth;
        return (T)this;
    }

    public T borderColor(int borderColor) {
        this.mBorderColor = borderColor;
        this.mIsBorderColorSet = true;
        return (T)this;
    }

    public int getBgColor() {
        return this.mBgColor;
    }

    public int getBgColorAttr() {
        return this.mBgColorAttr;
    }

    public int getBorderColor() {
        return this.mBorderColor;
    }

    public int getBorderColorAttr() {
        return this.mBorderColorAttr;
    }

    public T bgColor(int bgColor) {
        this.mBgColor = bgColor;
        this.mIsBgColorSet = true;
        return (T)this;
    }

    public T borderColorAttr(int borderColorAttr) {
        this.mBorderColorAttr = borderColorAttr;
        if (borderColorAttr != 0) {
            this.mIsBorderColorSet = false;
        }
        return (T)this;
    }

    public T bgColorAttr(int bgColorAttr) {
        this.mBgColorAttr = bgColorAttr;
        if (bgColorAttr != 0) {
            this.mIsBgColorSet = false;
        }
        return (T)this;
    }

    private boolean shouldShowShadow() {
        return this.mAddShadow && QMUILayoutHelper.useFeature();
    }

    public T show(@NonNull View anchor) {
        return this.show(anchor, 0, 0, anchor.getWidth(), anchor.getHeight());
    }

    public T show(@NonNull View anchor, int anchorAreaLeft, int anchorAreaTop, int anchorAreaRight, int anchorAreaBottom) {
        if (this.mContentView == null) {
            throw new RuntimeException("you should call view() to set your content view");
        }
        ShowInfo showInfo = new ShowInfo(anchor, anchorAreaLeft, anchorAreaTop, anchorAreaRight, anchorAreaBottom);
        this.calculateWindowSize(showInfo);
        this.calculateXY(showInfo);
        this.adjustShowInfo(showInfo);
        this.decorateContentView(showInfo);
        this.setAnimationStyle(showInfo.anchorProportion(), showInfo.direction);
        this.mWindow.setWidth(showInfo.windowWidth());
        this.mWindow.setHeight(showInfo.windowHeight());
        this.showAtLocation(anchor, showInfo.getWindowX(), showInfo.getWindowY());
        return (T)this;
    }

    private void decorateContentView(ShowInfo showInfo) {
        ContentView contentView = ContentView.wrap(this.mContentView, this.mInitWidth, this.mInitHeight);
        QMUISkinValueBuilder builder = QMUISkinValueBuilder.acquire();
        if (this.mIsBorderColorSet) {
            this.mBorderUsedColor = this.mBorderColor;
        } else if (this.mBorderColorAttr != 0) {
            this.mBorderUsedColor = QMUIResHelper.getAttrColor(this.mContext, this.mBorderColorAttr);
            builder.border(this.mBorderColorAttr);
        }
        if (this.mIsBgColorSet) {
            this.mBgUsedColor = this.mBgColor;
        } else if (this.mBgColorAttr != 0) {
            this.mBgUsedColor = QMUIResHelper.getAttrColor(this.mContext, this.mBgColorAttr);
            builder.background(this.mBgColorAttr);
        }
        if (this.mBorderWidth == -1) {
            this.mBorderWidth = QMUIResHelper.getAttrDimen(this.mContext, R.attr.qmui_popup_border_width);
        }
        QMUISkinHelper.setSkinValue((View)contentView, builder);
        builder.release();
        contentView.setBackgroundColor(this.mBgUsedColor);
        contentView.setBorderColor(this.mBorderUsedColor);
        contentView.setBorderWidth(this.mBorderWidth);
        contentView.setShowBorderOnlyBeforeL(this.mRemoveBorderWhenShadow);
        if (this.mRadius == -1) {
            this.mRadius = QMUIResHelper.getAttrDimen(this.mContext, R.attr.qmui_popup_radius);
        }
        if (this.shouldShowShadow()) {
            contentView.setRadiusAndShadow(this.mRadius, this.mShadowElevation, this.mShadowAlpha);
        } else {
            contentView.setRadius(this.mRadius);
        }
        DecorRootView decorRootView = new DecorRootView(this.mContext, showInfo);
        decorRootView.setContentView((View)contentView);
        this.mWindow.setContentView((View)decorRootView);
    }

    private void adjustShowInfo(ShowInfo showInfo) {
        if (this.shouldShowShadow()) {
            if (this.mShadowElevation == -1) {
                this.mShadowElevation = QMUIResHelper.getAttrDimen(this.mContext, R.attr.qmui_popup_shadow_elevation);
                this.mShadowAlpha = QMUIResHelper.getAttrFloatValue(this.mContext, R.attr.qmui_popup_shadow_alpha);
            }
            if (this.mShadowInset == -1) {
                this.mShadowInset = QMUIResHelper.getAttrDimen(this.mContext, R.attr.qmui_popup_shadow_inset);
            }
            int originX = showInfo.x;
            int originY = showInfo.y;
            if (originX - this.mShadowInset > showInfo.visibleWindowFrame.left) {
                showInfo.x -= this.mShadowInset;
                showInfo.decorationLeft = this.mShadowInset;
            } else {
                showInfo.decorationLeft = originX - showInfo.visibleWindowFrame.left;
                showInfo.x = showInfo.visibleWindowFrame.left;
            }
            showInfo.decorationRight = originX + showInfo.width + this.mShadowInset < showInfo.visibleWindowFrame.right ? this.mShadowInset : showInfo.visibleWindowFrame.right - originX - showInfo.width;
            if (originY - this.mShadowInset > showInfo.visibleWindowFrame.top) {
                showInfo.y -= this.mShadowInset;
                showInfo.decorationTop = this.mShadowInset;
            } else {
                showInfo.decorationTop = originY - showInfo.visibleWindowFrame.top;
                showInfo.y = showInfo.visibleWindowFrame.top;
            }
            showInfo.decorationBottom = originY + showInfo.height + this.mShadowInset < showInfo.visibleWindowFrame.bottom ? this.mShadowInset : showInfo.visibleWindowFrame.bottom - originY - showInfo.height;
        }
        if (this.mShowArrow && showInfo.direction != 2) {
            if (this.mArrowWidth == -1) {
                this.mArrowWidth = QMUIResHelper.getAttrDimen(this.mContext, R.attr.qmui_popup_arrow_width);
            }
            if (this.mArrowHeight == -1) {
                this.mArrowHeight = QMUIResHelper.getAttrDimen(this.mContext, R.attr.qmui_popup_arrow_height);
            }
            if (showInfo.direction == 1) {
                if (this.shouldShowShadow()) {
                    showInfo.y += this.mArrowHeight;
                }
                showInfo.decorationTop = Math.max(showInfo.decorationTop, this.mArrowHeight);
            } else if (showInfo.direction == 0) {
                showInfo.decorationBottom = Math.max(showInfo.decorationBottom, this.mArrowHeight);
                showInfo.y -= this.mArrowHeight;
            }
        }
    }

    private void calculateXY(ShowInfo showInfo) {
        showInfo.x = showInfo.anchorCenter < showInfo.visibleWindowFrame.left + showInfo.getVisibleWidth() / 2 ? Math.max(this.mEdgeProtectionLeft + showInfo.visibleWindowFrame.left, showInfo.anchorCenter - showInfo.width / 2 + this.mOffsetX) : Math.min(showInfo.visibleWindowFrame.right - this.mEdgeProtectionRight - showInfo.width, showInfo.anchorCenter - showInfo.width / 2 + this.mOffsetX);
        int nextDirection = 2;
        if (this.mPreferredDirection == 1) {
            nextDirection = 0;
        } else if (this.mPreferredDirection == 0) {
            nextDirection = 1;
        }
        this.handleDirection(showInfo, this.mPreferredDirection, nextDirection);
    }

    private void handleDirection(ShowInfo showInfo, int currentDirection, int nextDirection) {
        if (currentDirection == 2) {
            showInfo.x = showInfo.visibleWindowFrame.left + (showInfo.getVisibleWidth() - showInfo.width) / 2;
            showInfo.y = showInfo.visibleWindowFrame.top + (showInfo.getVisibleHeight() - showInfo.height) / 2;
            showInfo.direction = 2;
        } else if (currentDirection == 0) {
            showInfo.y = ((ShowInfo)showInfo).anchorFrame.top - showInfo.height - this.mOffsetYIfTop;
            if (showInfo.y < this.mEdgeProtectionTop + showInfo.visibleWindowFrame.top) {
                this.handleDirection(showInfo, nextDirection, 2);
            } else {
                showInfo.direction = 0;
            }
        } else if (currentDirection == 1) {
            showInfo.y = ((ShowInfo)showInfo).anchorFrame.top + showInfo.anchorHeight + this.mOffsetYIfBottom;
            if (showInfo.y > showInfo.visibleWindowFrame.bottom - this.mEdgeProtectionBottom - showInfo.height) {
                this.handleDirection(showInfo, nextDirection, 2);
            } else {
                showInfo.direction = 1;
            }
        }
    }

    protected int proxyWidth(int width) {
        return width;
    }

    protected int proxyHeight(int height) {
        return height;
    }

    private void calculateWindowSize(ShowInfo showInfo) {
        boolean needMeasureForWidth = false;
        boolean needMeasureForHeight = false;
        if (this.mInitWidth > 0) {
            showInfo.width = this.proxyWidth(this.mInitWidth);
            showInfo.contentWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)showInfo.width, (int)0x40000000);
        } else {
            int maxWidth = showInfo.getVisibleWidth() - this.mEdgeProtectionLeft - this.mEdgeProtectionRight;
            if (this.mInitWidth == -1) {
                showInfo.width = this.proxyWidth(maxWidth);
                showInfo.contentWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)showInfo.width, (int)0x40000000);
            } else {
                needMeasureForWidth = true;
                showInfo.contentWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.proxyWidth(maxWidth), (int)Integer.MIN_VALUE);
            }
        }
        if (this.mInitHeight > 0) {
            showInfo.height = this.proxyHeight(this.mInitHeight);
            showInfo.contentHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)showInfo.height, (int)0x40000000);
        } else {
            int maxHeight = showInfo.getVisibleHeight() - this.mEdgeProtectionTop - this.mEdgeProtectionBottom;
            if (this.mInitHeight == -1) {
                showInfo.height = this.proxyHeight(maxHeight);
                showInfo.contentHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)showInfo.height, (int)0x40000000);
            } else {
                needMeasureForHeight = true;
                showInfo.contentHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.proxyHeight(maxHeight), (int)Integer.MIN_VALUE);
            }
        }
        if (needMeasureForWidth || needMeasureForHeight) {
            this.mContentView.measure(showInfo.contentWidthMeasureSpec, showInfo.contentHeightMeasureSpec);
            if (needMeasureForWidth) {
                showInfo.width = this.proxyWidth(this.mContentView.getMeasuredWidth());
            }
            if (needMeasureForHeight) {
                showInfo.height = this.proxyHeight(this.mContentView.getMeasuredHeight());
            }
        }
    }

    private void setAnimationStyle(float anchorProportion, int direction) {
        boolean onTop = direction == 0;
        switch (this.mAnimStyle) {
            case 1: {
                this.mWindow.setAnimationStyle(onTop ? R.style.QMUI_Animation_PopUpMenu_Left : R.style.QMUI_Animation_PopDownMenu_Left);
                break;
            }
            case 2: {
                this.mWindow.setAnimationStyle(onTop ? R.style.QMUI_Animation_PopUpMenu_Right : R.style.QMUI_Animation_PopDownMenu_Right);
                break;
            }
            case 3: {
                this.mWindow.setAnimationStyle(onTop ? R.style.QMUI_Animation_PopUpMenu_Center : R.style.QMUI_Animation_PopDownMenu_Center);
                break;
            }
            case 0: {
                if (anchorProportion <= 0.25f) {
                    this.mWindow.setAnimationStyle(onTop ? R.style.QMUI_Animation_PopUpMenu_Left : R.style.QMUI_Animation_PopDownMenu_Left);
                    break;
                }
                if (anchorProportion > 0.25f && anchorProportion < 0.75f) {
                    this.mWindow.setAnimationStyle(onTop ? R.style.QMUI_Animation_PopUpMenu_Center : R.style.QMUI_Animation_PopDownMenu_Center);
                    break;
                }
                this.mWindow.setAnimationStyle(onTop ? R.style.QMUI_Animation_PopUpMenu_Right : R.style.QMUI_Animation_PopDownMenu_Right);
                break;
            }
            case 4: {
                this.mWindow.setAnimationStyle(this.mSpecAnimStyle);
            }
        }
    }

    static /* synthetic */ int access$000(QMUINormalPopup x0) {
        return x0.mPreferredDirection;
    }

    class DecorRootView
    extends FrameLayout
    implements IQMUISkinDispatchInterceptor {
        private ShowInfo mShowInfo;
        private View mContentView;
        private Paint mArrowPaint;
        private Path mArrowPath;
        private RectF mArrowSaveRect;
        private PorterDuffXfermode mArrowAlignMode;
        private int mPendingWidth;
        private int mPendingHeight;
        private Runnable mUpdateWindowAction;

        private DecorRootView(Context context, ShowInfo showInfo) {
            super(context);
            this.mArrowSaveRect = new RectF();
            this.mArrowAlignMode = new PorterDuffXfermode(PorterDuff.Mode.DST_OUT);
            this.mUpdateWindowAction = new Runnable(){

                @Override
                public void run() {
                    ((DecorRootView)DecorRootView.this).mShowInfo.width = DecorRootView.this.mPendingWidth;
                    ((DecorRootView)DecorRootView.this).mShowInfo.height = DecorRootView.this.mPendingHeight;
                    QMUINormalPopup.this.calculateXY(DecorRootView.this.mShowInfo);
                    QMUINormalPopup.this.adjustShowInfo(DecorRootView.this.mShowInfo);
                    QMUINormalPopup.this.mWindow.update(DecorRootView.this.mShowInfo.getWindowX(), DecorRootView.this.mShowInfo.getWindowY(), DecorRootView.this.mShowInfo.windowWidth(), DecorRootView.this.mShowInfo.windowHeight());
                }
            };
            this.mShowInfo = showInfo;
            this.mArrowPaint = new Paint();
            this.mArrowPaint.setAntiAlias(true);
            this.mArrowPath = new Path();
        }

        public void setContentView(View contentView) {
            if (this.mContentView != null) {
                this.removeView(this.mContentView);
            }
            if (contentView.getParent() != null) {
                ((ViewGroup)contentView.getParent()).removeView(contentView);
            }
            this.mContentView = contentView;
            this.addView(contentView);
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            this.removeCallbacks(this.mUpdateWindowAction);
            if (this.mContentView != null) {
                this.mContentView.measure(this.mShowInfo.contentWidthMeasureSpec, this.mShowInfo.contentHeightMeasureSpec);
                int measuredWidth = this.mContentView.getMeasuredWidth();
                int measuredHeight = this.mContentView.getMeasuredHeight();
                if (this.mShowInfo.width != measuredWidth || this.mShowInfo.height != measuredHeight) {
                    this.mPendingWidth = measuredWidth;
                    this.mPendingHeight = measuredHeight;
                    this.post(this.mUpdateWindowAction);
                }
            }
            this.setMeasuredDimension(this.mShowInfo.windowWidth(), this.mShowInfo.windowHeight());
        }

        protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
            if (this.mContentView != null) {
                this.mContentView.layout(this.mShowInfo.decorationLeft, this.mShowInfo.decorationTop, this.mShowInfo.width + this.mShowInfo.decorationLeft, this.mShowInfo.height + this.mShowInfo.decorationTop);
            }
        }

        protected void onAttachedToWindow() {
            super.onAttachedToWindow();
            this.removeCallbacks(this.mUpdateWindowAction);
        }

        @Override
        public boolean intercept(int skinIndex, @NotNull Resources.Theme theme) {
            if (!QMUINormalPopup.this.mIsBorderColorSet && QMUINormalPopup.this.mBorderColorAttr != 0) {
                QMUINormalPopup.this.mBorderUsedColor = QMUIResHelper.getAttrColor(theme, QMUINormalPopup.this.mBorderColorAttr);
            }
            if (!QMUINormalPopup.this.mIsBgColorSet && QMUINormalPopup.this.mBgColorAttr != 0) {
                QMUINormalPopup.this.mBgUsedColor = QMUIResHelper.getAttrColor(theme, QMUINormalPopup.this.mBgColorAttr);
            }
            return false;
        }

        protected void dispatchDraw(Canvas canvas) {
            super.dispatchDraw(canvas);
            if (QMUINormalPopup.this.mShowArrow) {
                if (this.mShowInfo.direction == 0) {
                    canvas.save();
                    this.mArrowSaveRect.set(0.0f, 0.0f, (float)this.mShowInfo.width, (float)this.mShowInfo.height);
                    this.mArrowPaint.setStyle(Paint.Style.FILL);
                    this.mArrowPaint.setColor(QMUINormalPopup.this.mBgUsedColor);
                    this.mArrowPaint.setXfermode(null);
                    int l = this.mShowInfo.anchorCenter - this.mShowInfo.x - QMUINormalPopup.this.mArrowWidth / 2;
                    l = Math.min(Math.max(l, this.mShowInfo.decorationLeft), this.getWidth() - this.mShowInfo.decorationRight - QMUINormalPopup.this.mArrowWidth);
                    int t = this.mShowInfo.decorationTop + this.mShowInfo.height - QMUINormalPopup.this.mBorderWidth;
                    canvas.translate((float)l, (float)t);
                    this.mArrowPath.reset();
                    this.mArrowPath.setLastPoint((float)(-QMUINormalPopup.this.mArrowWidth) / 2.0f, (float)(-QMUINormalPopup.this.mArrowHeight));
                    this.mArrowPath.lineTo((float)QMUINormalPopup.this.mArrowWidth / 2.0f, (float)QMUINormalPopup.this.mArrowHeight);
                    this.mArrowPath.lineTo((float)(QMUINormalPopup.this.mArrowWidth * 3) / 2.0f, (float)(-QMUINormalPopup.this.mArrowHeight));
                    this.mArrowPath.close();
                    canvas.drawPath(this.mArrowPath, this.mArrowPaint);
                    if (!QMUINormalPopup.this.mRemoveBorderWhenShadow || !QMUINormalPopup.this.shouldShowShadow()) {
                        this.mArrowSaveRect.set(0.0f, (float)(-QMUINormalPopup.this.mBorderWidth), (float)QMUINormalPopup.this.mArrowWidth, (float)(QMUINormalPopup.this.mArrowHeight + QMUINormalPopup.this.mBorderWidth));
                        int saveLayer = canvas.saveLayer(this.mArrowSaveRect, this.mArrowPaint, 31);
                        this.mArrowPaint.setStrokeWidth((float)QMUINormalPopup.this.mBorderWidth);
                        this.mArrowPaint.setColor(QMUINormalPopup.this.mBorderUsedColor);
                        this.mArrowPaint.setStyle(Paint.Style.STROKE);
                        canvas.drawPath(this.mArrowPath, this.mArrowPaint);
                        this.mArrowPaint.setXfermode((Xfermode)this.mArrowAlignMode);
                        this.mArrowPaint.setStyle(Paint.Style.FILL);
                        canvas.drawRect(0.0f, (float)(-QMUINormalPopup.this.mBorderWidth), (float)QMUINormalPopup.this.mArrowWidth, 0.0f, this.mArrowPaint);
                        canvas.restoreToCount(saveLayer);
                    }
                    canvas.restore();
                } else if (this.mShowInfo.direction == 1) {
                    canvas.save();
                    this.mArrowPaint.setStyle(Paint.Style.FILL);
                    this.mArrowPaint.setXfermode(null);
                    this.mArrowPaint.setColor(QMUINormalPopup.this.mBgUsedColor);
                    int l = this.mShowInfo.anchorCenter - this.mShowInfo.x - QMUINormalPopup.this.mArrowWidth / 2;
                    l = Math.min(Math.max(l, this.mShowInfo.decorationLeft), this.getWidth() - this.mShowInfo.decorationRight - QMUINormalPopup.this.mArrowWidth);
                    int t = this.mShowInfo.decorationTop + QMUINormalPopup.this.mBorderWidth;
                    canvas.translate((float)l, (float)t);
                    this.mArrowPath.reset();
                    this.mArrowPath.setLastPoint((float)(-QMUINormalPopup.this.mArrowWidth) / 2.0f, (float)QMUINormalPopup.this.mArrowHeight);
                    this.mArrowPath.lineTo((float)QMUINormalPopup.this.mArrowWidth / 2.0f, (float)(-QMUINormalPopup.this.mArrowHeight));
                    this.mArrowPath.lineTo((float)(QMUINormalPopup.this.mArrowWidth * 3) / 2.0f, (float)QMUINormalPopup.this.mArrowHeight);
                    this.mArrowPath.close();
                    canvas.drawPath(this.mArrowPath, this.mArrowPaint);
                    if (!QMUINormalPopup.this.mRemoveBorderWhenShadow || !QMUINormalPopup.this.shouldShowShadow()) {
                        this.mArrowSaveRect.set(0.0f, (float)(-QMUINormalPopup.this.mArrowHeight - QMUINormalPopup.this.mBorderWidth), (float)QMUINormalPopup.this.mArrowWidth, (float)QMUINormalPopup.this.mBorderWidth);
                        int saveLayer = canvas.saveLayer(this.mArrowSaveRect, this.mArrowPaint, 31);
                        this.mArrowPaint.setStrokeWidth((float)QMUINormalPopup.this.mBorderWidth);
                        this.mArrowPaint.setStyle(Paint.Style.STROKE);
                        this.mArrowPaint.setColor(QMUINormalPopup.this.mBorderUsedColor);
                        canvas.drawPath(this.mArrowPath, this.mArrowPaint);
                        this.mArrowPaint.setXfermode((Xfermode)this.mArrowAlignMode);
                        this.mArrowPaint.setStyle(Paint.Style.FILL);
                        canvas.drawRect(0.0f, 0.0f, (float)QMUINormalPopup.this.mArrowWidth, (float)QMUINormalPopup.this.mBorderWidth, this.mArrowPaint);
                        canvas.restoreToCount(saveLayer);
                    }
                    canvas.restore();
                }
            }
        }
    }

    static class ContentView
    extends QMUIFrameLayout {
        private ContentView(Context context) {
            super(context);
        }

        static ContentView wrap(View businessView, int width, int height) {
            ContentView contentView = new ContentView(businessView.getContext());
            if (businessView.getParent() != null) {
                ((ViewGroup)businessView.getParent()).removeView(businessView);
            }
            contentView.addView(businessView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(width, height));
            return contentView;
        }
    }

    class ShowInfo {
        private int[] anchorRootLocation = new int[2];
        private Rect anchorFrame = new Rect();
        Rect visibleWindowFrame = new Rect();
        int width;
        int height;
        int x;
        int y;
        int anchorHeight;
        int anchorCenter;
        int direction = QMUINormalPopup.access$000(QMUINormalPopup.this);
        int contentWidthMeasureSpec;
        int contentHeightMeasureSpec;
        int decorationLeft = 0;
        int decorationRight = 0;
        int decorationTop = 0;
        int decorationBottom = 0;

        ShowInfo(View anchor, int anchorAreaLeft, int anchorAreaTop, int anchorAreaRight, int anchorAreaBottom) {
            this.anchorHeight = anchorAreaBottom - anchorAreaTop;
            anchor.getRootView().getLocationOnScreen(this.anchorRootLocation);
            int[] anchorLocation = new int[2];
            anchor.getLocationOnScreen(anchorLocation);
            this.anchorCenter = anchorLocation[0] + (anchorAreaLeft + anchorAreaRight) / 2;
            anchor.getWindowVisibleDisplayFrame(this.visibleWindowFrame);
            this.anchorFrame.left = anchorLocation[0] + anchorAreaLeft;
            this.anchorFrame.top = anchorLocation[1] + anchorAreaTop;
            this.anchorFrame.right = anchorLocation[0] + anchorAreaRight;
            this.anchorFrame.bottom = anchorLocation[1] + anchorAreaBottom;
        }

        ShowInfo(View anchor) {
            this(anchor, 0, 0, anchor.getWidth(), anchor.getHeight());
        }

        float anchorProportion() {
            return (float)(this.anchorCenter - this.x) / (float)this.width;
        }

        int windowWidth() {
            return this.decorationLeft + this.width + this.decorationRight;
        }

        int windowHeight() {
            return this.decorationTop + this.height + this.decorationBottom;
        }

        int getVisibleWidth() {
            return this.visibleWindowFrame.width();
        }

        int getVisibleHeight() {
            return this.visibleWindowFrame.height();
        }

        int getWindowX() {
            return this.x - this.anchorRootLocation[0];
        }

        int getWindowY() {
            return this.y - this.anchorRootLocation[1];
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Direction {
    }
}

