/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.dialog;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.Space;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.layout.QMUIButton;
import com.qmuiteam.qmui.layout.QMUILinearLayout;
import com.qmuiteam.qmui.skin.QMUISkinHelper;
import com.qmuiteam.qmui.skin.QMUISkinManager;
import com.qmuiteam.qmui.skin.QMUISkinValueBuilder;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.util.QMUIResHelper;
import com.qmuiteam.qmui.widget.QMUIWrapContentScrollView;
import com.qmuiteam.qmui.widget.dialog.QMUIDialog;
import com.qmuiteam.qmui.widget.dialog.QMUIDialogAction;
import com.qmuiteam.qmui.widget.dialog.QMUIDialogRootLayout;
import com.qmuiteam.qmui.widget.dialog.QMUIDialogView;
import com.qmuiteam.qmui.widget.textview.QMUISpanTouchFixTextView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public abstract class QMUIDialogBuilder<T extends QMUIDialogBuilder> {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private static OnProvideDefaultTheme sOnProvideDefaultTheme = null;
    private Context mContext;
    protected QMUIDialog mDialog;
    protected String mTitle;
    private boolean mCancelable = true;
    private boolean mCanceledOnTouchOutside = true;
    protected QMUIDialogRootLayout mRootView;
    protected QMUIDialogView mDialogView;
    protected List<QMUIDialogAction> mActions = new ArrayList<QMUIDialogAction>();
    private QMUIDialogView.OnDecorationListener mOnDecorationListener;
    private int mActionContainerOrientation = 0;
    private boolean mChangeAlphaForPressOrDisable = true;
    private int mActionDividerThickness = 0;
    private int mActionDividerColorAttr = R.attr.qmui_skin_support_dialog_action_divider_color;
    private int mActionDividerInsetStart = 0;
    private int mActionDividerInsetEnd = 0;
    private int mActionDividerColor = 0;
    private boolean mCheckKeyboardOverlay = false;
    private QMUISkinManager mSkinManager;
    private float mMaxPercent = 0.75f;

    public static void setOnProvideDefaultTheme(OnProvideDefaultTheme onProvideDefaultTheme) {
        sOnProvideDefaultTheme = onProvideDefaultTheme;
    }

    public QMUIDialogBuilder(Context context) {
        this.mContext = context;
    }

    public Context getBaseContext() {
        return this.mContext;
    }

    public T setTitle(String title) {
        if (title != null && title.length() > 0) {
            this.mTitle = title + this.mContext.getString(R.string.qmui_tool_fixellipsize);
        }
        return (T)this;
    }

    public T setTitle(int resId) {
        return this.setTitle(this.mContext.getResources().getString(resId));
    }

    public T setCancelable(boolean cancelable) {
        this.mCancelable = cancelable;
        return (T)this;
    }

    public T setCanceledOnTouchOutside(boolean canceledOnTouchOutside) {
        this.mCanceledOnTouchOutside = canceledOnTouchOutside;
        return (T)this;
    }

    public T setOnDecorationListener(QMUIDialogView.OnDecorationListener onDecorationListener) {
        this.mOnDecorationListener = onDecorationListener;
        return (T)this;
    }

    public T setActionContainerOrientation(int actionContainerOrientation) {
        this.mActionContainerOrientation = actionContainerOrientation;
        return (T)this;
    }

    public T setChangeAlphaForPressOrDisable(boolean changeAlphaForPressOrDisable) {
        this.mChangeAlphaForPressOrDisable = changeAlphaForPressOrDisable;
        return (T)this;
    }

    public T setActionDivider(int thickness, int colorAttr, int startInset, int endInset) {
        this.mActionDividerThickness = thickness;
        this.mActionDividerColorAttr = colorAttr;
        this.mActionDividerInsetStart = startInset;
        this.mActionDividerInsetEnd = endInset;
        return (T)this;
    }

    public T setActionDividerInsetAndThickness(int thickness, int startInset, int endInset) {
        this.mActionDividerThickness = thickness;
        this.mActionDividerInsetStart = startInset;
        this.mActionDividerInsetEnd = endInset;
        return (T)this;
    }

    public T setActionDividerColorAttr(int colorAttr) {
        this.mActionDividerColorAttr = colorAttr;
        return (T)this;
    }

    public T setActionDividerColor(int color) {
        this.mActionDividerColor = color;
        this.mActionDividerColorAttr = 0;
        return (T)this;
    }

    public T setCheckKeyboardOverlay(boolean checkKeyboardOverlay) {
        this.mCheckKeyboardOverlay = checkKeyboardOverlay;
        return (T)this;
    }

    public T setSkinManager(@Nullable QMUISkinManager skinManager) {
        this.mSkinManager = skinManager;
        return (T)this;
    }

    public T setMaxPercent(float maxPercent) {
        this.mMaxPercent = maxPercent;
        return (T)this;
    }

    public T addAction(@Nullable QMUIDialogAction action) {
        if (action != null) {
            this.mActions.add(action);
        }
        return (T)this;
    }

    public T addAction(int strResId, QMUIDialogAction.ActionListener listener) {
        return this.addAction(0, strResId, listener);
    }

    public T addAction(CharSequence str, QMUIDialogAction.ActionListener listener) {
        return this.addAction(0, str, 1, listener);
    }

    public T addAction(int iconResId, int strResId, QMUIDialogAction.ActionListener listener) {
        return this.addAction(iconResId, strResId, 1, listener);
    }

    public T addAction(int iconResId, CharSequence str, QMUIDialogAction.ActionListener listener) {
        return this.addAction(iconResId, str, 1, listener);
    }

    public T addAction(int iconRes, int strRes, int prop, QMUIDialogAction.ActionListener listener) {
        return this.addAction(iconRes, this.mContext.getResources().getString(strRes), prop, listener);
    }

    public T addAction(int iconRes, CharSequence str, int prop, QMUIDialogAction.ActionListener listener) {
        QMUIDialogAction action = new QMUIDialogAction(str).iconRes(iconRes).prop(prop).onClick(listener);
        this.mActions.add(action);
        return (T)this;
    }

    protected boolean hasTitle() {
        return this.mTitle != null && this.mTitle.length() != 0;
    }

    public QMUIDialog show() {
        QMUIDialog dialog = this.create();
        dialog.show();
        return dialog;
    }

    public QMUIDialog create() {
        int theme;
        if (sOnProvideDefaultTheme != null && (theme = sOnProvideDefaultTheme.getThemeForBuilder(this)) > 0) {
            return this.create(theme);
        }
        return this.create(R.style.QMUI_Dialog);
    }

    @SuppressLint(value={"InflateParams"})
    public QMUIDialog create(@StyleRes int style2) {
        ConstraintLayout.LayoutParams lp;
        this.mDialog = new QMUIDialog(this.mContext, style2);
        Context dialogContext = this.mDialog.getContext();
        this.mDialogView = this.onCreateDialogView(dialogContext);
        this.mRootView = new QMUIDialogRootLayout(dialogContext, this.mDialogView, this.onCreateDialogLayoutParams());
        this.mRootView.setCheckKeyboardOverlay(this.mCheckKeyboardOverlay);
        this.mRootView.setOverlayOccurInMeasureCallback(new QMUIDialogRootLayout.OverlayOccurInMeasureCallback(){

            @Override
            public void call() {
                QMUIDialogBuilder.this.onOverlayOccurredInMeasure();
            }
        });
        this.mRootView.setMaxPercent(this.mMaxPercent);
        this.configRootLayout(this.mRootView);
        this.mDialogView = this.mRootView.getDialogView();
        this.mDialogView.setOnDecorationListener(this.mOnDecorationListener);
        View titleView = this.onCreateTitle(this.mDialog, this.mDialogView, dialogContext);
        View operatorLayout = this.onCreateOperatorLayout(this.mDialog, this.mDialogView, dialogContext);
        View contentLayout = this.onCreateContent(this.mDialog, this.mDialogView, dialogContext);
        this.checkAndSetId(titleView, R.id.qmui_dialog_title_id);
        this.checkAndSetId(operatorLayout, R.id.qmui_dialog_operator_layout_id);
        this.checkAndSetId(contentLayout, R.id.qmui_dialog_content_id);
        if (titleView != null) {
            lp = this.onCreateTitleLayoutParams(dialogContext);
            if (contentLayout != null) {
                lp.bottomToTop = contentLayout.getId();
            } else if (operatorLayout != null) {
                lp.bottomToTop = operatorLayout.getId();
            } else {
                lp.bottomToBottom = 0;
            }
            this.mDialogView.addView(titleView, (ViewGroup.LayoutParams)lp);
        }
        if (contentLayout != null) {
            lp = this.onCreateContentLayoutParams(dialogContext);
            if (titleView != null) {
                lp.topToBottom = titleView.getId();
            } else {
                lp.topToTop = 0;
            }
            if (operatorLayout != null) {
                lp.bottomToTop = operatorLayout.getId();
            } else {
                lp.bottomToBottom = 0;
            }
            this.mDialogView.addView(contentLayout, (ViewGroup.LayoutParams)lp);
        }
        if (operatorLayout != null) {
            lp = this.onCreateOperatorLayoutLayoutParams(dialogContext);
            if (contentLayout != null) {
                lp.topToBottom = contentLayout.getId();
            } else if (titleView != null) {
                lp.topToBottom = titleView.getId();
            } else {
                lp.topToTop = 0;
            }
            this.mDialogView.addView(operatorLayout, (ViewGroup.LayoutParams)lp);
        }
        this.mDialog.addContentView((View)this.mRootView, new ViewGroup.LayoutParams(-2, -2));
        this.mDialog.setCancelable(this.mCancelable);
        this.mDialog.setCanceledOnTouchOutside(this.mCanceledOnTouchOutside);
        this.mDialog.setSkinManager(this.mSkinManager);
        this.onAfterCreate(this.mDialog, this.mRootView, dialogContext);
        return this.mDialog;
    }

    protected void onAfterCreate(@NonNull QMUIDialog dialog, @NonNull QMUIDialogRootLayout rootLayout, @NonNull Context context) {
    }

    protected void onOverlayOccurredInMeasure() {
    }

    private void checkAndSetId(@Nullable View view, int id2) {
        if (view != null && view.getId() == -1) {
            view.setId(id2);
        }
    }

    protected void configRootLayout(@NonNull QMUIDialogRootLayout rootLayout) {
    }

    protected void skinConfigDialogView(QMUIDialogView dialogView) {
        QMUISkinValueBuilder valueBuilder = QMUISkinValueBuilder.acquire();
        valueBuilder.background(R.attr.qmui_skin_support_dialog_bg);
        QMUISkinHelper.setSkinValue((View)dialogView, valueBuilder);
        QMUISkinValueBuilder.release(valueBuilder);
    }

    protected void skinConfigTitleView(TextView titleView) {
        QMUISkinValueBuilder valueBuilder = QMUISkinValueBuilder.acquire();
        valueBuilder.textColor(R.attr.qmui_skin_support_dialog_title_text_color);
        QMUISkinHelper.setSkinValue((View)titleView, valueBuilder);
        QMUISkinValueBuilder.release(valueBuilder);
    }

    protected void skinConfigActionContainer(ViewGroup actionContainer) {
        QMUISkinValueBuilder valueBuilder = QMUISkinValueBuilder.acquire();
        valueBuilder.topSeparator(R.attr.qmui_skin_support_dialog_action_container_separator_color);
        QMUISkinHelper.setSkinValue((View)actionContainer, valueBuilder);
        QMUISkinValueBuilder.release(valueBuilder);
    }

    @NonNull
    protected QMUIDialogView onCreateDialogView(@NonNull Context context) {
        QMUIDialogView dialogView = new QMUIDialogView(context);
        dialogView.setBackground(QMUIResHelper.getAttrDrawable(context, R.attr.qmui_skin_support_dialog_bg));
        dialogView.setRadius(QMUIResHelper.getAttrDimen(context, R.attr.qmui_dialog_radius));
        this.skinConfigDialogView(dialogView);
        return dialogView;
    }

    @NonNull
    protected FrameLayout.LayoutParams onCreateDialogLayoutParams() {
        return new FrameLayout.LayoutParams(-2, -2);
    }

    @Nullable
    protected View onCreateTitle(@NonNull QMUIDialog dialog, @NonNull QMUIDialogView parent, @NonNull Context context) {
        if (this.hasTitle()) {
            QMUISpanTouchFixTextView tv = new QMUISpanTouchFixTextView(context);
            tv.setId(R.id.qmui_dialog_title_id);
            tv.setText(this.mTitle);
            QMUIResHelper.assignTextViewWithAttr((TextView)tv, R.attr.qmui_dialog_title_style);
            this.skinConfigTitleView((TextView)tv);
            return tv;
        }
        return null;
    }

    @NonNull
    protected ConstraintLayout.LayoutParams onCreateTitleLayoutParams(@NonNull Context context) {
        ConstraintLayout.LayoutParams lp = new ConstraintLayout.LayoutParams(0, -2);
        lp.leftToLeft = 0;
        lp.rightToRight = 0;
        lp.topToTop = 0;
        lp.verticalChainStyle = 2;
        return lp;
    }

    @Nullable
    protected abstract View onCreateContent(@NonNull QMUIDialog var1, @NonNull QMUIDialogView var2, @NonNull Context var3);

    protected QMUIWrapContentScrollView wrapWithScroll(@NonNull View view) {
        QMUIWrapContentScrollView scrollView = new QMUIWrapContentScrollView(view.getContext());
        scrollView.addView(view);
        scrollView.setVerticalScrollBarEnabled(false);
        return scrollView;
    }

    protected ConstraintLayout.LayoutParams onCreateContentLayoutParams(@NonNull Context context) {
        ConstraintLayout.LayoutParams lp = new ConstraintLayout.LayoutParams(0, -2);
        lp.leftToLeft = 0;
        lp.rightToRight = 0;
        lp.constrainedHeight = true;
        return lp;
    }

    @Nullable
    protected View onCreateOperatorLayout(@NonNull QMUIDialog dialog, @NonNull QMUIDialogView parent, @NonNull Context context) {
        int size = this.mActions.size();
        if (size > 0) {
            TypedArray a = context.obtainStyledAttributes(null, R.styleable.QMUIDialogActionContainerCustomDef, R.attr.qmui_dialog_action_container_style, 0);
            int count = a.getIndexCount();
            int justifyContent = 1;
            int spaceCustomIndex = 0;
            int actionHeight = -1;
            int actionSpace = 0;
            for (int i = 0; i < count; ++i) {
                int attr2 = a.getIndex(i);
                if (attr2 == R.styleable.QMUIDialogActionContainerCustomDef_qmui_dialog_action_container_justify_content) {
                    justifyContent = a.getInteger(attr2, justifyContent);
                    continue;
                }
                if (attr2 == R.styleable.QMUIDialogActionContainerCustomDef_qmui_dialog_action_container_custom_space_index) {
                    spaceCustomIndex = a.getInteger(attr2, 0);
                    continue;
                }
                if (attr2 == R.styleable.QMUIDialogActionContainerCustomDef_qmui_dialog_action_space) {
                    actionSpace = a.getDimensionPixelSize(attr2, 0);
                    continue;
                }
                if (attr2 != R.styleable.QMUIDialogActionContainerCustomDef_qmui_dialog_action_height) continue;
                actionHeight = a.getDimensionPixelSize(attr2, 0);
            }
            a.recycle();
            int spaceInsertPos = -1;
            if (this.mActionContainerOrientation != 1) {
                if (justifyContent == 0) {
                    spaceInsertPos = size;
                } else if (justifyContent == 1) {
                    spaceInsertPos = 0;
                } else if (justifyContent == 3) {
                    spaceInsertPos = spaceCustomIndex;
                }
            }
            final QMUILinearLayout layout2 = new QMUILinearLayout(context, null, R.attr.qmui_dialog_action_container_style);
            layout2.setId(R.id.qmui_dialog_operator_layout_id);
            layout2.setOrientation(this.mActionContainerOrientation == 1 ? 1 : 0);
            this.skinConfigActionContainer((ViewGroup)layout2);
            for (int i = 0; i < size; ++i) {
                LinearLayout.LayoutParams actionLp;
                if (spaceInsertPos == i) {
                    layout2.addView(this.createActionContainerSpace(context));
                }
                QMUIDialogAction action = this.mActions.get(i);
                action.skinSeparatorColorAttr(this.mActionDividerColorAttr);
                if (this.mActionContainerOrientation == 1) {
                    actionLp = new LinearLayout.LayoutParams(-1, actionHeight);
                } else {
                    actionLp = new LinearLayout.LayoutParams(-2, actionHeight);
                    if (spaceInsertPos >= 0) {
                        if (i >= spaceInsertPos) {
                            actionLp.leftMargin = actionSpace;
                        } else {
                            actionLp.rightMargin = actionSpace;
                        }
                    }
                    if (justifyContent == 2) {
                        actionLp.weight = 1.0f;
                    }
                }
                QMUIButton actionView = action.buildActionView(this.mDialog, i);
                if (this.mActionDividerThickness > 0 && i > 0 && spaceInsertPos != i) {
                    int color;
                    int n = color = this.mActionDividerColorAttr == 0 ? this.mActionDividerColor : QMUISkinHelper.getSkinColor((View)actionView, this.mActionDividerColorAttr);
                    if (this.mActionContainerOrientation == 1) {
                        actionView.onlyShowTopDivider(this.mActionDividerInsetStart, this.mActionDividerInsetEnd, this.mActionDividerThickness, color);
                    } else {
                        actionView.onlyShowLeftDivider(this.mActionDividerInsetStart, this.mActionDividerInsetEnd, this.mActionDividerThickness, color);
                    }
                }
                actionView.setChangeAlphaWhenDisable(this.mChangeAlphaForPressOrDisable);
                actionView.setChangeAlphaWhenPress(this.mChangeAlphaForPressOrDisable);
                layout2.addView((View)actionView, (ViewGroup.LayoutParams)actionLp);
            }
            if (spaceInsertPos == size) {
                layout2.addView(this.createActionContainerSpace(context));
            }
            if (this.mActionContainerOrientation == 0) {
                layout2.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

                    public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                        View lastChild;
                        int width = right - left;
                        int childCount = layout2.getChildCount();
                        if (childCount > 0 && (lastChild = layout2.getChildAt(childCount - 1)).getRight() > width) {
                            int childPaddingHor = Math.max(0, lastChild.getPaddingLeft() - QMUIDisplayHelper.dp2px(QMUIDialogBuilder.this.mContext, 3));
                            for (int i = 0; i < childCount; ++i) {
                                layout2.getChildAt(i).setPadding(childPaddingHor, 0, childPaddingHor, 0);
                            }
                        }
                    }
                });
            }
            return layout2;
        }
        return null;
    }

    @NonNull
    protected ConstraintLayout.LayoutParams onCreateOperatorLayoutLayoutParams(@NonNull Context context) {
        ConstraintLayout.LayoutParams lp = new ConstraintLayout.LayoutParams(0, -2);
        lp.leftToLeft = 0;
        lp.rightToRight = 0;
        lp.bottomToBottom = 0;
        lp.verticalChainStyle = 2;
        return lp;
    }

    private View createActionContainerSpace(Context context) {
        Space space = new Space(context);
        LinearLayout.LayoutParams spaceLp = new LinearLayout.LayoutParams(0, 0);
        spaceLp.weight = 1.0f;
        space.setLayoutParams((ViewGroup.LayoutParams)spaceLp);
        return space;
    }

    public List<QMUIDialogAction> getPositiveAction() {
        ArrayList<QMUIDialogAction> output = new ArrayList<QMUIDialogAction>();
        for (QMUIDialogAction action : this.mActions) {
            if (action.getActionProp() != 0) continue;
            output.add(action);
        }
        return output;
    }

    public static interface OnProvideDefaultTheme {
        public int getThemeForBuilder(QMUIDialogBuilder var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Orientation {
    }
}

