/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.dialog;

import android.content.Context;
import android.content.res.TypedArray;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.util.QMUIResHelper;
import com.qmuiteam.qmui.widget.dialog.QMUIDialog;
import com.qmuiteam.qmui.widget.dialog.QMUIDialogBuilder;
import com.qmuiteam.qmui.widget.dialog.QMUIDialogView;
import com.qmuiteam.qmui.widget.textview.QMUISpanTouchFixTextView;

public class QMUIDialogBlockBuilder
extends QMUIDialogBuilder<QMUIDialogBlockBuilder> {
    private CharSequence mContent;

    public QMUIDialogBlockBuilder(Context context) {
        super(context);
        this.setActionDivider(1, R.attr.qmui_skin_support_dialog_action_divider_color, 0, 0);
    }

    public QMUIDialogBlockBuilder setContent(CharSequence content) {
        this.mContent = content;
        return this;
    }

    public QMUIDialogBlockBuilder setContent(int contentRes) {
        this.mContent = this.getBaseContext().getResources().getString(contentRes);
        return this;
    }

    @Override
    @Nullable
    protected View onCreateTitle(QMUIDialog dialog, QMUIDialogView parent, Context context) {
        View result = super.onCreateTitle(dialog, parent, context);
        if (result != null && (this.mContent == null || this.mContent.length() == 0)) {
            TypedArray a = context.obtainStyledAttributes(null, R.styleable.QMUIDialogTitleTvCustomDef, R.attr.qmui_dialog_title_style, 0);
            int count = a.getIndexCount();
            for (int i = 0; i < count; ++i) {
                int attr2 = a.getIndex(i);
                if (attr2 != R.styleable.QMUIDialogTitleTvCustomDef_qmui_paddingBottomWhenNotContent) continue;
                result.setPadding(result.getPaddingLeft(), result.getPaddingTop(), result.getPaddingRight(), a.getDimensionPixelSize(attr2, result.getPaddingBottom()));
            }
            a.recycle();
        }
        return result;
    }

    @Override
    @Nullable
    protected View onCreateContent(QMUIDialog dialog, QMUIDialogView parent, Context context) {
        if (this.mContent != null && this.mContent.length() > 0) {
            QMUISpanTouchFixTextView contentTv = new QMUISpanTouchFixTextView(context);
            QMUIResHelper.assignTextViewWithAttr((TextView)contentTv, R.attr.qmui_dialog_message_content_style);
            if (!this.hasTitle()) {
                TypedArray a = context.obtainStyledAttributes(null, R.styleable.QMUIDialogMessageTvCustomDef, R.attr.qmui_dialog_message_content_style, 0);
                int count = a.getIndexCount();
                for (int i = 0; i < count; ++i) {
                    int attr2 = a.getIndex(i);
                    if (attr2 != R.styleable.QMUIDialogMessageTvCustomDef_qmui_paddingTopWhenNotTitle) continue;
                    contentTv.setPadding(contentTv.getPaddingLeft(), a.getDimensionPixelSize(attr2, contentTv.getPaddingTop()), contentTv.getPaddingRight(), contentTv.getPaddingBottom());
                }
                a.recycle();
            }
            contentTv.setText(this.mContent);
            return this.wrapWithScroll((View)contentTv);
        }
        return null;
    }

    @Override
    public QMUIDialog create(int style2) {
        this.setActionContainerOrientation(1);
        return super.create(style2);
    }
}

