/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.dialog;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.layout.QMUIPriorityLinearLayout;
import com.qmuiteam.qmui.skin.QMUISkinHelper;
import com.qmuiteam.qmui.skin.QMUISkinValueBuilder;
import com.qmuiteam.qmui.util.QMUIResHelper;

public class QMUIBottomSheetRootLayout
extends QMUIPriorityLinearLayout {
    private final int mUsePercentMinHeight;
    private final float mHeightPercent;
    private final int mMaxWidth;

    public QMUIBottomSheetRootLayout(Context context) {
        this(context, null);
    }

    public QMUIBottomSheetRootLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setOrientation(1);
        this.setBackground(QMUIResHelper.getAttrDrawable(context, R.attr.qmui_skin_support_bottom_sheet_bg));
        QMUISkinValueBuilder builder = QMUISkinValueBuilder.acquire();
        builder.background(R.attr.qmui_skin_support_bottom_sheet_bg);
        QMUISkinHelper.setSkinValue((View)this, builder);
        builder.release();
        int radius = QMUIResHelper.getAttrDimen(context, R.attr.qmui_bottom_sheet_radius);
        if (radius > 0) {
            this.setRadius(radius, 3);
        }
        this.mUsePercentMinHeight = QMUIResHelper.getAttrDimen(context, R.attr.qmui_bottom_sheet_use_percent_min_height);
        this.mHeightPercent = QMUIResHelper.getAttrFloatValue(context, R.attr.qmui_bottom_sheet_height_percent);
        this.mMaxWidth = QMUIResHelper.getAttrDimen(context, R.attr.qmui_bottom_sheet_max_width);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int heightSize;
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        if (widthSize > this.mMaxWidth) {
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.mMaxWidth, (int)widthMode);
        }
        if ((heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec)) >= this.mUsePercentMinHeight) {
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)((int)((float)heightSize * this.mHeightPercent)), (int)Integer.MIN_VALUE);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }
}

