/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.dialog;

import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.google.android.material.bottomsheet.BottomSheetBehavior;

public class QMUIBottomSheetBehavior<V extends ViewGroup>
extends BottomSheetBehavior<V> {
    private boolean mAllowDrag = true;
    private boolean mMotionEventCanDrag = true;
    private DownDragDecisionMaker mDownDragDecisionMaker;

    public void setAllowDrag(boolean allowDrag) {
        this.mAllowDrag = allowDrag;
    }

    public void setDownDragDecisionMaker(DownDragDecisionMaker downDragDecisionMaker) {
        this.mDownDragDecisionMaker = downDragDecisionMaker;
    }

    public boolean onTouchEvent(@NonNull CoordinatorLayout parent, @NonNull V child, @NonNull MotionEvent event) {
        if (!this.mAllowDrag) {
            return false;
        }
        if (event.getAction() == 0) {
            boolean bl = this.mMotionEventCanDrag = this.mDownDragDecisionMaker == null || this.mDownDragDecisionMaker.canDrag(parent, (View)child, event);
        }
        if (!this.mMotionEventCanDrag) {
            return false;
        }
        return super.onTouchEvent(parent, child, event);
    }

    public boolean onInterceptTouchEvent(@NonNull CoordinatorLayout parent, @NonNull V child, @NonNull MotionEvent event) {
        if (!this.mAllowDrag) {
            return false;
        }
        if (event.getAction() == 0) {
            boolean bl = this.mMotionEventCanDrag = this.mDownDragDecisionMaker == null || this.mDownDragDecisionMaker.canDrag(parent, (View)child, event);
        }
        if (!this.mMotionEventCanDrag) {
            return false;
        }
        return super.onInterceptTouchEvent(parent, child, event);
    }

    public boolean onStartNestedScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull V child, @NonNull View directTargetChild, @NonNull View target, int axes, int type) {
        if (!this.mAllowDrag) {
            return false;
        }
        return super.onStartNestedScroll(coordinatorLayout, child, directTargetChild, target, axes, type);
    }

    public static interface DownDragDecisionMaker {
        public boolean canDrag(@NonNull CoordinatorLayout var1, @NonNull View var2, @NonNull MotionEvent var3);
    }
}

