/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.SimpleArrayMap;
import androidx.core.view.WindowInsetsCompat;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.alpha.QMUIAlphaImageButton;
import com.qmuiteam.qmui.layout.QMUIFrameLayout;
import com.qmuiteam.qmui.qqface.QMUIQQFaceView;
import com.qmuiteam.qmui.skin.defaultAttr.IQMUISkinDefaultAttrProvider;
import com.qmuiteam.qmui.util.QMUIWindowInsetHelper;
import com.qmuiteam.qmui.widget.QMUITopBar;
import com.qmuiteam.qmui.widget.textview.QMUISpanTouchFixTextView;

public class QMUITopBarLayout
extends QMUIFrameLayout
implements IQMUISkinDefaultAttrProvider {
    private QMUITopBar mTopBar;
    private SimpleArrayMap<String, Integer> mDefaultSkinAttrs = new SimpleArrayMap(2);

    public QMUITopBarLayout(Context context) {
        this(context, null);
    }

    public QMUITopBarLayout(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.QMUITopBarStyle);
    }

    public QMUITopBarLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mDefaultSkinAttrs.put((Object)"bottomSeparator", (Object)R.attr.qmui_skin_support_topbar_separator_color);
        this.mDefaultSkinAttrs.put((Object)"background", (Object)R.attr.qmui_skin_support_topbar_bg);
        this.mTopBar = new QMUITopBar(context, attrs, defStyleAttr);
        this.mTopBar.setBackground(null);
        this.mTopBar.setVisibility(0);
        this.mTopBar.setFitsSystemWindows(false);
        this.mTopBar.setId(View.generateViewId());
        this.mTopBar.updateBottomDivider(0, 0, 0, 0);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, this.mTopBar.getTopBarHeight());
        this.addView((View)this.mTopBar, (ViewGroup.LayoutParams)lp);
        QMUIWindowInsetHelper.handleWindowInsets((View)this, WindowInsetsCompat.Type.statusBars() | WindowInsetsCompat.Type.displayCutout(), true);
    }

    public QMUITopBar getTopBar() {
        return this.mTopBar;
    }

    public void setCenterView(View view) {
        this.mTopBar.setCenterView(view);
    }

    public QMUIQQFaceView setTitle(int resId) {
        return this.mTopBar.setTitle(resId);
    }

    public QMUIQQFaceView setTitle(String title) {
        return this.mTopBar.setTitle(title);
    }

    public void showTitleView(boolean toShow) {
        this.mTopBar.showTitleView(toShow);
    }

    public QMUISpanTouchFixTextView setSubTitle(int resId) {
        return this.mTopBar.setSubTitle(resId);
    }

    public QMUISpanTouchFixTextView setSubTitle(CharSequence subTitle) {
        return this.mTopBar.setSubTitle(subTitle);
    }

    @Nullable
    public QMUIQQFaceView getTitleView() {
        return this.mTopBar.getTitleView();
    }

    @Nullable
    public QMUISpanTouchFixTextView getSubTitleView() {
        return this.mTopBar.getSubTitleView();
    }

    public void setTitleGravity(int gravity) {
        this.mTopBar.setTitleGravity(gravity);
    }

    public void addLeftView(View view, int viewId) {
        this.mTopBar.addLeftView(view, viewId);
    }

    public void addLeftView(View view, int viewId, RelativeLayout.LayoutParams layoutParams) {
        this.mTopBar.addLeftView(view, viewId, layoutParams);
    }

    public void addRightView(View view, int viewId) {
        this.mTopBar.addRightView(view, viewId);
    }

    public void addRightView(View view, int viewId, RelativeLayout.LayoutParams layoutParams) {
        this.mTopBar.addRightView(view, viewId, layoutParams);
    }

    public QMUIAlphaImageButton addRightImageButton(int drawableResId, int viewId) {
        return this.mTopBar.addRightImageButton(drawableResId, viewId);
    }

    public QMUIAlphaImageButton addRightImageButton(int drawableResId, boolean followTintColor, int viewId) {
        return this.mTopBar.addRightImageButton(drawableResId, followTintColor, viewId);
    }

    public QMUIAlphaImageButton addRightImageButton(int drawableResId, boolean followTintColor, int viewId, int iconWidth, int iconHeight) {
        return this.mTopBar.addRightImageButton(drawableResId, followTintColor, viewId, iconWidth, iconHeight);
    }

    public QMUIAlphaImageButton addLeftImageButton(int drawableResId, int viewId) {
        return this.mTopBar.addLeftImageButton(drawableResId, viewId);
    }

    public QMUIAlphaImageButton addLeftImageButton(int drawableResId, boolean followTintColor, int viewId) {
        return this.mTopBar.addLeftImageButton(drawableResId, followTintColor, viewId);
    }

    public QMUIAlphaImageButton addLeftImageButton(int drawableResId, boolean followTintColor, int viewId, int iconWidth, int iconHeight) {
        return this.mTopBar.addLeftImageButton(drawableResId, followTintColor, viewId, iconWidth, iconHeight);
    }

    public Button addLeftTextButton(int stringResId, int viewId) {
        return this.mTopBar.addLeftTextButton(stringResId, viewId);
    }

    public Button addLeftTextButton(String buttonText, int viewId) {
        return this.mTopBar.addLeftTextButton(buttonText, viewId);
    }

    public Button addRightTextButton(int stringResId, int viewId) {
        return this.mTopBar.addRightTextButton(stringResId, viewId);
    }

    public Button addRightTextButton(String buttonText, int viewId) {
        return this.mTopBar.addRightTextButton(buttonText, viewId);
    }

    public QMUIAlphaImageButton addLeftBackImageButton() {
        return this.mTopBar.addLeftBackImageButton();
    }

    public void removeAllLeftViews() {
        this.mTopBar.removeAllLeftViews();
    }

    public void removeAllRightViews() {
        this.mTopBar.removeAllRightViews();
    }

    public void removeCenterViewAndTitleView() {
        this.mTopBar.removeCenterViewAndTitleView();
    }

    public void setBackgroundAlpha(int alpha) {
        this.getBackground().mutate().setAlpha(alpha);
    }

    public int computeAndSetBackgroundAlpha(int currentOffset, int alphaBeginOffset, int alphaTargetOffset) {
        double alpha = (float)(currentOffset - alphaBeginOffset) / (float)(alphaTargetOffset - alphaBeginOffset);
        alpha = Math.max(0.0, Math.min(alpha, 1.0));
        int alphaInt = (int)(alpha * 255.0);
        this.setBackgroundAlpha(alphaInt);
        return alphaInt;
    }

    public void setDefaultSkinAttr(String name, int attr2) {
        this.mDefaultSkinAttrs.put((Object)name, (Object)attr2);
    }

    @Override
    public SimpleArrayMap<String, Integer> getDefaultSkinAttrs() {
        return this.mDefaultSkinAttrs;
    }

    public void eachLeftRightView(@NonNull QMUITopBar.Action action) {
        this.mTopBar.eachLeftRightView(action);
    }
}

