/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.SimpleArrayMap;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.alpha.QMUIAlphaImageButton;
import com.qmuiteam.qmui.layout.QMUIRelativeLayout;
import com.qmuiteam.qmui.qqface.QMUIQQFaceView;
import com.qmuiteam.qmui.skin.IQMUISkinHandlerView;
import com.qmuiteam.qmui.skin.QMUISkinManager;
import com.qmuiteam.qmui.skin.defaultAttr.IQMUISkinDefaultAttrProvider;
import com.qmuiteam.qmui.skin.defaultAttr.QMUISkinSimpleDefaultAttrProvider;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.util.QMUILangHelper;
import com.qmuiteam.qmui.util.QMUIResHelper;
import com.qmuiteam.qmui.util.QMUIViewHelper;
import com.qmuiteam.qmui.widget.QMUICollapsingTopBarLayout;
import com.qmuiteam.qmui.widget.QMUITopBarLayout;
import com.qmuiteam.qmui.widget.textview.QMUISpanTouchFixTextView;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class QMUITopBar
extends QMUIRelativeLayout
implements IQMUISkinHandlerView,
IQMUISkinDefaultAttrProvider {
    private static final int DEFAULT_VIEW_ID = -1;
    private int mLeftLastViewId;
    private int mRightLastViewId;
    private View mCenterView;
    private LinearLayout mTitleContainerView;
    private QMUIQQFaceView mTitleView;
    private QMUISpanTouchFixTextView mSubTitleView;
    private List<View> mLeftViewList;
    private List<View> mRightViewList;
    private int mTitleGravity;
    private int mLeftBackDrawableRes;
    private int mLeftBackViewWidth;
    private boolean mClearLeftPaddingWhenAddLeftBackView;
    private int mTitleTextSize;
    private Typeface mTitleTypeface;
    private Typeface mSubTitleTypeface;
    private int mTitleTextSizeWithSubTitle;
    private int mSubTitleTextSize;
    private int mTitleTextColor;
    private int mSubTitleTextColor;
    private int mTitleMarginHorWhenNoBtnAside;
    private int mTitleContainerPaddingHor;
    private int mTopBarImageBtnWidth;
    private int mTopBarImageBtnHeight;
    private int mTopBarTextBtnPaddingHor;
    private ColorStateList mTopBarTextBtnTextColor;
    private int mTopBarTextBtnTextSize;
    private Typeface mTopBarTextBtnTypeface;
    private int mTopBarHeight = -1;
    private Rect mTitleContainerRect;
    private boolean mIsBackgroundSetterDisabled = false;
    private TextUtils.TruncateAt mEllipsize;
    private static SimpleArrayMap<String, Integer> sDefaultSkinAttrs = new SimpleArrayMap(4);
    private IQMUISkinDefaultAttrProvider mTopBarTextDefaultAttrProvider;
    private IQMUISkinDefaultAttrProvider mTopBarImageColorTintColorProvider;

    public QMUITopBar(Context context) {
        this(context, null);
    }

    public QMUITopBar(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.QMUITopBarStyle);
    }

    public QMUITopBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initVar();
        this.init(context, attrs, defStyleAttr);
    }

    private void initVar() {
        this.mLeftLastViewId = -1;
        this.mRightLastViewId = -1;
        this.mLeftViewList = new ArrayList<View>();
        this.mRightViewList = new ArrayList<View>();
    }

    void init(Context context, AttributeSet attrs) {
        this.init(context, attrs, R.attr.QMUITopBarStyle);
    }

    void init(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray array = this.getContext().obtainStyledAttributes(attrs, R.styleable.QMUITopBar, defStyleAttr, 0);
        this.mLeftBackDrawableRes = array.getResourceId(R.styleable.QMUITopBar_qmui_topbar_left_back_drawable_id, R.drawable.qmui_icon_topbar_back);
        this.mLeftBackViewWidth = array.getDimensionPixelSize(R.styleable.QMUITopBar_qmui_topbar_left_back_width, -1);
        this.mClearLeftPaddingWhenAddLeftBackView = array.getBoolean(R.styleable.QMUITopBar_qmui_topbar_clear_left_padding_when_add_left_back_view, false);
        this.mTitleGravity = array.getInt(R.styleable.QMUITopBar_qmui_topbar_title_gravity, 17);
        this.mTitleTextSize = array.getDimensionPixelSize(R.styleable.QMUITopBar_qmui_topbar_title_text_size, QMUIDisplayHelper.sp2px(context, 17));
        this.mTitleTextSizeWithSubTitle = array.getDimensionPixelSize(R.styleable.QMUITopBar_qmui_topbar_title_text_size_with_subtitle, QMUIDisplayHelper.sp2px(context, 16));
        this.mSubTitleTextSize = array.getDimensionPixelSize(R.styleable.QMUITopBar_qmui_topbar_subtitle_text_size, QMUIDisplayHelper.sp2px(context, 11));
        this.mTitleTextColor = array.getColor(R.styleable.QMUITopBar_qmui_topbar_title_color, QMUIResHelper.getAttrColor(context, R.attr.qmui_config_color_gray_1));
        this.mSubTitleTextColor = array.getColor(R.styleable.QMUITopBar_qmui_topbar_subtitle_color, QMUIResHelper.getAttrColor(context, R.attr.qmui_config_color_gray_4));
        this.mTitleMarginHorWhenNoBtnAside = array.getDimensionPixelSize(R.styleable.QMUITopBar_qmui_topbar_title_margin_horizontal_when_no_btn_aside, 0);
        this.mTitleContainerPaddingHor = array.getDimensionPixelSize(R.styleable.QMUITopBar_qmui_topbar_title_container_padding_horizontal, 0);
        this.mTopBarImageBtnWidth = array.getDimensionPixelSize(R.styleable.QMUITopBar_qmui_topbar_image_btn_width, QMUIDisplayHelper.dp2px(context, 48));
        this.mTopBarImageBtnHeight = array.getDimensionPixelSize(R.styleable.QMUITopBar_qmui_topbar_image_btn_height, QMUIDisplayHelper.dp2px(context, 48));
        this.mTopBarTextBtnPaddingHor = array.getDimensionPixelSize(R.styleable.QMUITopBar_qmui_topbar_text_btn_padding_horizontal, QMUIDisplayHelper.dp2px(context, 12));
        this.mTopBarTextBtnTextColor = array.getColorStateList(R.styleable.QMUITopBar_qmui_topbar_text_btn_color_state_list);
        this.mTopBarTextBtnTextSize = array.getDimensionPixelSize(R.styleable.QMUITopBar_qmui_topbar_text_btn_text_size, QMUIDisplayHelper.sp2px(context, 16));
        this.mTitleTypeface = array.getBoolean(R.styleable.QMUITopBar_qmui_topbar_title_bold, false) ? Typeface.DEFAULT_BOLD : null;
        this.mSubTitleTypeface = array.getBoolean(R.styleable.QMUITopBar_qmui_topbar_subtitle_bold, false) ? Typeface.DEFAULT_BOLD : null;
        this.mTopBarTextBtnTypeface = array.getBoolean(R.styleable.QMUITopBar_qmui_topbar_text_btn_bold, false) ? Typeface.DEFAULT_BOLD : null;
        int ellipsize = array.getInt(R.styleable.QMUITopBar_android_ellipsize, -1);
        switch (ellipsize) {
            case 1: {
                this.mEllipsize = TextUtils.TruncateAt.START;
                break;
            }
            case 2: {
                this.mEllipsize = TextUtils.TruncateAt.MIDDLE;
                break;
            }
            case 3: {
                this.mEllipsize = TextUtils.TruncateAt.END;
                break;
            }
            default: {
                this.mEllipsize = null;
            }
        }
        array.recycle();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        ViewParent parent = this.getParent();
        while (parent instanceof View) {
            if (parent instanceof QMUICollapsingTopBarLayout) {
                this.makeSureTitleContainerView();
                return;
            }
            parent = parent.getParent();
        }
    }

    public void setCenterView(View view) {
        if (this.mCenterView == view) {
            return;
        }
        if (this.mCenterView != null) {
            this.removeView(this.mCenterView);
        }
        this.mCenterView = view;
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mCenterView.getLayoutParams();
        if (params == null) {
            params = new RelativeLayout.LayoutParams(-2, -2);
        }
        params.addRule(13);
        this.addView(view, (ViewGroup.LayoutParams)params);
    }

    public QMUIQQFaceView setTitle(int resId) {
        return this.setTitle(this.getContext().getString(resId));
    }

    public QMUIQQFaceView setTitle(String title) {
        QMUIQQFaceView titleView = this.ensureTitleView();
        titleView.setText(title);
        if (QMUILangHelper.isNullOrEmpty(title)) {
            titleView.setVisibility(8);
        } else {
            titleView.setVisibility(0);
        }
        return titleView;
    }

    public CharSequence getTitle() {
        if (this.mTitleView == null) {
            return null;
        }
        return this.mTitleView.getText();
    }

    @Nullable
    public QMUIQQFaceView getTitleView() {
        return this.mTitleView;
    }

    public void showTitleView(boolean toShow) {
        if (this.mTitleView != null) {
            this.mTitleView.setVisibility(toShow ? 0 : 8);
        }
    }

    private QMUIQQFaceView ensureTitleView() {
        if (this.mTitleView == null) {
            this.mTitleView = new QMUIQQFaceView(this.getContext());
            this.mTitleView.setGravity(17);
            this.mTitleView.setSingleLine(true);
            this.mTitleView.setEllipsize(this.mEllipsize);
            this.mTitleView.setTypeface(this.mTitleTypeface);
            this.mTitleView.setTextColor(this.mTitleTextColor);
            QMUISkinSimpleDefaultAttrProvider provider = new QMUISkinSimpleDefaultAttrProvider();
            provider.setDefaultSkinAttr("textColor", R.attr.qmui_skin_support_topbar_title_color);
            this.mTitleView.setTag(R.id.qmui_skin_default_attr_provider, provider);
            this.updateTitleViewStyle();
            LinearLayout.LayoutParams titleLp = this.generateTitleViewAndSubTitleViewLp();
            this.makeSureTitleContainerView().addView((View)this.mTitleView, (ViewGroup.LayoutParams)titleLp);
        }
        return this.mTitleView;
    }

    private void updateTitleViewStyle() {
        if (this.mTitleView != null) {
            if (this.mSubTitleView == null || QMUILangHelper.isNullOrEmpty(this.mSubTitleView.getText())) {
                this.mTitleView.setTextSize(this.mTitleTextSize);
            } else {
                this.mTitleView.setTextSize(this.mTitleTextSizeWithSubTitle);
            }
        }
    }

    public QMUISpanTouchFixTextView setSubTitle(CharSequence subTitle) {
        QMUISpanTouchFixTextView subTitleView = this.ensureSubTitleView();
        subTitleView.setText(subTitle);
        if (QMUILangHelper.isNullOrEmpty(subTitle)) {
            subTitleView.setVisibility(8);
        } else {
            subTitleView.setVisibility(0);
        }
        this.updateTitleViewStyle();
        return subTitleView;
    }

    public QMUISpanTouchFixTextView setSubTitle(int resId) {
        return this.setSubTitle(this.getResources().getString(resId));
    }

    private QMUISpanTouchFixTextView ensureSubTitleView() {
        if (this.mSubTitleView == null) {
            this.mSubTitleView = new QMUISpanTouchFixTextView(this.getContext());
            this.mSubTitleView.setGravity(17);
            this.mSubTitleView.setSingleLine(true);
            this.mSubTitleView.setTypeface(this.mSubTitleTypeface);
            this.mSubTitleView.setEllipsize(this.mEllipsize);
            this.mSubTitleView.setTextSize(0, this.mSubTitleTextSize);
            this.mSubTitleView.setTextColor(this.mSubTitleTextColor);
            QMUISkinSimpleDefaultAttrProvider provider = new QMUISkinSimpleDefaultAttrProvider();
            provider.setDefaultSkinAttr("textColor", R.attr.qmui_skin_support_topbar_subtitle_color);
            this.mSubTitleView.setTag(R.id.qmui_skin_default_attr_provider, provider);
            LinearLayout.LayoutParams titleLp = this.generateTitleViewAndSubTitleViewLp();
            titleLp.topMargin = QMUIDisplayHelper.dp2px(this.getContext(), 1);
            this.makeSureTitleContainerView().addView((View)this.mSubTitleView, (ViewGroup.LayoutParams)titleLp);
        }
        return this.mSubTitleView;
    }

    @Nullable
    public QMUISpanTouchFixTextView getSubTitleView() {
        return this.mSubTitleView;
    }

    public void setTitleGravity(int gravity) {
        this.mTitleGravity = gravity;
        if (this.mTitleView != null) {
            ((LinearLayout.LayoutParams)this.mTitleView.getLayoutParams()).gravity = gravity;
            if (gravity == 17 || gravity == 1) {
                this.mTitleView.setPadding(this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingLeft(), this.getPaddingBottom());
            }
        }
        if (this.mSubTitleView != null) {
            ((LinearLayout.LayoutParams)this.mSubTitleView.getLayoutParams()).gravity = gravity;
        }
        this.requestLayout();
    }

    public Rect getTitleContainerRect() {
        if (this.mTitleContainerRect == null) {
            this.mTitleContainerRect = new Rect();
        }
        if (this.mTitleContainerView == null) {
            this.mTitleContainerRect.set(0, 0, 0, 0);
        } else {
            QMUIViewHelper.getDescendantRect((ViewGroup)this, (View)this.mTitleContainerView, this.mTitleContainerRect);
        }
        return this.mTitleContainerRect;
    }

    public LinearLayout getTitleContainerView() {
        return this.mTitleContainerView;
    }

    void disableBackgroundSetter() {
        this.mIsBackgroundSetterDisabled = true;
        super.setBackgroundDrawable(null);
    }

    public void setBackgroundDrawable(Drawable background) {
        if (!this.mIsBackgroundSetterDisabled) {
            super.setBackgroundDrawable(background);
        }
    }

    private LinearLayout makeSureTitleContainerView() {
        if (this.mTitleContainerView == null) {
            this.mTitleContainerView = new LinearLayout(this.getContext());
            this.mTitleContainerView.setOrientation(1);
            this.mTitleContainerView.setGravity(17);
            this.mTitleContainerView.setPadding(this.mTitleContainerPaddingHor, 0, this.mTitleContainerPaddingHor, 0);
            this.addView((View)this.mTitleContainerView, (ViewGroup.LayoutParams)this.generateTitleContainerViewLp());
        }
        return this.mTitleContainerView;
    }

    private RelativeLayout.LayoutParams generateTitleContainerViewLp() {
        return new RelativeLayout.LayoutParams(-1, QMUIResHelper.getAttrDimen(this.getContext(), R.attr.qmui_topbar_height));
    }

    private LinearLayout.LayoutParams generateTitleViewAndSubTitleViewLp() {
        LinearLayout.LayoutParams titleLp = new LinearLayout.LayoutParams(-2, -2);
        titleLp.gravity = this.mTitleGravity;
        return titleLp;
    }

    public void addLeftView(View view, int viewId) {
        ViewGroup.LayoutParams viewLayoutParams = view.getLayoutParams();
        RelativeLayout.LayoutParams layoutParams = viewLayoutParams != null && viewLayoutParams instanceof RelativeLayout.LayoutParams ? (RelativeLayout.LayoutParams)viewLayoutParams : new RelativeLayout.LayoutParams(-2, -2);
        this.addLeftView(view, viewId, layoutParams);
    }

    public void addLeftView(View view, int viewId, RelativeLayout.LayoutParams layoutParams) {
        if (this.mLeftLastViewId == -1) {
            layoutParams.addRule(9);
        } else {
            layoutParams.addRule(1, this.mLeftLastViewId);
        }
        layoutParams.alignWithParent = true;
        this.mLeftLastViewId = viewId;
        view.setId(viewId);
        this.mLeftViewList.add(view);
        this.addView(view, (ViewGroup.LayoutParams)layoutParams);
    }

    public void addRightView(View view, int viewId) {
        ViewGroup.LayoutParams viewLayoutParams = view.getLayoutParams();
        RelativeLayout.LayoutParams layoutParams = viewLayoutParams != null && viewLayoutParams instanceof RelativeLayout.LayoutParams ? (RelativeLayout.LayoutParams)viewLayoutParams : new RelativeLayout.LayoutParams(-2, -2);
        this.addRightView(view, viewId, layoutParams);
    }

    public void addRightView(View view, int viewId, RelativeLayout.LayoutParams layoutParams) {
        if (this.mRightLastViewId == -1) {
            layoutParams.addRule(11);
        } else {
            layoutParams.addRule(0, this.mRightLastViewId);
        }
        layoutParams.alignWithParent = true;
        this.mRightLastViewId = viewId;
        view.setId(viewId);
        this.mRightViewList.add(view);
        this.addView(view, (ViewGroup.LayoutParams)layoutParams);
    }

    public RelativeLayout.LayoutParams generateTopBarImageButtonLayoutParams() {
        return this.generateTopBarImageButtonLayoutParams(-1, -1);
    }

    public RelativeLayout.LayoutParams generateTopBarImageButtonLayoutParams(int iconWidth, int iconHeight) {
        iconHeight = iconHeight > 0 ? iconHeight : this.mTopBarImageBtnHeight;
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(iconWidth > 0 ? iconWidth : this.mTopBarImageBtnWidth, iconHeight);
        lp.topMargin = Math.max(0, (this.getTopBarHeight() - iconHeight) / 2);
        return lp;
    }

    public QMUIAlphaImageButton addRightImageButton(int drawableResId, int viewId) {
        return this.addRightImageButton(drawableResId, true, viewId);
    }

    public QMUIAlphaImageButton addRightImageButton(int drawableResId, boolean followTintColor, int viewId) {
        return this.addRightImageButton(drawableResId, followTintColor, viewId, -1, -1);
    }

    public QMUIAlphaImageButton addRightImageButton(int drawableResId, boolean followTintColor, int viewId, int iconWidth, int iconHeight) {
        QMUIAlphaImageButton rightButton = this.generateTopBarImageButton(drawableResId, followTintColor);
        this.addRightView((View)rightButton, viewId, this.generateTopBarImageButtonLayoutParams(iconWidth, iconHeight));
        return rightButton;
    }

    public QMUIAlphaImageButton addLeftImageButton(int drawableResId, int viewId) {
        return this.addLeftImageButton(drawableResId, true, viewId);
    }

    public QMUIAlphaImageButton addLeftImageButton(int drawableResId, boolean followTintColor, int viewId) {
        return this.addLeftImageButton(drawableResId, followTintColor, viewId, -1, -1);
    }

    public QMUIAlphaImageButton addLeftImageButton(int drawableResId, boolean followTintColor, int viewId, int iconWidth, int iconHeight) {
        QMUIAlphaImageButton leftButton = this.generateTopBarImageButton(drawableResId, followTintColor);
        this.addLeftView((View)leftButton, viewId, this.generateTopBarImageButtonLayoutParams(iconWidth, iconHeight));
        return leftButton;
    }

    public RelativeLayout.LayoutParams generateTopBarTextButtonLayoutParams() {
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-2, this.mTopBarImageBtnHeight);
        lp.topMargin = Math.max(0, (this.getTopBarHeight() - this.mTopBarImageBtnHeight) / 2);
        return lp;
    }

    public Button addLeftTextButton(int stringResId, int viewId) {
        return this.addLeftTextButton(this.getResources().getString(stringResId), viewId);
    }

    public Button addLeftTextButton(String buttonText, int viewId) {
        Button button = this.generateTopBarTextButton(buttonText);
        this.addLeftView((View)button, viewId, this.generateTopBarTextButtonLayoutParams());
        return button;
    }

    public Button addRightTextButton(int stringResId, int viewId) {
        return this.addRightTextButton(this.getResources().getString(stringResId), viewId);
    }

    public Button addRightTextButton(String buttonText, int viewId) {
        Button button = this.generateTopBarTextButton(buttonText);
        this.addRightView((View)button, viewId, this.generateTopBarTextButtonLayoutParams());
        return button;
    }

    private Button generateTopBarTextButton(String text) {
        Button button = new Button(this.getContext());
        if (this.mTopBarTextDefaultAttrProvider == null) {
            QMUISkinSimpleDefaultAttrProvider provider = new QMUISkinSimpleDefaultAttrProvider();
            provider.setDefaultSkinAttr("textColor", R.attr.qmui_skin_support_topbar_text_btn_color_state_list);
            this.mTopBarTextDefaultAttrProvider = provider;
        }
        button.setTag(R.id.qmui_skin_default_attr_provider, (Object)this.mTopBarTextDefaultAttrProvider);
        button.setBackgroundResource(0);
        button.setMinWidth(0);
        button.setMinHeight(0);
        button.setMinimumWidth(0);
        button.setMinimumHeight(0);
        button.setTypeface(this.mTopBarTextBtnTypeface);
        button.setPadding(this.mTopBarTextBtnPaddingHor, 0, this.mTopBarTextBtnPaddingHor, 0);
        button.setTextColor(this.mTopBarTextBtnTextColor);
        button.setTextSize(0, (float)this.mTopBarTextBtnTextSize);
        button.setGravity(17);
        button.setText((CharSequence)text);
        return button;
    }

    private QMUIAlphaImageButton generateTopBarImageButton(int imageResourceId, boolean followTintColor) {
        QMUIAlphaImageButton imageButton = new QMUIAlphaImageButton(this.getContext());
        if (followTintColor) {
            if (this.mTopBarImageColorTintColorProvider == null) {
                QMUISkinSimpleDefaultAttrProvider provider = new QMUISkinSimpleDefaultAttrProvider();
                provider.setDefaultSkinAttr("tintColor", R.attr.qmui_skin_support_topbar_image_tint_color);
                this.mTopBarImageColorTintColorProvider = provider;
            }
            imageButton.setTag(R.id.qmui_skin_default_attr_provider, this.mTopBarImageColorTintColorProvider);
        }
        imageButton.setBackgroundColor(0);
        imageButton.setImageResource(imageResourceId);
        return imageButton;
    }

    public QMUIAlphaImageButton addLeftBackImageButton() {
        if (this.mClearLeftPaddingWhenAddLeftBackView) {
            QMUIViewHelper.setPaddingLeft((View)this, 0);
        }
        if (this.mLeftBackViewWidth > 0) {
            return this.addLeftImageButton(this.mLeftBackDrawableRes, true, R.id.qmui_topbar_item_left_back, this.mLeftBackViewWidth, -1);
        }
        return this.addLeftImageButton(this.mLeftBackDrawableRes, R.id.qmui_topbar_item_left_back);
    }

    public void removeAllLeftViews() {
        for (View leftView : this.mLeftViewList) {
            this.removeView(leftView);
        }
        this.mLeftLastViewId = -1;
        this.mLeftViewList.clear();
    }

    public void removeAllRightViews() {
        for (View rightView : this.mRightViewList) {
            this.removeView(rightView);
        }
        this.mRightLastViewId = -1;
        this.mRightViewList.clear();
    }

    public void removeCenterViewAndTitleView() {
        if (this.mCenterView != null) {
            if (this.mCenterView.getParent() == this) {
                this.removeView(this.mCenterView);
            }
            this.mCenterView = null;
        }
        if (this.mTitleView != null) {
            if (this.mTitleView.getParent() == this) {
                this.removeView(this.mTitleView);
            }
            this.mTitleView = null;
        }
    }

    int getTopBarHeight() {
        if (this.mTopBarHeight == -1) {
            this.mTopBarHeight = QMUIResHelper.getAttrDimen(this.getContext(), R.attr.qmui_topbar_height);
        }
        return this.mTopBarHeight;
    }

    public void setBackgroundAlpha(int alpha) {
        this.getBackground().mutate().setAlpha(alpha);
    }

    public int computeAndSetBackgroundAlpha(int currentOffset, int alphaBeginOffset, int alphaTargetOffset) {
        double alpha = (float)(currentOffset - alphaBeginOffset) / (float)(alphaTargetOffset - alphaBeginOffset);
        alpha = Math.max(0.0, Math.min(alpha, 1.0));
        int alphaInt = (int)(alpha * 255.0);
        this.setBackgroundAlpha(alphaInt);
        return alphaInt;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mTitleContainerView != null) {
            int leftViewWidth = this.getPaddingLeft();
            for (int leftViewIndex = 0; leftViewIndex < this.mLeftViewList.size(); ++leftViewIndex) {
                View view = this.mLeftViewList.get(leftViewIndex);
                if (view.getVisibility() == 8) continue;
                leftViewWidth += view.getMeasuredWidth();
            }
            int rightViewWidth = this.getPaddingRight();
            for (int rightViewIndex = 0; rightViewIndex < this.mRightViewList.size(); ++rightViewIndex) {
                View view = this.mRightViewList.get(rightViewIndex);
                if (view.getVisibility() == 8) continue;
                rightViewWidth += view.getMeasuredWidth();
            }
            leftViewWidth = Math.max(this.mTitleMarginHorWhenNoBtnAside, leftViewWidth);
            rightViewWidth = Math.max(this.mTitleMarginHorWhenNoBtnAside, rightViewWidth);
            int titleContainerWidth = (this.mTitleGravity & 7) == 1 ? View.MeasureSpec.getSize((int)widthMeasureSpec) - Math.max(leftViewWidth, rightViewWidth) * 2 : View.MeasureSpec.getSize((int)widthMeasureSpec) - leftViewWidth - rightViewWidth;
            int titleContainerWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)titleContainerWidth, (int)0x40000000);
            this.mTitleContainerView.measure(titleContainerWidthMeasureSpec, heightMeasureSpec);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.mTitleContainerView != null) {
            int titleContainerViewWidth = this.mTitleContainerView.getMeasuredWidth();
            int titleContainerViewHeight = this.mTitleContainerView.getMeasuredHeight();
            int titleContainerViewTop = (b - t - this.mTitleContainerView.getMeasuredHeight()) / 2;
            int titleContainerViewLeft = this.getPaddingLeft();
            if ((this.mTitleGravity & 7) == 1) {
                titleContainerViewLeft = (r - l - this.mTitleContainerView.getMeasuredWidth()) / 2;
            } else {
                for (int leftViewIndex = 0; leftViewIndex < this.mLeftViewList.size(); ++leftViewIndex) {
                    View view = this.mLeftViewList.get(leftViewIndex);
                    if (view.getVisibility() == 8) continue;
                    titleContainerViewLeft += view.getMeasuredWidth();
                }
                titleContainerViewLeft = Math.max(titleContainerViewLeft, this.mTitleMarginHorWhenNoBtnAside);
            }
            this.mTitleContainerView.layout(titleContainerViewLeft, titleContainerViewTop, titleContainerViewLeft + titleContainerViewWidth, titleContainerViewTop + titleContainerViewHeight);
        }
    }

    @Override
    public void handle(@NotNull QMUISkinManager manager, int skinIndex, @NotNull Resources.Theme theme, @Nullable SimpleArrayMap<String, Integer> attrs) {
        if (attrs != null) {
            for (int i = 0; i < attrs.size(); ++i) {
                String key = (String)attrs.keyAt(i);
                Integer attr2 = (Integer)attrs.valueAt(i);
                if (attr2 == null || this.getParent() instanceof QMUITopBarLayout && ("background".equals(key) || "bottomSeparator".equals(key))) continue;
                manager.defaultHandleSkinAttr((View)this, theme, key, attr2);
            }
        }
    }

    @Override
    public SimpleArrayMap<String, Integer> getDefaultSkinAttrs() {
        return sDefaultSkinAttrs;
    }

    public void eachLeftRightView(@NonNull Action action) {
        int i;
        for (i = 0; i < this.mLeftViewList.size(); ++i) {
            action.call(this.mLeftViewList.get(i), i, true);
        }
        for (i = 0; i < this.mRightViewList.size(); ++i) {
            action.call(this.mRightViewList.get(i), i, false);
        }
    }

    static {
        sDefaultSkinAttrs.put((Object)"bottomSeparator", (Object)R.attr.qmui_skin_support_topbar_separator_color);
        sDefaultSkinAttrs.put((Object)"background", (Object)R.attr.qmui_skin_support_topbar_bg);
    }

    public static interface Action {
        public void call(View var1, int var2, boolean var3);
    }
}

