/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.appcompat.widget.AppCompatImageView;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.alpha.QMUIAlphaViewHelper;
import com.qmuiteam.qmui.layout.IQMUILayout;
import com.qmuiteam.qmui.layout.QMUILayoutHelper;

public class QMUIRadiusImageView2
extends AppCompatImageView
implements IQMUILayout {
    private static final int DEFAULT_BORDER_COLOR = -7829368;
    private QMUILayoutHelper mLayoutHelper;
    private QMUIAlphaViewHelper mAlphaViewHelper;
    private boolean mIsCircle = false;
    private boolean mIsSelected = false;
    private int mBorderWidth;
    private int mBorderColor;
    private int mSelectedBorderWidth;
    private int mSelectedBorderColor;
    private int mSelectedMaskColor;
    private boolean mIsTouchSelectModeEnabled = true;
    private ColorFilter mColorFilter;
    private ColorFilter mSelectedColorFilter;
    private boolean mIsInOnTouchEvent = false;

    public QMUIRadiusImageView2(Context context) {
        super(context);
        this.init(context, null, 0);
    }

    public QMUIRadiusImageView2(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0);
    }

    public QMUIRadiusImageView2(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        this.mLayoutHelper = new QMUILayoutHelper(context, attrs, defStyleAttr, (View)this);
        this.setChangeAlphaWhenPress(false);
        this.setChangeAlphaWhenDisable(false);
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.QMUIRadiusImageView2, defStyleAttr, 0);
        this.mBorderWidth = array.getDimensionPixelSize(R.styleable.QMUIRadiusImageView2_qmui_border_width, 0);
        this.mBorderColor = array.getColor(R.styleable.QMUIRadiusImageView2_qmui_border_color, -7829368);
        this.mSelectedBorderWidth = array.getDimensionPixelSize(R.styleable.QMUIRadiusImageView2_qmui_selected_border_width, this.mBorderWidth);
        this.mSelectedBorderColor = array.getColor(R.styleable.QMUIRadiusImageView2_qmui_selected_border_color, this.mBorderColor);
        this.mSelectedMaskColor = array.getColor(R.styleable.QMUIRadiusImageView2_qmui_selected_mask_color, 0);
        if (this.mSelectedMaskColor != 0) {
            this.mSelectedColorFilter = new PorterDuffColorFilter(this.mSelectedMaskColor, PorterDuff.Mode.DARKEN);
        }
        this.mIsTouchSelectModeEnabled = array.getBoolean(R.styleable.QMUIRadiusImageView2_qmui_is_touch_select_mode_enabled, true);
        this.mIsCircle = array.getBoolean(R.styleable.QMUIRadiusImageView2_qmui_is_circle, false);
        if (!this.mIsCircle) {
            this.setRadius(array.getDimensionPixelSize(R.styleable.QMUIRadiusImageView2_qmui_corner_radius, 0));
        }
        array.recycle();
        this.mLayoutHelper.setBorderWidth(this.mBorderWidth);
        this.mLayoutHelper.setBorderColor(this.mBorderColor);
    }

    private QMUIAlphaViewHelper getAlphaViewHelper() {
        if (this.mAlphaViewHelper == null) {
            this.mAlphaViewHelper = new QMUIAlphaViewHelper((View)this);
        }
        return this.mAlphaViewHelper;
    }

    public void setCornerRadius(int cornerRadius) {
        this.setRadius(cornerRadius);
    }

    protected boolean setFrame(int l, int t, int r, int b) {
        return super.setFrame(l, t, r, b);
    }

    public void setPressed(boolean pressed) {
        super.setPressed(pressed);
        this.getAlphaViewHelper().onPressedChanged((View)this, pressed);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getAlphaViewHelper().onEnabledChanged((View)this, enabled);
    }

    public void setChangeAlphaWhenPress(boolean changeAlphaWhenPress) {
        this.getAlphaViewHelper().setChangeAlphaWhenPress(changeAlphaWhenPress);
    }

    public void setChangeAlphaWhenDisable(boolean changeAlphaWhenDisable) {
        this.getAlphaViewHelper().setChangeAlphaWhenDisable(changeAlphaWhenDisable);
    }

    public void setCircle(boolean isCircle) {
        if (this.mIsCircle != isCircle) {
            this.mIsCircle = isCircle;
            this.requestLayout();
            this.invalidate();
        }
    }

    public int getBorderColor() {
        return this.mBorderColor;
    }

    public int getBorderWidth() {
        return this.mBorderWidth;
    }

    public int getCornerRadius() {
        return this.getRadius();
    }

    public int getSelectedBorderColor() {
        return this.mSelectedBorderColor;
    }

    public int getSelectedBorderWidth() {
        return this.mSelectedBorderWidth;
    }

    public int getSelectedMaskColor() {
        return this.mSelectedMaskColor;
    }

    public boolean isCircle() {
        return this.mIsCircle;
    }

    public boolean isSelected() {
        return this.mIsSelected;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        widthMeasureSpec = this.mLayoutHelper.getMeasuredWidthSpec(widthMeasureSpec);
        heightMeasureSpec = this.mLayoutHelper.getMeasuredHeightSpec(heightMeasureSpec);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int minW = this.mLayoutHelper.handleMiniWidth(widthMeasureSpec, this.getMeasuredWidth());
        int minH = this.mLayoutHelper.handleMiniHeight(heightMeasureSpec, this.getMeasuredHeight());
        if (widthMeasureSpec != minW || heightMeasureSpec != minH) {
            super.onMeasure(minW, minH);
        }
        if (this.mIsCircle) {
            int h = this.getMeasuredHeight();
            int w = this.getMeasuredWidth();
            int radius = w / 2;
            if (h != w) {
                int size = Math.min(h, w);
                radius = size / 2;
                int measureSpec = View.MeasureSpec.makeMeasureSpec((int)size, (int)0x40000000);
                super.onMeasure(measureSpec, measureSpec);
            }
            this.setRadius(radius);
        }
    }

    @Override
    public void updateTopDivider(int topInsetLeft, int topInsetRight, int topDividerHeight, int topDividerColor) {
        this.mLayoutHelper.updateTopDivider(topInsetLeft, topInsetRight, topDividerHeight, topDividerColor);
        this.invalidate();
    }

    @Override
    public void updateBottomDivider(int bottomInsetLeft, int bottomInsetRight, int bottomDividerHeight, int bottomDividerColor) {
        this.mLayoutHelper.updateBottomDivider(bottomInsetLeft, bottomInsetRight, bottomDividerHeight, bottomDividerColor);
        this.invalidate();
    }

    @Override
    public void updateLeftDivider(int leftInsetTop, int leftInsetBottom, int leftDividerWidth, int leftDividerColor) {
        this.mLayoutHelper.updateLeftDivider(leftInsetTop, leftInsetBottom, leftDividerWidth, leftDividerColor);
        this.invalidate();
    }

    @Override
    public void updateRightDivider(int rightInsetTop, int rightInsetBottom, int rightDividerWidth, int rightDividerColor) {
        this.mLayoutHelper.updateRightDivider(rightInsetTop, rightInsetBottom, rightDividerWidth, rightDividerColor);
        this.invalidate();
    }

    @Override
    public void onlyShowTopDivider(int topInsetLeft, int topInsetRight, int topDividerHeight, int topDividerColor) {
        this.mLayoutHelper.onlyShowTopDivider(topInsetLeft, topInsetRight, topDividerHeight, topDividerColor);
        this.invalidate();
    }

    @Override
    public void onlyShowBottomDivider(int bottomInsetLeft, int bottomInsetRight, int bottomDividerHeight, int bottomDividerColor) {
        this.mLayoutHelper.onlyShowBottomDivider(bottomInsetLeft, bottomInsetRight, bottomDividerHeight, bottomDividerColor);
        this.invalidate();
    }

    @Override
    public void onlyShowLeftDivider(int leftInsetTop, int leftInsetBottom, int leftDividerWidth, int leftDividerColor) {
        this.mLayoutHelper.onlyShowLeftDivider(leftInsetTop, leftInsetBottom, leftDividerWidth, leftDividerColor);
        this.invalidate();
    }

    @Override
    public void onlyShowRightDivider(int rightInsetTop, int rightInsetBottom, int rightDividerWidth, int rightDividerColor) {
        this.mLayoutHelper.onlyShowRightDivider(rightInsetTop, rightInsetBottom, rightDividerWidth, rightDividerColor);
        this.invalidate();
    }

    @Override
    public void updateBottomSeparatorColor(int color2) {
        this.mLayoutHelper.updateBottomSeparatorColor(color2);
    }

    @Override
    public void updateLeftSeparatorColor(int color2) {
        this.mLayoutHelper.updateLeftSeparatorColor(color2);
    }

    @Override
    public void updateRightSeparatorColor(int color2) {
        this.mLayoutHelper.updateRightSeparatorColor(color2);
    }

    @Override
    public void updateTopSeparatorColor(int color2) {
        this.mLayoutHelper.updateTopSeparatorColor(color2);
    }

    @Override
    public void setTopDividerAlpha(int dividerAlpha) {
        this.mLayoutHelper.setTopDividerAlpha(dividerAlpha);
        this.invalidate();
    }

    @Override
    public void setBottomDividerAlpha(int dividerAlpha) {
        this.mLayoutHelper.setBottomDividerAlpha(dividerAlpha);
        this.invalidate();
    }

    @Override
    public void setLeftDividerAlpha(int dividerAlpha) {
        this.mLayoutHelper.setLeftDividerAlpha(dividerAlpha);
        this.invalidate();
    }

    @Override
    public void setRightDividerAlpha(int dividerAlpha) {
        this.mLayoutHelper.setRightDividerAlpha(dividerAlpha);
        this.invalidate();
    }

    @Override
    public void setRadiusAndShadow(int radius, int shadowElevation, float shadowAlpha) {
        this.mLayoutHelper.setRadiusAndShadow(radius, shadowElevation, shadowAlpha);
    }

    @Override
    public void setRadiusAndShadow(int radius, int hideRadiusSide, int shadowElevation, float shadowAlpha) {
        this.mLayoutHelper.setRadiusAndShadow(radius, hideRadiusSide, shadowElevation, shadowAlpha);
    }

    @Override
    public void setRadiusAndShadow(int radius, int hideRadiusSide, int shadowElevation, int shadowColor, float shadowAlpha) {
        this.mLayoutHelper.setRadiusAndShadow(radius, hideRadiusSide, shadowElevation, shadowColor, shadowAlpha);
    }

    @Override
    public void setRadius(int radius) {
        this.mLayoutHelper.setRadius(radius);
    }

    @Override
    public void setRadius(int radius, int hideRadiusSide) {
        this.mLayoutHelper.setRadius(radius, hideRadiusSide);
    }

    @Override
    public int getRadius() {
        return this.mLayoutHelper.getRadius();
    }

    @Override
    public void setOutlineInset(int left, int top, int right, int bottom) {
        this.mLayoutHelper.setOutlineInset(left, top, right, bottom);
    }

    @Override
    public void setBorderColor(@ColorInt int borderColor) {
        if (this.mBorderColor != borderColor) {
            this.mBorderColor = borderColor;
            if (!this.mIsSelected) {
                this.mLayoutHelper.setBorderColor(borderColor);
                this.invalidate();
            }
        }
    }

    @Override
    public void setBorderWidth(int borderWidth) {
        if (this.mBorderWidth != borderWidth) {
            this.mBorderWidth = borderWidth;
            if (!this.mIsSelected) {
                this.mLayoutHelper.setBorderWidth(borderWidth);
                this.invalidate();
            }
        }
    }

    public void setSelectedBorderColor(@ColorInt int selectedBorderColor) {
        if (this.mSelectedBorderColor != selectedBorderColor) {
            this.mSelectedBorderColor = selectedBorderColor;
            if (this.mIsSelected) {
                this.mLayoutHelper.setBorderColor(selectedBorderColor);
                this.invalidate();
            }
        }
    }

    public void setSelectedBorderWidth(int selectedBorderWidth) {
        if (this.mSelectedBorderWidth != selectedBorderWidth) {
            this.mSelectedBorderWidth = selectedBorderWidth;
            if (this.mIsSelected) {
                this.mLayoutHelper.setBorderWidth(selectedBorderWidth);
                this.invalidate();
            }
        }
    }

    public void setSelectedMaskColor(@ColorInt int selectedMaskColor) {
        if (this.mSelectedMaskColor != selectedMaskColor) {
            this.mSelectedMaskColor = selectedMaskColor;
            this.mSelectedColorFilter = this.mSelectedMaskColor != 0 ? new PorterDuffColorFilter(this.mSelectedMaskColor, PorterDuff.Mode.DARKEN) : null;
            if (this.mIsSelected) {
                this.invalidate();
            }
        }
        this.mSelectedMaskColor = selectedMaskColor;
    }

    @Override
    public void setShowBorderOnlyBeforeL(boolean showBorderOnlyBeforeL) {
        this.mLayoutHelper.setShowBorderOnlyBeforeL(showBorderOnlyBeforeL);
        this.invalidate();
    }

    @Override
    public void setHideRadiusSide(int hideRadiusSide) {
        this.mLayoutHelper.setHideRadiusSide(hideRadiusSide);
    }

    @Override
    public int getHideRadiusSide() {
        return this.mLayoutHelper.getHideRadiusSide();
    }

    @Override
    public boolean setWidthLimit(int widthLimit) {
        if (this.mLayoutHelper.setWidthLimit(widthLimit)) {
            this.requestLayout();
            this.invalidate();
        }
        return true;
    }

    @Override
    public boolean setHeightLimit(int heightLimit) {
        if (this.mLayoutHelper.setHeightLimit(heightLimit)) {
            this.requestLayout();
            this.invalidate();
        }
        return true;
    }

    @Override
    public void setUseThemeGeneralShadowElevation() {
        this.mLayoutHelper.setUseThemeGeneralShadowElevation();
    }

    @Override
    public void setOutlineExcludePadding(boolean outlineExcludePadding) {
        this.mLayoutHelper.setOutlineExcludePadding(outlineExcludePadding);
    }

    @Override
    public void setShadowElevation(int elevation) {
        this.mLayoutHelper.setShadowElevation(elevation);
    }

    @Override
    public int getShadowElevation() {
        return this.mLayoutHelper.getShadowElevation();
    }

    @Override
    public void setShadowAlpha(float shadowAlpha) {
        this.mLayoutHelper.setShadowAlpha(shadowAlpha);
    }

    @Override
    public void setShadowColor(int shadowColor) {
        this.mLayoutHelper.setShadowColor(shadowColor);
    }

    @Override
    public int getShadowColor() {
        return this.mLayoutHelper.getShadowColor();
    }

    @Override
    public void setOuterNormalColor(int color2) {
        this.mLayoutHelper.setOuterNormalColor(color2);
    }

    @Override
    public float getShadowAlpha() {
        return this.mLayoutHelper.getShadowAlpha();
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        this.mLayoutHelper.drawDividers(canvas, this.getWidth(), this.getHeight());
        this.mLayoutHelper.dispatchRoundBorderDraw(canvas);
    }

    public void setSelected(boolean selected) {
        if (!this.mIsInOnTouchEvent) {
            super.setSelected(selected);
        }
        if (this.mIsSelected != selected) {
            this.mIsSelected = selected;
            if (this.mIsSelected) {
                super.setColorFilter(this.mSelectedColorFilter);
            } else {
                super.setColorFilter(this.mColorFilter);
            }
            int borderWidth = this.mIsSelected ? this.mSelectedBorderWidth : this.mBorderWidth;
            int borderColor = this.mIsSelected ? this.mSelectedBorderColor : this.mBorderColor;
            this.mLayoutHelper.setBorderWidth(borderWidth);
            this.mLayoutHelper.setBorderColor(borderColor);
            this.invalidate();
        }
    }

    public void setTouchSelectModeEnabled(boolean touchSelectModeEnabled) {
        this.mIsTouchSelectModeEnabled = touchSelectModeEnabled;
    }

    public boolean isTouchSelectModeEnabled() {
        return this.mIsTouchSelectModeEnabled;
    }

    public void setSelectedColorFilter(ColorFilter cf) {
        if (this.mSelectedColorFilter == cf) {
            return;
        }
        this.mSelectedColorFilter = cf;
        if (this.mIsSelected) {
            super.setColorFilter(cf);
        }
    }

    public void setColorFilter(ColorFilter cf) {
        if (this.mColorFilter == cf) {
            return;
        }
        this.mColorFilter = cf;
        if (!this.mIsSelected) {
            super.setColorFilter(cf);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isClickable()) {
            return super.onTouchEvent(event);
        }
        if (this.mIsTouchSelectModeEnabled) {
            this.mIsInOnTouchEvent = true;
            switch (event.getAction()) {
                case 0: {
                    this.setSelected(true);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 8: {
                    this.setSelected(false);
                }
            }
            this.mIsInOnTouchEvent = false;
        }
        return super.onTouchEvent(event);
    }

    @Override
    public boolean hasBorder() {
        return this.mLayoutHelper.hasBorder();
    }

    @Override
    public boolean hasLeftSeparator() {
        return this.mLayoutHelper.hasLeftSeparator();
    }

    @Override
    public boolean hasTopSeparator() {
        return this.mLayoutHelper.hasTopSeparator();
    }

    @Override
    public boolean hasRightSeparator() {
        return this.mLayoutHelper.hasRightSeparator();
    }

    @Override
    public boolean hasBottomSeparator() {
        return this.mLayoutHelper.hasBottomSeparator();
    }
}

