/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.util;

import android.graphics.Rect;
import android.os.Build;
import android.view.View;
import android.view.ViewParent;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.reflect.Field;

public class QMUIWindowHelper {
    public static final int KEYBOARD_HEIGHT_BOUNDARY_DP = 100;

    public static void setWindowType(WindowManager.LayoutParams layoutParams) {
        layoutParams.type = 2005;
    }

    @Nullable
    public static Rect unSafeGetWindowVisibleInsets(@NonNull View view) {
        Object attachInfo = QMUIWindowHelper.getAttachInfoFromView(view);
        if (attachInfo == null) {
            return null;
        }
        try {
            Field visibleInsetsField = attachInfo.getClass().getDeclaredField("mVisibleInsets");
            visibleInsetsField.setAccessible(true);
            Object visibleInsets = visibleInsetsField.get(attachInfo);
            if (visibleInsets instanceof Rect) {
                return (Rect)visibleInsets;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    public static Rect unSafeGetContentInsets(@NonNull View view) {
        Object attachInfo = QMUIWindowHelper.getAttachInfoFromView(view);
        if (attachInfo == null) {
            return null;
        }
        try {
            Field visibleInsetsField = attachInfo.getClass().getDeclaredField("mContentInsets");
            visibleInsetsField.setAccessible(true);
            Object visibleInsets = visibleInsetsField.get(attachInfo);
            if (visibleInsets instanceof Rect) {
                return (Rect)visibleInsets;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static Object getAttachInfoFromView(@NonNull View view) {
        Object attachInfo = null;
        if (Build.VERSION.SDK_INT > 28) {
            ViewParent vp;
            View rootView = view.getRootView();
            if (rootView != null && (vp = rootView.getParent()) != null) {
                try {
                    Field field = vp.getClass().getDeclaredField("mAttachInfo");
                    field.setAccessible(true);
                    attachInfo = field.get(vp);
                }
                catch (Throwable throwable) {}
            }
        } else {
            try {
                Field field = View.class.getDeclaredField("mAttachInfo");
                field.setAccessible(true);
                attachInfo = field.get(view);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return attachInfo;
    }
}

