/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.util;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.content.Context;
import android.os.Binder;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.qmuiteam.qmui.QMUILog;
import com.qmuiteam.qmui.util.QMUILangHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@SuppressLint(value={"PrivateApi"})
public class QMUIDeviceHelper {
    private static final String TAG = "QMUIDeviceHelper";
    private static final String KEY_MIUI_VERSION_NAME = "ro.miui.ui.version.name";
    private static final String KEY_FLYME_VERSION_NAME = "ro.build.display.id";
    private static final String FLYME = "flyme";
    private static final String ZTEC2016 = "zte c2016";
    private static final String ZUKZ1 = "zuk z1";
    private static final String ESSENTIAL = "essential";
    private static final String[] MEIZUBOARD = new String[]{"m9", "M9", "mx", "MX"};
    private static final String POWER_PROFILE_CLASS = "com.android.internal.os.PowerProfile";
    private static final String CPU_FILE_PATH_0 = "/sys/devices/system/cpu/";
    private static final String CPU_FILE_PATH_1 = "/sys/devices/system/cpu/possible";
    private static final String CPU_FILE_PATH_2 = "/sys/devices/system/cpu/present";
    private static FileFilter CPU_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return Pattern.matches("cpu[0-9]", pathname.getName());
        }
    };
    private static String sMiuiVersionName;
    private static String sFlymeVersionName;
    private static boolean sIsTabletChecked;
    private static boolean sIsTabletValue;
    private static final String BRAND;
    private static long sTotalMemory;
    private static long sInnerStorageSize;
    private static long sExtraStorageSize;
    private static double sBatteryCapacity;
    private static int sCpuCoreCount;

    private static boolean _isTablet(Context context) {
        return (context.getResources().getConfiguration().screenLayout & 0xF) >= 3;
    }

    public static boolean isTablet(Context context) {
        if (sIsTabletChecked) {
            return sIsTabletValue;
        }
        sIsTabletValue = QMUIDeviceHelper._isTablet(context);
        sIsTabletChecked = true;
        return sIsTabletValue;
    }

    public static boolean isFlyme() {
        return !TextUtils.isEmpty((CharSequence)sFlymeVersionName) && sFlymeVersionName.contains(FLYME);
    }

    public static boolean isMIUI() {
        return !TextUtils.isEmpty((CharSequence)sMiuiVersionName);
    }

    public static boolean isMIUIV5() {
        return "v5".equals(sMiuiVersionName);
    }

    public static boolean isMIUIV6() {
        return "v6".equals(sMiuiVersionName);
    }

    public static boolean isMIUIV7() {
        return "v7".equals(sMiuiVersionName);
    }

    public static boolean isMIUIV8() {
        return "v8".equals(sMiuiVersionName);
    }

    public static boolean isMIUIV9() {
        return "v9".equals(sMiuiVersionName);
    }

    public static boolean isFlymeLowerThan(int majorVersion) {
        return QMUIDeviceHelper.isFlymeLowerThan(majorVersion, 0, 0);
    }

    public static boolean isFlymeLowerThan(int majorVersion, int minorVersion, int patchVersion) {
        boolean isLower = false;
        if (sFlymeVersionName != null && !sFlymeVersionName.equals("")) {
            try {
                String versionString;
                Pattern pattern = Pattern.compile("(\\d+\\.){2}\\d");
                Matcher matcher = pattern.matcher(sFlymeVersionName);
                if (matcher.find() && (versionString = matcher.group()).length() > 0) {
                    String[] version = versionString.split("\\.");
                    if (version.length >= 1 && Integer.parseInt(version[0]) < majorVersion) {
                        isLower = true;
                    }
                    if (version.length >= 2 && minorVersion > 0 && Integer.parseInt(version[1]) < majorVersion) {
                        isLower = true;
                    }
                    if (version.length >= 3 && patchVersion > 0 && Integer.parseInt(version[2]) < majorVersion) {
                        isLower = true;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return QMUIDeviceHelper.isMeizu() && isLower;
    }

    public static boolean isMeizu() {
        return QMUIDeviceHelper.isPhone(MEIZUBOARD) || QMUIDeviceHelper.isFlyme();
    }

    public static boolean isXiaomi() {
        return Build.MANUFACTURER.toLowerCase().equals("xiaomi");
    }

    public static boolean isVivo() {
        return BRAND.contains("vivo") || BRAND.contains("bbk");
    }

    public static boolean isOppo() {
        return BRAND.contains("oppo");
    }

    public static boolean isHuawei() {
        return BRAND.contains("huawei") || BRAND.contains("honor");
    }

    public static boolean isEssentialPhone() {
        return BRAND.contains(ESSENTIAL);
    }

    public static boolean isZUKZ1() {
        String board = Build.MODEL;
        return board != null && board.toLowerCase().contains(ZUKZ1);
    }

    public static boolean isZTKC2016() {
        String board = Build.MODEL;
        return board != null && board.toLowerCase().contains(ZTEC2016);
    }

    private static boolean isPhone(String[] boards) {
        String board = Build.BOARD;
        if (board == null) {
            return false;
        }
        for (String board1 : boards) {
            if (!board.equals(board1)) continue;
            return true;
        }
        return false;
    }

    public static long getTotalMemory(Context context) {
        if (sTotalMemory != -1L) {
            return sTotalMemory;
        }
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        if (activityManager != null) {
            activityManager.getMemoryInfo(memoryInfo);
            sTotalMemory = memoryInfo.totalMem;
        }
        return sTotalMemory;
    }

    public static long getInnerStorageSize() {
        if (sInnerStorageSize != -1L) {
            return sInnerStorageSize;
        }
        File dataDir = Environment.getDataDirectory();
        if (dataDir == null) {
            return 0L;
        }
        sInnerStorageSize = dataDir.getTotalSpace();
        return sInnerStorageSize;
    }

    public static boolean hasExtraStorage() {
        return "mounted".equals(Environment.getExternalStorageState());
    }

    public static long getExtraStorageSize() {
        if (sExtraStorageSize != -1L) {
            return sExtraStorageSize;
        }
        if (!QMUIDeviceHelper.hasExtraStorage()) {
            return 0L;
        }
        File path = Environment.getExternalStorageDirectory();
        StatFs stat = new StatFs(path.getPath());
        long blockSize = stat.getBlockSizeLong();
        long availableBlocks = stat.getBlockCountLong();
        sExtraStorageSize = blockSize * availableBlocks;
        return sExtraStorageSize;
    }

    public static long getTotalStorageSize() {
        return QMUIDeviceHelper.getInnerStorageSize() + QMUIDeviceHelper.getExtraStorageSize();
    }

    public static int getCpuCoreCount() {
        int cores;
        if (sCpuCoreCount != -1) {
            return sCpuCoreCount;
        }
        try {
            cores = QMUIDeviceHelper.getCoresFromFile(CPU_FILE_PATH_1);
            if (cores == 0) {
                cores = QMUIDeviceHelper.getCoresFromFile(CPU_FILE_PATH_2);
            }
            if (cores == 0) {
                cores = QMUIDeviceHelper.getCoresFromCPUFiles(CPU_FILE_PATH_0);
            }
        }
        catch (Exception e) {
            cores = 0;
        }
        if (cores == 0) {
            cores = 1;
        }
        sCpuCoreCount = cores;
        return cores;
    }

    private static int getCoresFromCPUFiles(String path) {
        File[] list = new File(path).listFiles(CPU_FILTER);
        return null == list ? 0 : list.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getCoresFromFile(String file) {
        int n;
        String fileContents;
        FileInputStream is;
        block5: {
            is = null;
            is = new FileInputStream(file);
            BufferedReader buf = new BufferedReader(new InputStreamReader((InputStream)is, StandardCharsets.UTF_8));
            fileContents = buf.readLine();
            buf.close();
            if (fileContents != null && fileContents.matches("0-[\\d]+$")) break block5;
            int n2 = 0;
            QMUILangHelper.close(is);
            return n2;
        }
        try {
            String num = fileContents.substring(2);
            n = Integer.parseInt(num) + 1;
        }
        catch (IOException e) {
            int n3;
            try {
                n3 = 0;
            }
            catch (Throwable throwable) {
                QMUILangHelper.close(is);
                throw throwable;
            }
            QMUILangHelper.close(is);
            return n3;
        }
        QMUILangHelper.close(is);
        return n;
    }

    public static boolean isFloatWindowOpAllowed(Context context) {
        int version = Build.VERSION.SDK_INT;
        return QMUIDeviceHelper.checkOp(context, 24);
    }

    public static double getBatteryCapacity(Context context) {
        double ret;
        if (sBatteryCapacity != -1.0) {
            return sBatteryCapacity;
        }
        try {
            Class<?> cls = Class.forName(POWER_PROFILE_CLASS);
            Object instance = cls.getConstructor(Context.class).newInstance(context);
            Method method = cls.getMethod("getBatteryCapacity", new Class[0]);
            ret = (Double)method.invoke(instance, new Object[0]);
        }
        catch (Exception ignore) {
            ret = -1.0;
        }
        sBatteryCapacity = ret;
        return sBatteryCapacity;
    }

    private static boolean checkOp(Context context, int op) {
        AppOpsManager manager = (AppOpsManager)context.getSystemService("appops");
        try {
            Method method = manager.getClass().getDeclaredMethod("checkOp", Integer.TYPE, Integer.TYPE, String.class);
            int property = (Integer)method.invoke((Object)manager, op, Binder.getCallingUid(), context.getPackageName());
            return 0 == property;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Nullable
    private static String getLowerCaseName(Properties p, Method get, String key) {
        String name = p.getProperty(key);
        if (name == null) {
            try {
                name = (String)get.invoke(null, key);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (name != null) {
            name = name.toLowerCase();
        }
        return name;
    }

    static {
        sIsTabletChecked = false;
        sIsTabletValue = false;
        BRAND = Build.BRAND.toLowerCase();
        sTotalMemory = -1L;
        sInnerStorageSize = -1L;
        sExtraStorageSize = -1L;
        sBatteryCapacity = -1.0;
        sCpuCoreCount = -1;
        Properties properties = new Properties();
        if (Build.VERSION.SDK_INT < 26) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(new File(Environment.getRootDirectory(), "build.prop"));
                properties.load(fileInputStream);
            }
            catch (Exception e) {
                try {
                    QMUILog.printErrStackTrace(TAG, e, "read file error", new Object[0]);
                }
                catch (Throwable throwable) {
                    QMUILangHelper.close(fileInputStream);
                    throw throwable;
                }
                QMUILangHelper.close(fileInputStream);
            }
            QMUILangHelper.close(fileInputStream);
        }
        Class<?> clzSystemProperties = null;
        try {
            clzSystemProperties = Class.forName("android.os.SystemProperties");
            Method getMethod = clzSystemProperties.getDeclaredMethod("get", String.class);
            sMiuiVersionName = QMUIDeviceHelper.getLowerCaseName(properties, getMethod, KEY_MIUI_VERSION_NAME);
            sFlymeVersionName = QMUIDeviceHelper.getLowerCaseName(properties, getMethod, KEY_FLYME_VERSION_NAME);
        }
        catch (Exception e) {
            QMUILog.printErrStackTrace(TAG, e, "read SystemProperties error", new Object[0]);
        }
    }
}

