/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.span;

import android.content.res.Resources;
import android.text.TextPaint;
import android.text.style.ClickableSpan;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.core.view.ViewCompat;
import com.qmuiteam.qmui.QMUILog;
import com.qmuiteam.qmui.link.ITouchableSpan;
import com.qmuiteam.qmui.skin.IQMUISkinHandlerSpan;
import com.qmuiteam.qmui.skin.QMUISkinHelper;
import com.qmuiteam.qmui.skin.QMUISkinManager;
import com.qmuiteam.qmui.util.QMUIResHelper;
import org.jetbrains.annotations.NotNull;

public abstract class QMUITouchableSpan
extends ClickableSpan
implements ITouchableSpan,
IQMUISkinHandlerSpan {
    private static final String TAG = "QMUITouchableSpan";
    private boolean mIsPressed;
    @ColorInt
    private int mNormalBackgroundColor;
    @ColorInt
    private int mPressedBackgroundColor;
    @ColorInt
    private int mNormalTextColor;
    @ColorInt
    private int mPressedTextColor;
    private int mNormalBgAttr;
    private int mPressedBgAttr;
    private int mNormalTextColorAttr;
    private int mPressedTextColorAttr;
    private boolean mIsNeedUnderline = false;

    public abstract void onSpanClick(View var1);

    @Override
    public final void onClick(View widget) {
        if (ViewCompat.isAttachedToWindow((View)widget)) {
            this.onSpanClick(widget);
        }
    }

    public QMUITouchableSpan(@ColorInt int normalTextColor, @ColorInt int pressedTextColor, @ColorInt int normalBackgroundColor, @ColorInt int pressedBackgroundColor) {
        this.mNormalTextColor = normalTextColor;
        this.mPressedTextColor = pressedTextColor;
        this.mNormalBackgroundColor = normalBackgroundColor;
        this.mPressedBackgroundColor = pressedBackgroundColor;
    }

    public QMUITouchableSpan(View initFollowSkinView, int normalTextColorAttr, int pressedTextColorAttr, int normalBgAttr, int pressedBgAttr) {
        this.mNormalBgAttr = normalBgAttr;
        this.mPressedBgAttr = pressedBgAttr;
        this.mNormalTextColorAttr = normalTextColorAttr;
        this.mPressedTextColorAttr = pressedTextColorAttr;
        if (normalTextColorAttr != 0) {
            this.mNormalTextColor = QMUISkinHelper.getSkinColor(initFollowSkinView, normalTextColorAttr);
        }
        if (pressedTextColorAttr != 0) {
            this.mPressedTextColor = QMUISkinHelper.getSkinColor(initFollowSkinView, pressedTextColorAttr);
        }
        if (normalBgAttr != 0) {
            this.mNormalBackgroundColor = QMUISkinHelper.getSkinColor(initFollowSkinView, normalBgAttr);
        }
        if (pressedBgAttr != 0) {
            this.mPressedBackgroundColor = QMUISkinHelper.getSkinColor(initFollowSkinView, pressedBgAttr);
        }
    }

    public int getNormalBackgroundColor() {
        return this.mNormalBackgroundColor;
    }

    public void setNormalTextColor(int normalTextColor) {
        this.mNormalTextColor = normalTextColor;
    }

    public void setPressedTextColor(int pressedTextColor) {
        this.mPressedTextColor = pressedTextColor;
    }

    public int getNormalTextColor() {
        return this.mNormalTextColor;
    }

    public int getPressedBackgroundColor() {
        return this.mPressedBackgroundColor;
    }

    public int getPressedTextColor() {
        return this.mPressedTextColor;
    }

    @Override
    public void setPressed(boolean isSelected) {
        this.mIsPressed = isSelected;
    }

    public boolean isPressed() {
        return this.mIsPressed;
    }

    public void setIsNeedUnderline(boolean isNeedUnderline) {
        this.mIsNeedUnderline = isNeedUnderline;
    }

    public boolean isNeedUnderline() {
        return this.mIsNeedUnderline;
    }

    public void updateDrawState(TextPaint ds) {
        ds.setColor(this.mIsPressed ? this.mPressedTextColor : this.mNormalTextColor);
        ds.bgColor = this.mIsPressed ? this.mPressedBackgroundColor : this.mNormalBackgroundColor;
        ds.setUnderlineText(this.mIsNeedUnderline);
    }

    @Override
    public void handle(@NotNull View view, @NotNull QMUISkinManager manager, int skinIndex, @NotNull Resources.Theme theme) {
        boolean noAttrExist = true;
        if (this.mNormalTextColorAttr != 0) {
            this.mNormalTextColor = QMUIResHelper.getAttrColor(theme, this.mNormalTextColorAttr);
            noAttrExist = false;
        }
        if (this.mPressedTextColorAttr != 0) {
            this.mPressedTextColor = QMUIResHelper.getAttrColor(theme, this.mPressedTextColorAttr);
            noAttrExist = false;
        }
        if (this.mNormalBgAttr != 0) {
            this.mNormalBackgroundColor = QMUIResHelper.getAttrColor(theme, this.mNormalBgAttr);
            noAttrExist = false;
        }
        if (this.mPressedBgAttr != 0) {
            this.mPressedBackgroundColor = QMUIResHelper.getAttrColor(theme, this.mPressedBgAttr);
            noAttrExist = false;
        }
        if (noAttrExist) {
            QMUILog.w(TAG, "There are no attrs for skin. Please use constructor with 5 parameters", new Object[0]);
        }
    }
}

