/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.skin;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.res.Resources;
import android.text.Spanned;
import android.util.ArrayMap;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.SimpleArrayMap;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager.widget.ViewPager;
import com.qmuiteam.qmui.QMUILog;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.qqface.QMUIQQFaceView;
import com.qmuiteam.qmui.skin.IQMUISkinApplyListener;
import com.qmuiteam.qmui.skin.IQMUISkinDispatchInterceptor;
import com.qmuiteam.qmui.skin.IQMUISkinHandlerDecoration;
import com.qmuiteam.qmui.skin.IQMUISkinHandlerSpan;
import com.qmuiteam.qmui.skin.IQMUISkinHandlerView;
import com.qmuiteam.qmui.skin.annotation.QMUISkinListenWithHierarchyChange;
import com.qmuiteam.qmui.skin.defaultAttr.IQMUISkinDefaultAttrProvider;
import com.qmuiteam.qmui.skin.handler.IQMUISkinRuleHandler;
import com.qmuiteam.qmui.skin.handler.QMUISkinRuleAlphaHandler;
import com.qmuiteam.qmui.skin.handler.QMUISkinRuleBackgroundHandler;
import com.qmuiteam.qmui.skin.handler.QMUISkinRuleBgTintColorHandler;
import com.qmuiteam.qmui.skin.handler.QMUISkinRuleBorderHandler;
import com.qmuiteam.qmui.skin.handler.QMUISkinRuleHintColorHandler;
import com.qmuiteam.qmui.skin.handler.QMUISkinRuleMoreBgColorHandler;
import com.qmuiteam.qmui.skin.handler.QMUISkinRuleMoreTextColorHandler;
import com.qmuiteam.qmui.skin.handler.QMUISkinRuleProgressColorHandler;
import com.qmuiteam.qmui.skin.handler.QMUISkinRuleSeparatorHandler;
import com.qmuiteam.qmui.skin.handler.QMUISkinRuleSrcHandler;
import com.qmuiteam.qmui.skin.handler.QMUISkinRuleTextColorHandler;
import com.qmuiteam.qmui.skin.handler.QMUISkinRuleTextCompoundSrcHandler;
import com.qmuiteam.qmui.skin.handler.QMUISkinRuleTextCompoundTintColorHandler;
import com.qmuiteam.qmui.skin.handler.QMUISkinRuleTintColorHandler;
import com.qmuiteam.qmui.skin.handler.QMUISkinRuleUnderlineHandler;
import com.qmuiteam.qmui.util.QMUILangHelper;
import com.qmuiteam.qmui.util.QMUIResHelper;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public final class QMUISkinManager {
    private static final String TAG = "QMUISkinManager";
    public static final int DEFAULT_SKIN = -1;
    private static final String[] EMPTY_ITEMS = new String[0];
    private static ArrayMap<String, QMUISkinManager> sInstances = new ArrayMap();
    private static final String DEFAULT_NAME = "default";
    public static final DispatchListenStrategySelector DEFAULT_DISPATCH_LISTEN_STRATEGY_SELECTOR;
    private static DispatchListenStrategySelector sDispatchListenStrategySelector;
    private String mName;
    private Resources mResources;
    private String mPackageName;
    private SparseArray<SkinItem> mSkins = new SparseArray();
    private static HashMap<String, IQMUISkinRuleHandler> sRuleHandlers;
    private static HashMap<Integer, Resources.Theme> sStyleIdThemeMap;
    private boolean mIsInSkinChangeDispatch = false;
    private static View.OnLayoutChangeListener mOnLayoutChangeListener;
    private static ViewGroup.OnHierarchyChangeListener mOnHierarchyChangeListener;
    private int mCurrentSkin = -1;
    private final List<WeakReference<?>> mSkinObserverList = new ArrayList();
    private final List<OnSkinChangeListener> mSkinChangeListeners = new ArrayList<OnSkinChangeListener>();

    public static void setDispatchListenStrategySelector(DispatchListenStrategySelector dispatchListenStrategySelector) {
        sDispatchListenStrategySelector = dispatchListenStrategySelector == null ? DEFAULT_DISPATCH_LISTEN_STRATEGY_SELECTOR : dispatchListenStrategySelector;
    }

    @MainThread
    public static QMUISkinManager defaultInstance(Context context) {
        context = context.getApplicationContext();
        return QMUISkinManager.of(DEFAULT_NAME, context.getResources(), context.getPackageName());
    }

    @MainThread
    public static QMUISkinManager of(String name, Resources resources, String packageName) {
        QMUISkinManager instance = (QMUISkinManager)sInstances.get((Object)name);
        if (instance == null) {
            instance = new QMUISkinManager(name, resources, packageName);
            sInstances.put((Object)name, (Object)instance);
        }
        return instance;
    }

    @MainThread
    public static QMUISkinManager of(String name, Context context) {
        context = context.getApplicationContext();
        return QMUISkinManager.of(name, context.getResources(), context.getPackageName());
    }

    public static void setRuleHandler(String name, IQMUISkinRuleHandler handler) {
        sRuleHandlers.put(name, handler);
    }

    public QMUISkinManager(String name, Resources resources, String packageName) {
        this.mName = name;
        this.mResources = resources;
        this.mPackageName = packageName;
    }

    public String getName() {
        return this.mName;
    }

    @Nullable
    public Resources.Theme getTheme(int skinIndex) {
        SkinItem skinItem = (SkinItem)this.mSkins.get(skinIndex);
        if (skinItem != null) {
            return skinItem.getTheme();
        }
        return null;
    }

    @Nullable
    public Resources.Theme getCurrentTheme() {
        SkinItem skinItem = (SkinItem)this.mSkins.get(this.mCurrentSkin);
        if (skinItem != null) {
            return skinItem.getTheme();
        }
        return null;
    }

    @MainThread
    public void addSkin(int index, int styleRes) {
        if (index <= 0) {
            throw new IllegalArgumentException("index must greater than 0");
        }
        SkinItem skinItem = (SkinItem)this.mSkins.get(index);
        if (skinItem != null) {
            if (skinItem.getStyleRes() == styleRes) {
                return;
            }
            throw new RuntimeException("already exist the theme item for " + index);
        }
        skinItem = new SkinItem(styleRes);
        this.mSkins.append(index, (Object)skinItem);
    }

    static ViewSkinCurrent getViewSkinCurrent(View view) {
        Object current = view.getTag(R.id.qmui_skin_current);
        if (current instanceof ViewSkinCurrent) {
            return (ViewSkinCurrent)current;
        }
        return null;
    }

    public void dispatch(View view, int skinIndex) {
        Resources.Theme theme;
        if (view == null) {
            return;
        }
        SkinItem skinItem = (SkinItem)this.mSkins.get(skinIndex);
        if (skinItem == null) {
            if (skinIndex != -1) {
                throw new IllegalArgumentException("The skin " + skinIndex + " does not exist");
            }
            theme = view.getContext().getTheme();
        } else {
            theme = skinItem.getTheme();
        }
        this.runDispatch(view, skinIndex, theme);
    }

    private void runDispatch(@NonNull View view, int skinIndex, Resources.Theme theme) {
        CharSequence text;
        boolean ignoreApply;
        ViewSkinCurrent currentTheme = QMUISkinManager.getViewSkinCurrent(view);
        if (currentTheme != null && currentTheme.index == skinIndex && Objects.equals(currentTheme.managerName, this.mName)) {
            return;
        }
        view.setTag(R.id.qmui_skin_current, (Object)new ViewSkinCurrent(this.mName, skinIndex));
        if (view instanceof IQMUISkinDispatchInterceptor && ((IQMUISkinDispatchInterceptor)view).intercept(skinIndex, theme)) {
            return;
        }
        Object interceptTag = view.getTag(R.id.qmui_skin_intercept_dispatch);
        if (interceptTag instanceof Boolean && ((Boolean)interceptTag).booleanValue()) {
            return;
        }
        Object ignoreApplyTag = view.getTag(R.id.qmui_skin_ignore_apply);
        boolean bl = ignoreApply = ignoreApplyTag instanceof Boolean && (Boolean)ignoreApplyTag != false;
        if (!ignoreApply) {
            this.applyTheme(view, skinIndex, theme);
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            if (sDispatchListenStrategySelector.select(viewGroup) == DispatchListenStrategy.LISTEN_ON_HIERARCHY_CHANGE) {
                viewGroup.setOnHierarchyChangeListener(mOnHierarchyChangeListener);
            } else {
                viewGroup.addOnLayoutChangeListener(mOnLayoutChangeListener);
            }
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                this.runDispatch(viewGroup.getChildAt(i), skinIndex, theme);
            }
        } else if (!ignoreApply && (view instanceof TextView || view instanceof QMUIQQFaceView) && (text = view instanceof TextView ? ((TextView)view).getText() : ((QMUIQQFaceView)view).getText()) instanceof Spanned) {
            IQMUISkinHandlerSpan[] spans = (IQMUISkinHandlerSpan[])((Spanned)text).getSpans(0, text.length(), IQMUISkinHandlerSpan.class);
            if (spans != null) {
                for (int i = 0; i < spans.length; ++i) {
                    spans[i].handle(view, this, skinIndex, theme);
                }
            }
            view.invalidate();
        }
    }

    private void applyTheme(@NonNull View view, int skinIndex, Resources.Theme theme) {
        SimpleArrayMap<String, Integer> attrs = this.getSkinAttrs(view);
        try {
            if (view instanceof IQMUISkinHandlerView) {
                ((IQMUISkinHandlerView)view).handle(this, skinIndex, theme, attrs);
            } else {
                this.defaultHandleSkinAttrs(view, theme, attrs);
            }
            Object skinApplyListener = view.getTag(R.id.qmui_skin_apply_listener);
            if (skinApplyListener instanceof IQMUISkinApplyListener) {
                ((IQMUISkinApplyListener)skinApplyListener).onApply(view, skinIndex, theme);
            }
            if (view instanceof RecyclerView) {
                RecyclerView recyclerView = (RecyclerView)view;
                int itemDecorationCount = recyclerView.getItemDecorationCount();
                for (int i = 0; i < itemDecorationCount; ++i) {
                    RecyclerView.ItemDecoration itemDecoration = recyclerView.getItemDecorationAt(i);
                    if (!(itemDecoration instanceof IQMUISkinHandlerDecoration)) continue;
                    ((IQMUISkinHandlerDecoration)itemDecoration).handle(recyclerView, this, skinIndex, theme);
                }
            }
        }
        catch (Throwable throwable) {
            QMUILog.printErrStackTrace(TAG, throwable, "catch error when apply theme: " + view.getClass().getSimpleName() + "; " + skinIndex + "; attrs = " + (attrs == null ? "null" : attrs.toString()), new Object[0]);
        }
    }

    void refreshRecyclerDecoration(@NonNull RecyclerView recyclerView, @NonNull IQMUISkinHandlerDecoration decoration, int skinIndex) {
        SkinItem skinItem = (SkinItem)this.mSkins.get(skinIndex);
        if (skinItem != null) {
            decoration.handle(recyclerView, this, skinIndex, skinItem.getTheme());
        }
    }

    void refreshTheme(@NonNull View view, int skinIndex) {
        SkinItem skinItem = (SkinItem)this.mSkins.get(skinIndex);
        if (skinItem != null) {
            this.applyTheme(view, skinIndex, skinItem.getTheme());
        }
    }

    public void defaultHandleSkinAttrs(@NonNull View view, Resources.Theme theme, @Nullable SimpleArrayMap<String, Integer> attrs) {
        if (attrs != null) {
            for (int i = 0; i < attrs.size(); ++i) {
                String key = (String)attrs.keyAt(i);
                Integer attr2 = (Integer)attrs.valueAt(i);
                if (attr2 == null) continue;
                this.defaultHandleSkinAttr(view, theme, key, attr2);
            }
        }
    }

    public void defaultHandleSkinAttr(View view, Resources.Theme theme, String name, int attr2) {
        if (attr2 == 0) {
            return;
        }
        IQMUISkinRuleHandler handler = sRuleHandlers.get(name);
        if (handler == null) {
            QMUILog.w(TAG, "Do not find handler for skin attr name: " + name, new Object[0]);
            return;
        }
        handler.handle(this, view, theme, name, attr2);
    }

    @Nullable
    private SimpleArrayMap<String, Integer> getSkinAttrs(View view) {
        SimpleArrayMap<String, Integer> providedAttrs;
        IQMUISkinDefaultAttrProvider provider;
        SimpleArrayMap<String, Integer> defaultAttrs;
        String skinValue = (String)view.getTag(R.id.qmui_skin_value);
        String[] items = skinValue == null || skinValue.isEmpty() ? EMPTY_ITEMS : skinValue.split("[|]");
        SimpleArrayMap attrs = null;
        if (view instanceof IQMUISkinDefaultAttrProvider && (defaultAttrs = ((IQMUISkinDefaultAttrProvider)view).getDefaultSkinAttrs()) != null && !defaultAttrs.isEmpty()) {
            attrs = new SimpleArrayMap(defaultAttrs);
        }
        if ((provider = (IQMUISkinDefaultAttrProvider)view.getTag(R.id.qmui_skin_default_attr_provider)) != null && (providedAttrs = provider.getDefaultSkinAttrs()) != null && !providedAttrs.isEmpty()) {
            if (attrs != null) {
                attrs.putAll(providedAttrs);
            } else {
                attrs = new SimpleArrayMap(providedAttrs);
            }
        }
        if (attrs == null) {
            if (items.length <= 0) {
                return null;
            }
            attrs = new SimpleArrayMap(items.length);
        }
        for (String item : items) {
            String key;
            String[] kv = item.split(":");
            if (kv.length != 2 || QMUILangHelper.isNullOrEmpty(key = kv[0].trim())) continue;
            int attr2 = this.getAttrFromName(kv[1].trim());
            if (attr2 == 0) {
                QMUILog.w(TAG, "Failed to get attr id from name: " + kv[1], new Object[0]);
                continue;
            }
            attrs.put((Object)key, (Object)attr2);
        }
        return attrs;
    }

    public int getAttrFromName(String attrName) {
        return this.mResources.getIdentifier(attrName, "attr", this.mPackageName);
    }

    public void register(@NonNull Activity activity) {
        if (!this.containSkinObserver(activity)) {
            this.mSkinObserverList.add(new WeakReference<Activity>(activity));
        }
        this.dispatch(activity.findViewById(0x1020002), this.mCurrentSkin);
    }

    public void unRegister(@NonNull Activity activity) {
        this.removeSkinObserver(activity);
    }

    public void register(@NonNull Fragment fragment) {
        if (!this.containSkinObserver(fragment)) {
            this.mSkinObserverList.add(new WeakReference<Fragment>(fragment));
        }
        this.dispatch(fragment.getView(), this.mCurrentSkin);
    }

    public void unRegister(@NonNull Fragment fragment) {
        this.removeSkinObserver(fragment);
    }

    public void register(@NonNull View view) {
        if (!this.containSkinObserver(view)) {
            this.mSkinObserverList.add(new WeakReference<View>(view));
        }
        this.dispatch(view, this.mCurrentSkin);
    }

    public void unRegister(@NonNull View view) {
        this.removeSkinObserver(view);
    }

    public void register(@NonNull Dialog dialog) {
        Window window;
        if (!this.containSkinObserver(dialog)) {
            this.mSkinObserverList.add(new WeakReference<Dialog>(dialog));
        }
        if ((window = dialog.getWindow()) != null) {
            this.dispatch(window.getDecorView(), this.mCurrentSkin);
        }
    }

    public void unRegister(@NonNull Dialog dialog) {
        this.removeSkinObserver(dialog);
    }

    public void register(@NonNull PopupWindow popupWindow) {
        if (!this.containSkinObserver(popupWindow)) {
            this.mSkinObserverList.add(new WeakReference<PopupWindow>(popupWindow));
        }
        this.dispatch(popupWindow.getContentView(), this.mCurrentSkin);
    }

    public void unRegister(@NonNull PopupWindow popupWindow) {
        this.removeSkinObserver(popupWindow);
    }

    public void register(@NonNull Window window) {
        if (!this.containSkinObserver(window)) {
            this.mSkinObserverList.add(new WeakReference<Window>(window));
        }
        this.dispatch(window.getDecorView(), this.mCurrentSkin);
    }

    public void unRegister(@NonNull Window window) {
        this.removeSkinObserver(window);
    }

    private void removeSkinObserver(Object object) {
        for (int i = this.mSkinObserverList.size() - 1; i >= 0; --i) {
            Object item = this.mSkinObserverList.get(i).get();
            if (item == object) {
                this.mSkinObserverList.remove(i);
                return;
            }
            if (item != null) continue;
            this.mSkinObserverList.remove(i);
        }
    }

    private boolean containSkinObserver(Object object) {
        for (int i = this.mSkinObserverList.size() - 1; i >= 0; --i) {
            Object item = this.mSkinObserverList.get(i).get();
            if (item == object) {
                return true;
            }
            if (item != null) continue;
            this.mSkinObserverList.remove(i);
        }
        return false;
    }

    @MainThread
    public void changeSkin(int index) {
        Object item;
        int i;
        if (this.mCurrentSkin == index) {
            return;
        }
        int oldIndex = this.mCurrentSkin;
        this.mCurrentSkin = index;
        this.mIsInSkinChangeDispatch = true;
        for (i = this.mSkinObserverList.size() - 1; i >= 0; --i) {
            item = this.mSkinObserverList.get(i).get();
            if (item == null) {
                this.mSkinObserverList.remove(i);
                continue;
            }
            if (item instanceof Activity) {
                Activity activity = (Activity)item;
                activity.getWindow().setBackgroundDrawable(QMUIResHelper.getAttrDrawable((Context)activity, ((SkinItem)this.mSkins.get(index)).getTheme(), R.attr.qmui_skin_support_activity_background));
                this.dispatch(activity.findViewById(0x1020002), index);
                continue;
            }
            if (item instanceof Fragment) {
                this.dispatch(((Fragment)item).getView(), index);
                continue;
            }
            if (item instanceof Dialog) {
                Window window = ((Dialog)item).getWindow();
                if (window == null) continue;
                this.dispatch(window.getDecorView(), index);
                continue;
            }
            if (item instanceof PopupWindow) {
                this.dispatch(((PopupWindow)item).getContentView(), index);
                continue;
            }
            if (item instanceof Window) {
                this.dispatch(((Window)item).getDecorView(), index);
                continue;
            }
            if (!(item instanceof View)) continue;
            this.dispatch((View)item, index);
        }
        for (i = this.mSkinChangeListeners.size() - 1; i >= 0; --i) {
            item = this.mSkinChangeListeners.get(i);
            item.onSkinChange(this, oldIndex, this.mCurrentSkin);
        }
        this.mIsInSkinChangeDispatch = false;
    }

    @MainThread
    public void addSkinChangeListener(@NonNull OnSkinChangeListener listener) {
        if (this.mIsInSkinChangeDispatch) {
            throw new RuntimeException("Can not add skinChangeListener while dispatching");
        }
        this.mSkinChangeListeners.add(listener);
    }

    public void removeSkinChangeListener(@NonNull OnSkinChangeListener listener) {
        if (this.mIsInSkinChangeDispatch) {
            throw new RuntimeException("Can not add skinChangeListener while dispatching");
        }
        this.mSkinChangeListeners.remove(listener);
    }

    public int getCurrentSkin() {
        return this.mCurrentSkin;
    }

    static {
        sDispatchListenStrategySelector = DEFAULT_DISPATCH_LISTEN_STRATEGY_SELECTOR = new DispatchListenStrategySelector(){

            @Override
            @NonNull
            public DispatchListenStrategy select(@NonNull ViewGroup viewGroup) {
                if (viewGroup instanceof RecyclerView || viewGroup instanceof ViewPager || viewGroup instanceof AdapterView || viewGroup.getClass().isAnnotationPresent(QMUISkinListenWithHierarchyChange.class)) {
                    return DispatchListenStrategy.LISTEN_ON_HIERARCHY_CHANGE;
                }
                return DispatchListenStrategy.LISTEN_ON_LAYOUT;
            }
        };
        sRuleHandlers = new HashMap();
        sStyleIdThemeMap = new HashMap();
        sRuleHandlers.put("background", new QMUISkinRuleBackgroundHandler());
        QMUISkinRuleTextColorHandler textColorHandler = new QMUISkinRuleTextColorHandler();
        sRuleHandlers.put("textColor", textColorHandler);
        sRuleHandlers.put("secondTextColor", textColorHandler);
        sRuleHandlers.put("src", new QMUISkinRuleSrcHandler());
        sRuleHandlers.put("border", new QMUISkinRuleBorderHandler());
        QMUISkinRuleSeparatorHandler separatorHandler = new QMUISkinRuleSeparatorHandler();
        sRuleHandlers.put("topSeparator", separatorHandler);
        sRuleHandlers.put("rightSeparator", separatorHandler);
        sRuleHandlers.put("bottomSeparator", separatorHandler);
        sRuleHandlers.put("LeftSeparator", separatorHandler);
        sRuleHandlers.put("tintColor", new QMUISkinRuleTintColorHandler());
        sRuleHandlers.put("alpha", new QMUISkinRuleAlphaHandler());
        sRuleHandlers.put("bgTintColor", new QMUISkinRuleBgTintColorHandler());
        sRuleHandlers.put("progressColor", new QMUISkinRuleProgressColorHandler());
        sRuleHandlers.put("tcTintColor", new QMUISkinRuleTextCompoundTintColorHandler());
        QMUISkinRuleTextCompoundSrcHandler textCompoundSrcHandler = new QMUISkinRuleTextCompoundSrcHandler();
        sRuleHandlers.put("tclSrc", textCompoundSrcHandler);
        sRuleHandlers.put("tctSrc", textCompoundSrcHandler);
        sRuleHandlers.put("tcrSrc", textCompoundSrcHandler);
        sRuleHandlers.put("tcbSrc", textCompoundSrcHandler);
        sRuleHandlers.put("hintColor", new QMUISkinRuleHintColorHandler());
        sRuleHandlers.put("underline", new QMUISkinRuleUnderlineHandler());
        sRuleHandlers.put("moreTextColor", new QMUISkinRuleMoreTextColorHandler());
        sRuleHandlers.put("moreBgColor", new QMUISkinRuleMoreBgColorHandler());
        mOnLayoutChangeListener = new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                ViewSkinCurrent current;
                ViewGroup viewGroup;
                int childCount;
                if (v instanceof ViewGroup && (childCount = (viewGroup = (ViewGroup)v).getChildCount()) > 0 && (current = QMUISkinManager.getViewSkinCurrent((View)viewGroup)) != null) {
                    for (int i = 0; i < childCount; ++i) {
                        View child = viewGroup.getChildAt(i);
                        ViewSkinCurrent childTheme = QMUISkinManager.getViewSkinCurrent(child);
                        if (current.equals(childTheme)) continue;
                        QMUISkinManager.of(current.managerName, child.getContext()).dispatch(child, current.index);
                    }
                }
            }
        };
        mOnHierarchyChangeListener = new ViewGroup.OnHierarchyChangeListener(){

            public void onChildViewAdded(View parent, View child) {
                ViewSkinCurrent childTheme;
                ViewSkinCurrent current = QMUISkinManager.getViewSkinCurrent(parent);
                if (current != null && !current.equals(childTheme = QMUISkinManager.getViewSkinCurrent(child))) {
                    QMUISkinManager.of(current.managerName, child.getContext()).dispatch(child, current.index);
                }
            }

            public void onChildViewRemoved(View parent, View child) {
            }
        };
    }

    public static enum DispatchListenStrategy {
        LISTEN_ON_LAYOUT,
        LISTEN_ON_HIERARCHY_CHANGE;

    }

    public static interface DispatchListenStrategySelector {
        @NonNull
        public DispatchListenStrategy select(@NonNull ViewGroup var1);
    }

    class ViewSkinCurrent {
        String managerName;
        int index;

        ViewSkinCurrent(String managerName, int index) {
            this.managerName = managerName;
            this.index = index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ViewSkinCurrent that = (ViewSkinCurrent)o;
            return this.index == that.index && Objects.equals(this.managerName, that.managerName);
        }

        public int hashCode() {
            return Objects.hash(this.managerName, this.index);
        }
    }

    public static interface OnSkinChangeListener {
        public void onSkinChange(QMUISkinManager var1, int var2, int var3);
    }

    class SkinItem {
        private int styleRes;

        SkinItem(int styleRes) {
            this.styleRes = styleRes;
        }

        public int getStyleRes() {
            return this.styleRes;
        }

        @NonNull
        Resources.Theme getTheme() {
            Resources.Theme theme = (Resources.Theme)sStyleIdThemeMap.get(this.styleRes);
            if (theme == null) {
                theme = QMUISkinManager.this.mResources.newTheme();
                theme.applyStyle(this.styleRes, true);
                sStyleIdThemeMap.put(this.styleRes, theme);
            }
            return theme;
        }
    }
}

