/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.skin;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.qmuiteam.qmui.QMUILog;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.skin.IQMUISkinApplyListener;
import com.qmuiteam.qmui.skin.IQMUISkinHandlerDecoration;
import com.qmuiteam.qmui.skin.QMUISkinManager;
import com.qmuiteam.qmui.skin.QMUISkinValueBuilder;
import com.qmuiteam.qmui.skin.SkinWriter;
import com.qmuiteam.qmui.skin.defaultAttr.IQMUISkinDefaultAttrProvider;
import com.qmuiteam.qmui.util.QMUIResHelper;

public class QMUISkinHelper {
    public static QMUISkinValueBuilder sSkinValueBuilder = QMUISkinValueBuilder.acquire();

    public static Resources.Theme getSkinTheme(@NonNull View view) {
        QMUISkinManager.ViewSkinCurrent current = QMUISkinManager.getViewSkinCurrent(view);
        Resources.Theme theme = current == null || current.index < 0 ? view.getContext().getTheme() : QMUISkinManager.of(current.managerName, view.getContext()).getTheme(current.index);
        return theme;
    }

    public static int getSkinColor(@NonNull View view, int colorAttr) {
        return QMUIResHelper.getAttrColor(QMUISkinHelper.getSkinTheme(view), colorAttr);
    }

    public static ColorStateList getSkinColorStateList(@NonNull View view, int colorAttr) {
        return QMUIResHelper.getAttrColorStateList(view.getContext(), QMUISkinHelper.getSkinTheme(view), colorAttr);
    }

    @Nullable
    public static Drawable getSkinDrawable(@NonNull View view, int drawableAttr) {
        return QMUIResHelper.getAttrDrawable(view.getContext(), QMUISkinHelper.getSkinTheme(view), drawableAttr);
    }

    public static void setSkinValue(@NonNull View view, QMUISkinValueBuilder skinValueBuilder) {
        QMUISkinHelper.setSkinValue(view, skinValueBuilder.build());
    }

    public static void setSkinValue(@NonNull View view, String value) {
        view.setTag(R.id.qmui_skin_value, (Object)value);
        QMUISkinHelper.refreshViewSkin(view);
    }

    @MainThread
    public static void setSkinValue(@NonNull View view, SkinWriter writer) {
        writer.write(sSkinValueBuilder);
        QMUISkinHelper.setSkinValue(view, sSkinValueBuilder.build());
        sSkinValueBuilder.clear();
    }

    public static void refreshRVItemDecoration(@NonNull RecyclerView view, IQMUISkinHandlerDecoration itemDecoration) {
        QMUISkinManager.ViewSkinCurrent skinCurrent = QMUISkinManager.getViewSkinCurrent((View)view);
        if (skinCurrent != null) {
            QMUISkinManager.of(skinCurrent.managerName, view.getContext()).refreshRecyclerDecoration(view, itemDecoration, skinCurrent.index);
        }
    }

    public static int getCurrentSkinIndex(@NonNull View view) {
        QMUISkinManager.ViewSkinCurrent viewSkinCurrent = QMUISkinManager.getViewSkinCurrent(view);
        if (viewSkinCurrent != null) {
            return viewSkinCurrent.index;
        }
        return -1;
    }

    public static void refreshViewSkin(@NonNull View view) {
        QMUISkinManager.ViewSkinCurrent skinCurrent = QMUISkinManager.getViewSkinCurrent(view);
        if (skinCurrent != null) {
            QMUISkinManager.of(skinCurrent.managerName, view.getContext()).refreshTheme(view, skinCurrent.index);
        }
    }

    public static void syncViewSkin(@NonNull View view, @NonNull View sourceView) {
        QMUISkinManager.ViewSkinCurrent skin;
        QMUISkinManager.ViewSkinCurrent source = QMUISkinManager.getViewSkinCurrent(sourceView);
        if (source != null && !source.equals(skin = QMUISkinManager.getViewSkinCurrent(view))) {
            QMUISkinManager.of(source.managerName, view.getContext()).dispatch(view, source.index);
        }
    }

    public static void setSkinDefaultProvider(@NonNull View view, IQMUISkinDefaultAttrProvider provider) {
        view.setTag(R.id.qmui_skin_default_attr_provider, (Object)provider);
    }

    public static void setSkinApplyListener(@NonNull View view, @Nullable IQMUISkinApplyListener listener) {
        view.setTag(R.id.qmui_skin_apply_listener, (Object)listener);
    }

    @Nullable
    public static IQMUISkinApplyListener getSkinApplyListener(@NonNull View view) {
        Object listener = view.getTag(R.id.qmui_skin_apply_listener);
        if (listener instanceof IQMUISkinApplyListener) {
            return (IQMUISkinApplyListener)listener;
        }
        return null;
    }

    public static void setIgnoreSkinApply(@NonNull View view, boolean ignore) {
        view.setTag(R.id.qmui_skin_ignore_apply, (Object)ignore);
    }

    public static void setInterceptSkinDispatch(@NonNull View view, boolean intercept) {
        view.setTag(R.id.qmui_skin_intercept_dispatch, (Object)intercept);
    }

    public static void warnRuleNotSupport(View view, String rule) {
        QMUILog.w("QMUISkinManager", view.getClass().getSimpleName() + " does't support " + rule, new Object[0]);
    }
}

