/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.nestedScroll;

import android.content.Context;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.NestedScrollingChild2;
import androidx.core.view.NestedScrollingChildHelper;
import androidx.core.view.NestedScrollingParent2;
import androidx.core.view.NestedScrollingParentHelper;
import androidx.core.view.ViewCompat;
import com.qmuiteam.qmui.nestedScroll.IQMUIContinuousNestedScrollCommon;
import com.qmuiteam.qmui.nestedScroll.IQMUIContinuousNestedTopView;
import com.qmuiteam.qmui.util.QMUILangHelper;
import com.qmuiteam.qmui.util.QMUIViewOffsetHelper;

public class QMUIContinuousNestedTopDelegateLayout
extends FrameLayout
implements NestedScrollingChild2,
NestedScrollingParent2,
IQMUIContinuousNestedTopView {
    public static final String KEY_SCROLL_INFO_OFFSET = "@qmui_scroll_info_top_dl_offset";
    private IQMUIContinuousNestedScrollCommon.OnScrollNotifier mScrollNotifier;
    private View mHeaderView;
    private IQMUIContinuousNestedTopView mDelegateView;
    private View mFooterView;
    private QMUIViewOffsetHelper mHeaderViewOffsetHelper;
    private QMUIViewOffsetHelper mDelegateViewOffsetHelper;
    private QMUIViewOffsetHelper mFooterViewOffsetHelper;
    private int mOffsetCurrent = 0;
    private int mOffsetRange = 0;
    private final NestedScrollingParentHelper mParentHelper;
    private final NestedScrollingChildHelper mChildHelper;
    private Runnable mCheckLayoutAction = new Runnable(){

        @Override
        public void run() {
            QMUIContinuousNestedTopDelegateLayout.this.checkLayout();
        }
    };

    public QMUIContinuousNestedTopDelegateLayout(@NonNull Context context) {
        this(context, null);
    }

    public QMUIContinuousNestedTopDelegateLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public QMUIContinuousNestedTopDelegateLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
        this.mChildHelper = new NestedScrollingChildHelper((View)this);
        ViewCompat.setNestedScrollingEnabled((View)this, (boolean)true);
        this.setClipToPadding(false);
    }

    public void setHeaderView(@NonNull View headerView) {
        this.mHeaderView = headerView;
        this.mHeaderViewOffsetHelper = new QMUIViewOffsetHelper(headerView);
        this.addView(headerView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
    }

    public void setDelegateView(@NonNull IQMUIContinuousNestedTopView delegateView) {
        if (!(delegateView instanceof View)) {
            throw new IllegalArgumentException("delegateView must be a instance of View");
        }
        if (this.mDelegateView != null) {
            this.mDelegateView.injectScrollNotifier(null);
        }
        this.mDelegateView = delegateView;
        View view = (View)delegateView;
        this.mDelegateViewOffsetHelper = new QMUIViewOffsetHelper(view);
        this.addView(view, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
    }

    public void setFooterView(@NonNull View footerView) {
        this.mFooterView = footerView;
        this.mFooterViewOffsetHelper = new QMUIViewOffsetHelper(footerView);
        this.addView(footerView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int w = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int h = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int anchorHeight = this.getPaddingTop();
        if (this.mHeaderView != null) {
            this.mHeaderView.measure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)h, (int)0));
            anchorHeight += this.mHeaderView.getMeasuredHeight();
        }
        if (this.mDelegateView != null) {
            View delegateView = (View)this.mDelegateView;
            delegateView.measure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)h, (int)Integer.MIN_VALUE));
            anchorHeight += delegateView.getMeasuredHeight();
        }
        if (this.mFooterView != null) {
            this.mFooterView.measure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)h, (int)0));
            anchorHeight += this.mFooterView.getMeasuredHeight();
        }
        if ((anchorHeight += this.getPaddingBottom()) < h) {
            this.setMeasuredDimension(w, anchorHeight);
        } else {
            this.setMeasuredDimension(w, h);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int viewHeight;
        int w = right - left;
        int h = bottom - top;
        int anchorTop = this.getPaddingTop();
        if (this.mHeaderView != null) {
            viewHeight = this.mHeaderView.getMeasuredHeight();
            this.mHeaderView.layout(0, anchorTop, w, anchorTop + viewHeight);
            anchorTop += viewHeight;
        }
        if (this.mDelegateView != null) {
            View view = (View)this.mDelegateView;
            viewHeight = view.getMeasuredHeight();
            view.layout(0, anchorTop, w, anchorTop + viewHeight);
            anchorTop += viewHeight;
        }
        if (this.mFooterView != null) {
            viewHeight = this.mFooterView.getMeasuredHeight();
            this.mFooterView.layout(0, anchorTop, w, anchorTop + viewHeight);
            anchorTop += viewHeight;
        }
        this.mOffsetRange = Math.max(0, (anchorTop += this.getPaddingBottom()) - h);
        if (this.mHeaderViewOffsetHelper != null) {
            this.mHeaderViewOffsetHelper.onViewLayout();
            this.mOffsetCurrent = -this.mHeaderViewOffsetHelper.getTopAndBottomOffset();
        }
        if (this.mDelegateViewOffsetHelper != null) {
            this.mDelegateViewOffsetHelper.onViewLayout();
            this.mOffsetCurrent = -this.mDelegateViewOffsetHelper.getTopAndBottomOffset();
        }
        if (this.mFooterViewOffsetHelper != null) {
            this.mFooterViewOffsetHelper.onViewLayout();
            this.mOffsetCurrent = -this.mFooterViewOffsetHelper.getTopAndBottomOffset();
        }
        if (this.mOffsetCurrent > this.mOffsetRange) {
            this.offsetTo(this.mOffsetRange);
        }
        this.postCheckLayout();
    }

    public void postCheckLayout() {
        this.removeCallbacks(this.mCheckLayoutAction);
        this.post(this.mCheckLayoutAction);
    }

    public void checkLayout() {
        int over;
        if (this.mHeaderView == null && this.mFooterView == null) {
            return;
        }
        if (this.mDelegateView == null) {
            return;
        }
        int headerOffsetRange = this.getContainerHeaderOffsetRange();
        int delegateCurrentScroll = this.mDelegateView.getCurrentScroll();
        int delegateScrollRange = this.mDelegateView.getScrollOffsetRange();
        if (delegateCurrentScroll > 0 && this.mHeaderView != null && this.mOffsetCurrent < headerOffsetRange) {
            over = headerOffsetRange - this.mOffsetCurrent;
            if (over >= delegateCurrentScroll) {
                this.mDelegateView.consumeScroll(Integer.MIN_VALUE);
                this.offsetTo(this.mOffsetCurrent + delegateCurrentScroll);
            } else {
                this.mDelegateView.consumeScroll(-over);
                this.offsetTo(headerOffsetRange);
            }
        }
        if (this.mOffsetCurrent > headerOffsetRange && delegateCurrentScroll < delegateScrollRange && this.mFooterView != null) {
            over = this.mOffsetCurrent - headerOffsetRange;
            int delegateRemain = delegateScrollRange - delegateCurrentScroll;
            if (over >= delegateRemain) {
                this.mDelegateView.consumeScroll(Integer.MAX_VALUE);
                this.offsetTo(headerOffsetRange + over - delegateRemain);
            } else {
                this.mDelegateView.consumeScroll(over);
                this.offsetTo(headerOffsetRange);
            }
        }
    }

    private void offsetTo(int targetOffsetCurrent) {
        this.mOffsetCurrent = targetOffsetCurrent;
        if (this.mHeaderViewOffsetHelper != null) {
            this.mHeaderViewOffsetHelper.setTopAndBottomOffset(-targetOffsetCurrent);
        }
        if (this.mDelegateViewOffsetHelper != null) {
            this.mDelegateViewOffsetHelper.setTopAndBottomOffset(-targetOffsetCurrent);
        }
        if (this.mFooterViewOffsetHelper != null) {
            this.mFooterViewOffsetHelper.setTopAndBottomOffset(-targetOffsetCurrent);
        }
        if (this.mScrollNotifier != null) {
            this.mScrollNotifier.notify(this.getCurrentScroll(), this.getScrollOffsetRange());
        }
    }

    public IQMUIContinuousNestedTopView getDelegateView() {
        return this.mDelegateView;
    }

    public View getHeaderView() {
        return this.mHeaderView;
    }

    public View getFooterView() {
        return this.mFooterView;
    }

    public int getContainerOffsetCurrent() {
        return this.mOffsetCurrent;
    }

    public int getContainerOffsetRange() {
        return this.mOffsetRange;
    }

    public int getContainerHeaderOffsetRange() {
        if (this.mOffsetRange == 0 || this.mHeaderView == null) {
            return 0;
        }
        int maxHeight = this.getPaddingTop() + this.mHeaderView.getHeight();
        return Math.min(maxHeight, this.mOffsetRange);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int consumeScroll(int dyUnconsumed) {
        if (this.mOffsetRange <= 0) {
            if (this.mDelegateView == null) return dyUnconsumed;
            return this.mDelegateView.consumeScroll(dyUnconsumed);
        }
        if (dyUnconsumed > 0) {
            if (this.mDelegateView == null) {
                if (dyUnconsumed == Integer.MAX_VALUE) {
                    this.offsetTo(this.mOffsetRange);
                    return dyUnconsumed;
                }
                if (this.mOffsetCurrent + dyUnconsumed <= this.mOffsetRange) {
                    this.offsetTo(this.mOffsetCurrent + dyUnconsumed);
                    return 0;
                }
                if (this.mOffsetCurrent >= this.mOffsetRange) return dyUnconsumed;
                dyUnconsumed -= this.mOffsetRange - this.mOffsetCurrent;
                this.offsetTo(this.mOffsetRange);
                return dyUnconsumed;
            }
            int beforeRange = Math.min(this.mOffsetRange, this.getPaddingTop() + (this.mHeaderView == null ? 0 : this.mHeaderView.getHeight()));
            if (dyUnconsumed == Integer.MAX_VALUE) {
                this.offsetTo(beforeRange);
            } else {
                if (this.mOffsetCurrent + dyUnconsumed <= beforeRange) {
                    this.offsetTo(this.mOffsetCurrent + dyUnconsumed);
                    return 0;
                }
                if (this.mOffsetCurrent < beforeRange) {
                    dyUnconsumed -= beforeRange - this.mOffsetCurrent;
                    this.offsetTo(beforeRange);
                }
            }
            dyUnconsumed = this.mDelegateView.consumeScroll(dyUnconsumed);
            if (dyUnconsumed <= 0) {
                return dyUnconsumed;
            }
            if (dyUnconsumed == Integer.MAX_VALUE) {
                this.offsetTo(this.mOffsetRange);
                return dyUnconsumed;
            }
            if (this.mOffsetCurrent + dyUnconsumed <= this.mOffsetRange) {
                this.offsetTo(this.mOffsetCurrent + dyUnconsumed);
                return 0;
            }
            this.offsetTo(this.mOffsetRange);
            return dyUnconsumed -= this.mOffsetRange - this.mOffsetCurrent;
        }
        if (dyUnconsumed >= 0) return dyUnconsumed;
        if (this.mDelegateView == null) {
            if (dyUnconsumed == Integer.MIN_VALUE) {
                this.offsetTo(0);
                return dyUnconsumed;
            }
            if (this.mOffsetCurrent + dyUnconsumed >= 0) {
                this.offsetTo(this.mOffsetCurrent + dyUnconsumed);
                return 0;
            }
            if (this.mOffsetCurrent <= 0) return dyUnconsumed;
            dyUnconsumed += this.mOffsetCurrent;
            this.offsetTo(0);
            return dyUnconsumed;
        }
        int afterRange = Math.max(0, this.mOffsetRange - this.getPaddingBottom() - (this.mFooterView == null ? 0 : this.mFooterView.getHeight()));
        if (dyUnconsumed == Integer.MIN_VALUE) {
            this.offsetTo(afterRange);
        } else {
            if (this.mOffsetCurrent + dyUnconsumed > afterRange) {
                this.offsetTo(this.mOffsetCurrent + dyUnconsumed);
                return 0;
            }
            if (this.mOffsetCurrent > afterRange) {
                dyUnconsumed += this.mOffsetCurrent - afterRange;
                this.offsetTo(afterRange);
            }
        }
        dyUnconsumed = this.mDelegateView.consumeScroll(dyUnconsumed);
        if (dyUnconsumed >= 0) {
            return dyUnconsumed;
        }
        if (dyUnconsumed == Integer.MIN_VALUE) {
            this.offsetTo(0);
            return dyUnconsumed;
        }
        if (this.mOffsetCurrent + dyUnconsumed > 0) {
            this.offsetTo(this.mOffsetCurrent + dyUnconsumed);
            return 0;
        }
        if (this.mOffsetCurrent <= 0) return dyUnconsumed;
        dyUnconsumed += this.mOffsetCurrent;
        this.offsetTo(0);
        return dyUnconsumed;
    }

    @Override
    public int getCurrentScroll() {
        int currentOffset = this.mOffsetCurrent;
        if (this.mDelegateView != null) {
            currentOffset += this.mDelegateView.getCurrentScroll();
        }
        return currentOffset;
    }

    @Override
    public int getScrollOffsetRange() {
        int scrollRange = this.mOffsetRange;
        if (this.mDelegateView != null) {
            scrollRange += this.mDelegateView.getScrollOffsetRange();
        }
        return scrollRange;
    }

    @Override
    public void injectScrollNotifier(final IQMUIContinuousNestedScrollCommon.OnScrollNotifier notifier) {
        this.mScrollNotifier = notifier;
        if (this.mDelegateView != null) {
            this.mDelegateView.injectScrollNotifier(new IQMUIContinuousNestedScrollCommon.OnScrollNotifier(){

                @Override
                public void notify(int innerOffset, int innerRange) {
                    notifier.notify(QMUIContinuousNestedTopDelegateLayout.this.getCurrentScroll(), QMUIContinuousNestedTopDelegateLayout.this.getScrollOffsetRange());
                }

                @Override
                public void onScrollStateChange(View view, int newScrollState) {
                }
            });
        }
    }

    @Override
    public void saveScrollInfo(@NonNull Bundle bundle) {
        bundle.putInt(KEY_SCROLL_INFO_OFFSET, -this.mOffsetCurrent);
        if (this.mDelegateView != null) {
            this.mDelegateView.saveScrollInfo(bundle);
        }
    }

    @Override
    public void restoreScrollInfo(@NonNull Bundle bundle) {
        int offset = bundle.getInt(KEY_SCROLL_INFO_OFFSET, 0);
        this.offsetTo(QMUILangHelper.constrain(-offset, 0, this.getContainerOffsetRange()));
        if (this.mDelegateView != null) {
            this.mDelegateView.restoreScrollInfo(bundle);
        }
    }

    public boolean startNestedScroll(int axes, int type) {
        return this.mChildHelper.startNestedScroll(axes, type);
    }

    public void stopNestedScroll(int type) {
        this.mChildHelper.stopNestedScroll(type);
    }

    public boolean hasNestedScrollingParent(int type) {
        return this.mChildHelper.hasNestedScrollingParent(type);
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int[] offsetInWindow, int type) {
        return this.mChildHelper.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow, type);
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, int[] consumed, int[] offsetInWindow, int type) {
        return this.mChildHelper.dispatchNestedPreScroll(dx, dy, consumed, offsetInWindow, type);
    }

    public void setNestedScrollingEnabled(boolean enabled) {
        this.mChildHelper.setNestedScrollingEnabled(enabled);
    }

    public boolean isNestedScrollingEnabled() {
        return this.mChildHelper.isNestedScrollingEnabled();
    }

    public boolean startNestedScroll(int axes) {
        return this.startNestedScroll(axes, 0);
    }

    public void stopNestedScroll() {
        this.stopNestedScroll(0);
    }

    public boolean hasNestedScrollingParent() {
        return this.hasNestedScrollingParent(0);
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int[] offsetInWindow) {
        return this.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow, 0);
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, int[] consumed, int[] offsetInWindow) {
        return this.dispatchNestedPreScroll(dx, dy, consumed, offsetInWindow, 0);
    }

    public boolean dispatchNestedFling(float velocityX, float velocityY, boolean consumed) {
        return this.mChildHelper.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public boolean dispatchNestedPreFling(float velocityX, float velocityY) {
        return this.mChildHelper.dispatchNestedPreFling(velocityX, velocityY);
    }

    public boolean onStartNestedScroll(@NonNull View child, @NonNull View target, int axes, int type) {
        return (axes & 2) != 0;
    }

    public void onNestedScrollAccepted(@NonNull View child, @NonNull View target, int axes, int type) {
        this.mParentHelper.onNestedScrollAccepted(child, target, axes, type);
        this.startNestedScroll(2, type);
    }

    public void onStopNestedScroll(@NonNull View target, int type) {
        this.mParentHelper.onStopNestedScroll(target, type);
        this.stopNestedScroll(type);
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int type) {
        int consumed = 0;
        if (dyUnconsumed > 0) {
            if (this.mOffsetCurrent + dyUnconsumed <= this.mOffsetRange) {
                consumed = dyUnconsumed;
                this.offsetTo(this.mOffsetCurrent + dyUnconsumed);
            } else if (this.mOffsetCurrent <= this.mOffsetRange) {
                consumed = this.mOffsetRange - this.mOffsetCurrent;
                this.offsetTo(this.mOffsetRange);
            }
        } else if (dyUnconsumed < 0) {
            if (this.mOffsetCurrent + dyUnconsumed >= 0) {
                consumed = dyUnconsumed;
                this.offsetTo(this.mOffsetCurrent + dyUnconsumed);
            } else if (this.mOffsetCurrent >= 0) {
                consumed = -this.mOffsetCurrent;
                this.offsetTo(0);
            }
        }
        this.dispatchNestedScroll(0, dyConsumed + consumed, 0, dyUnconsumed - consumed, null, type);
    }

    public void onNestedPreScroll(@NonNull View target, int dx, int dy, @NonNull int[] consumed, int type) {
        int bottomMargin;
        this.dispatchNestedPreScroll(dx, dy, consumed, null, type);
        int unconsumed = dy - consumed[1];
        if (unconsumed > 0) {
            int topMargin = Math.min(this.mOffsetRange, this.getPaddingTop() + (this.mHeaderView == null ? 0 : this.mHeaderView.getHeight()));
            if (this.mOffsetCurrent + unconsumed <= topMargin) {
                this.offsetTo(this.mOffsetCurrent + unconsumed);
                consumed[1] = consumed[1] + unconsumed;
            } else if (this.mOffsetCurrent < topMargin) {
                consumed[1] = consumed[1] + (topMargin - this.mOffsetCurrent);
                this.offsetTo(topMargin);
            }
        } else if (unconsumed < 0 && this.mOffsetRange > (bottomMargin = this.getPaddingBottom() + (this.mFooterView != null ? this.mFooterView.getHeight() : 0))) {
            int b = this.mOffsetRange - bottomMargin;
            if (this.mOffsetCurrent + unconsumed >= b) {
                this.offsetTo(this.mOffsetCurrent + unconsumed);
                consumed[1] = consumed[1] + unconsumed;
            } else if (this.mOffsetCurrent > b) {
                consumed[1] = consumed[1] + (b - this.mOffsetCurrent);
                this.offsetTo(b);
            }
        }
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        return this.onStartNestedScroll(child, target, nestedScrollAxes, 0);
    }

    public void onNestedScrollAccepted(View child, View target, int nestedScrollAxes) {
        this.onNestedScrollAccepted(child, target, nestedScrollAxes, 0);
    }

    public void onStopNestedScroll(View target) {
        this.onStopNestedScroll(target, 0);
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        this.onNestedScroll(target, dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, 0);
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        this.onNestedPreScroll(target, dx, dy, consumed, 0);
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        return false;
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        return this.dispatchNestedPreFling(velocityX, velocityY);
    }

    public int getNestedScrollAxes() {
        return this.mParentHelper.getNestedScrollAxes();
    }
}

