/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.nestedScroll;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.animation.Interpolator;
import android.webkit.WebView;
import android.widget.OverScroller;
import androidx.annotation.NonNull;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.view.ViewCompat;
import com.qmuiteam.qmui.QMUIInterpolatorStaticHolder;
import com.qmuiteam.qmui.nestedScroll.IQMUIContinuousNestedBottomView;
import com.qmuiteam.qmui.nestedScroll.IQMUIContinuousNestedTopView;
import com.qmuiteam.qmui.nestedScroll.QMUIContinuousNestedScrollLayout;
import com.qmuiteam.qmui.nestedScroll.QMUIContinuousNestedTopDelegateLayout;
import com.qmuiteam.qmui.nestedScroll.QMUIViewOffsetBehavior;

public class QMUIContinuousNestedTopAreaBehavior
extends QMUIViewOffsetBehavior<View> {
    private static final int INVALID_POINTER = -1;
    private final ViewFlinger mViewFlinger;
    private final int[] mScrollConsumed = new int[2];
    private boolean isBeingDragged;
    private int activePointerId = -1;
    private int lastMotionY;
    private int touchSlop = -1;
    private VelocityTracker velocityTracker;
    private Callback mCallback;
    private boolean isInTouch = false;
    private boolean isInFlingOrScroll = false;
    private boolean replaceCancelActionWithMoveActionForWebView = true;

    public QMUIContinuousNestedTopAreaBehavior(Context context) {
        this(context, null);
    }

    public QMUIContinuousNestedTopAreaBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mViewFlinger = new ViewFlinger(context);
    }

    public void setReplaceCancelActionWithMoveActionForWebView(boolean replaceCancelActionWithMoveActionForWebView) {
        this.replaceCancelActionWithMoveActionForWebView = replaceCancelActionWithMoveActionForWebView;
    }

    public void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    public boolean onInterceptTouchEvent(@NonNull CoordinatorLayout parent, @NonNull View child, @NonNull MotionEvent ev) {
        int action;
        if (this.touchSlop < 0) {
            this.touchSlop = ViewConfiguration.get((Context)parent.getContext()).getScaledTouchSlop();
        }
        if ((action = ev.getAction()) == 2 && this.isBeingDragged) {
            return true;
        }
        switch (ev.getActionMasked()) {
            case 0: {
                this.mViewFlinger.stop();
                this.isInTouch = true;
                this.isBeingDragged = false;
                int x = (int)ev.getX();
                int y = (int)ev.getY();
                if (!parent.isPointInChildBounds(child, x, y)) break;
                this.lastMotionY = y;
                this.activePointerId = ev.getPointerId(0);
                this.ensureVelocityTracker();
                break;
            }
            case 5: {
                int actionIndex = ev.getActionIndex();
                return actionIndex != 0 && !parent.isPointInChildBounds(child, (int)ev.getX(), (int)ev.getY()) && parent.isPointInChildBounds(child, (int)ev.getX(actionIndex), (int)ev.getY(actionIndex));
            }
            case 2: {
                int y;
                int yDiff;
                int pointerIndex;
                int activePointerId = this.activePointerId;
                if (activePointerId == -1 || (pointerIndex = ev.findPointerIndex(activePointerId)) == -1 || (yDiff = Math.abs((y = (int)ev.getY(pointerIndex)) - this.lastMotionY)) <= this.touchSlop) break;
                this.isBeingDragged = true;
                if (child instanceof WebView || child instanceof QMUIContinuousNestedTopDelegateLayout) {
                    MotionEvent cancelEvent = MotionEvent.obtain((MotionEvent)ev);
                    cancelEvent.offsetLocation((float)(-child.getLeft()), (float)(-child.getTop()));
                    if (this.replaceCancelActionWithMoveActionForWebView) {
                        cancelEvent.setAction(2);
                    } else {
                        cancelEvent.setAction(3);
                    }
                    child.dispatchTouchEvent(cancelEvent);
                    cancelEvent.recycle();
                }
                this.lastMotionY = y;
                if (this.mCallback == null) break;
                this.mCallback.onTopBehaviorTouchBegin();
                break;
            }
            case 1: 
            case 3: {
                this.isInTouch = false;
                this.isBeingDragged = false;
                this.activePointerId = -1;
                if (this.velocityTracker == null) break;
                this.velocityTracker.recycle();
                this.velocityTracker = null;
            }
        }
        if (this.velocityTracker != null) {
            this.velocityTracker.addMovement(ev);
        }
        return this.isBeingDragged;
    }

    public boolean onTouchEvent(@NonNull CoordinatorLayout parent, @NonNull View child, @NonNull MotionEvent ev) {
        if (this.touchSlop < 0) {
            this.touchSlop = ViewConfiguration.get((Context)parent.getContext()).getScaledTouchSlop();
        }
        switch (ev.getActionMasked()) {
            case 0: {
                this.mViewFlinger.stop();
                this.isInTouch = true;
                int x = (int)ev.getX();
                int y = (int)ev.getY();
                if (parent.isPointInChildBounds(child, x, y)) {
                    this.lastMotionY = y;
                    this.activePointerId = ev.getPointerId(0);
                    this.ensureVelocityTracker();
                    break;
                }
                return false;
            }
            case 2: {
                int activePointerIndex = ev.findPointerIndex(this.activePointerId);
                if (activePointerIndex == -1) {
                    return false;
                }
                int y = (int)ev.getY(activePointerIndex);
                int dy = this.lastMotionY - y;
                if (!this.isBeingDragged && Math.abs(dy) > this.touchSlop) {
                    this.isBeingDragged = true;
                    if (this.mCallback != null) {
                        this.mCallback.onTopBehaviorTouchBegin();
                    }
                    dy = dy > 0 ? (dy -= this.touchSlop) : (dy += this.touchSlop);
                }
                if (!this.isBeingDragged) break;
                this.lastMotionY = y;
                this.scroll(parent, child, dy);
                break;
            }
            case 1: {
                this.isInTouch = false;
                if (this.mCallback != null) {
                    this.mCallback.onTopBehaviorTouchEnd();
                }
                if (this.velocityTracker != null) {
                    this.velocityTracker.addMovement(ev);
                    this.velocityTracker.computeCurrentVelocity(1000);
                    int yvel = -((int)(this.velocityTracker.getYVelocity(this.activePointerId) + 0.5f));
                    this.mViewFlinger.fling(parent, child, yvel);
                }
            }
            case 3: {
                if (this.isInTouch) {
                    this.isInTouch = false;
                    if (this.mCallback != null) {
                        this.mCallback.onTopBehaviorTouchEnd();
                    }
                }
                this.isBeingDragged = false;
                this.activePointerId = -1;
                if (this.velocityTracker == null) break;
                this.velocityTracker.recycle();
                this.velocityTracker = null;
            }
        }
        if (this.velocityTracker != null) {
            this.velocityTracker.addMovement(ev);
        }
        return true;
    }

    void scroll(@NonNull CoordinatorLayout parent, @NonNull View child, int dy) {
        this.mScrollConsumed[0] = 0;
        this.mScrollConsumed[1] = 0;
        this.onNestedPreScroll(parent, child, child, 0, dy, this.mScrollConsumed, 0);
        int unConsumed = dy - this.mScrollConsumed[1];
        if (child instanceof IQMUIContinuousNestedTopView) {
            unConsumed = ((IQMUIContinuousNestedTopView)child).consumeScroll(unConsumed);
        }
        this.onNestedScroll(parent, child, child, 0, dy - unConsumed, 0, unConsumed, 0);
    }

    void smoothScrollBy(@NonNull CoordinatorLayout parent, @NonNull View child, int dy, int duration) {
        this.mViewFlinger.startScroll(parent, child, dy, duration);
    }

    void stopFlingOrScroll() {
        this.mViewFlinger.stop();
    }

    private void ensureVelocityTracker() {
        if (this.velocityTracker == null) {
            this.velocityTracker = VelocityTracker.obtain();
        }
    }

    public boolean onMeasureChild(@NonNull CoordinatorLayout parent, @NonNull View child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        int childLpHeight = child.getLayoutParams().height;
        int availableHeight = View.MeasureSpec.getSize((int)parentHeightMeasureSpec);
        if (childLpHeight == -1) {
            if (availableHeight == 0) {
                availableHeight = parent.getHeight();
            }
            int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)availableHeight, (int)Integer.MIN_VALUE);
            parent.onMeasureChild(child, parentWidthMeasureSpec, widthUsed, heightMeasureSpec, heightUsed);
        } else {
            parent.onMeasureChild(child, parentWidthMeasureSpec, widthUsed, View.MeasureSpec.makeMeasureSpec((int)0xFFFFFF, (int)Integer.MIN_VALUE), heightUsed);
        }
        return true;
    }

    public void onNestedPreScroll(@NonNull CoordinatorLayout parent, @NonNull View child, @NonNull View target, int dx, int dy, @NonNull int[] consumed, int type) {
        if (target.getParent() != parent) {
            return;
        }
        if (target == child) {
            if (dy < 0) {
                if (child.getTop() <= dy) {
                    this.setTopAndBottomOffset(child.getTop() - dy - this.getLayoutTop());
                    consumed[1] = consumed[1] + dy;
                } else if (child.getTop() < 0) {
                    int top = child.getTop();
                    this.setTopAndBottomOffset(0 - this.getLayoutTop());
                    consumed[1] = consumed[1] + top;
                }
            }
        } else if (dy > 0 && target instanceof IQMUIContinuousNestedBottomView) {
            int contentHeight = ((IQMUIContinuousNestedBottomView)target).getContentHeight();
            int minOffset = contentHeight != -1 ? parent.getHeight() - contentHeight - child.getHeight() : parent.getHeight() - child.getHeight() - target.getHeight();
            if (child.getTop() - dy >= minOffset) {
                this.setTopAndBottomOffset(child.getTop() - dy - this.getLayoutTop());
                consumed[1] = consumed[1] + dy;
            } else if (child.getTop() > minOffset) {
                int distance = child.getTop() - minOffset;
                this.setTopAndBottomOffset(minOffset);
                consumed[1] = consumed[1] + distance;
            }
        }
    }

    public void onNestedScroll(@NonNull CoordinatorLayout parent, @NonNull View child, @NonNull View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int type) {
        if (target.getParent() != parent) {
            return;
        }
        if (target == child) {
            if (dyUnconsumed > 0) {
                View bottomView = this.findBottomView(parent);
                if (bottomView == null || bottomView.getVisibility() == 8) {
                    int parentBottom = parent.getHeight();
                    if (target.getBottom() - parentBottom >= dyUnconsumed) {
                        this.setTopAndBottomOffset(target.getTop() - dyUnconsumed - this.getLayoutTop());
                    } else if (target.getBottom() - parentBottom > 0) {
                        int moveDistance = target.getBottom() - parentBottom;
                        this.setTopAndBottomOffset(target.getTop() - moveDistance - this.getLayoutTop());
                    }
                } else {
                    int contentHeight = ((IQMUIContinuousNestedBottomView)bottomView).getContentHeight();
                    int minBottom = parent.getHeight();
                    boolean canContentScroll = true;
                    if (contentHeight != -1) {
                        minBottom = parent.getHeight() + bottomView.getHeight() - contentHeight;
                        canContentScroll = false;
                    }
                    if (bottomView.getBottom() - minBottom > dyUnconsumed) {
                        this.setTopAndBottomOffset(target.getTop() - dyUnconsumed - this.getLayoutTop());
                        return;
                    }
                    if (bottomView.getBottom() - minBottom > 0) {
                        int moveDistance = bottomView.getBottom() - minBottom;
                        this.setTopAndBottomOffset(target.getTop() - moveDistance - this.getLayoutTop());
                        int n = dyUnconsumed = dyUnconsumed == Integer.MAX_VALUE ? dyUnconsumed : dyUnconsumed - moveDistance;
                    }
                    if (canContentScroll) {
                        ((IQMUIContinuousNestedBottomView)bottomView).consumeScroll(dyUnconsumed);
                    }
                }
            }
        } else if (dyUnconsumed < 0) {
            if (child.getTop() <= dyUnconsumed) {
                this.setTopAndBottomOffset(child.getTop() - dyUnconsumed - this.getLayoutTop());
                return;
            }
            if (child.getTop() < 0) {
                int top = child.getTop();
                this.setTopAndBottomOffset(0 - this.getLayoutTop());
                int n = dyUnconsumed = dyUnconsumed == Integer.MIN_VALUE ? dyConsumed : dyUnconsumed - top;
            }
            if (child instanceof IQMUIContinuousNestedTopView) {
                ((IQMUIContinuousNestedTopView)child).consumeScroll(dyUnconsumed);
            }
        }
    }

    public boolean onStartNestedScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull View child, @NonNull View directTargetChild, @NonNull View target, int axes, int type) {
        return (axes & 2) != 0;
    }

    private View findBottomView(CoordinatorLayout parent) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            View child = parent.getChildAt(i);
            if (!(child instanceof IQMUIContinuousNestedBottomView)) continue;
            return child;
        }
        return null;
    }

    @Override
    public boolean setTopAndBottomOffset(int offset) {
        boolean ret = super.setTopAndBottomOffset(offset);
        if (this.mCallback != null) {
            this.mCallback.onTopAreaOffset(offset);
        }
        return ret;
    }

    public static interface Callback {
        public void onTopAreaOffset(int var1);

        public void onTopBehaviorTouchBegin();

        public void onTopBehaviorTouchEnd();

        public void onTopBehaviorFlingOrScrollStart();

        public void onTopBehaviorFlingOrScrollEnd();
    }

    class ViewFlinger
    implements Runnable {
        private int mLastFlingY;
        OverScroller mOverScroller;
        Interpolator mInterpolator = QMUIInterpolatorStaticHolder.QUNITIC_INTERPOLATOR;
        private boolean mEatRunOnAnimationRequest = false;
        private boolean mReSchedulePostAnimationCallback = false;
        private CoordinatorLayout mCurrentParent;
        private View mCurrentChild;

        ViewFlinger(Context context) {
            this.mOverScroller = new OverScroller(context, QMUIInterpolatorStaticHolder.QUNITIC_INTERPOLATOR);
        }

        @Override
        public void run() {
            this.mReSchedulePostAnimationCallback = false;
            this.mEatRunOnAnimationRequest = true;
            OverScroller scroller = this.mOverScroller;
            if (scroller.computeScrollOffset()) {
                int y = scroller.getCurrY();
                int unconsumedY = y - this.mLastFlingY;
                this.mLastFlingY = y;
                if (this.mCurrentParent != null && this.mCurrentChild != null) {
                    boolean canScroll = true;
                    if (this.mCurrentParent instanceof QMUIContinuousNestedScrollLayout) {
                        QMUIContinuousNestedScrollLayout layout2 = (QMUIContinuousNestedScrollLayout)this.mCurrentParent;
                        if (unconsumedY > 0 && layout2.getCurrentScroll() >= layout2.getScrollRange()) {
                            canScroll = false;
                        } else if (unconsumedY < 0 && layout2.getCurrentScroll() <= 0) {
                            canScroll = false;
                        }
                    }
                    if (canScroll) {
                        QMUIContinuousNestedTopAreaBehavior.this.scroll(this.mCurrentParent, this.mCurrentChild, unconsumedY);
                        this.postOnAnimation();
                    } else {
                        this.mOverScroller.abortAnimation();
                    }
                }
            }
            this.mEatRunOnAnimationRequest = false;
            if (this.mReSchedulePostAnimationCallback) {
                this.internalPostOnAnimation();
            } else {
                this.mCurrentParent = null;
                this.mCurrentChild = null;
                this.onFlingOrScrollEnd();
            }
        }

        void postOnAnimation() {
            if (this.mEatRunOnAnimationRequest) {
                this.mReSchedulePostAnimationCallback = true;
            } else {
                this.internalPostOnAnimation();
            }
        }

        private void internalPostOnAnimation() {
            if (this.mCurrentChild != null) {
                this.mCurrentParent.removeCallbacks((Runnable)this);
                ViewCompat.postOnAnimation((View)this.mCurrentChild, (Runnable)this);
            }
        }

        public void fling(CoordinatorLayout parent, View child, int velocityY) {
            this.onFlingOrScrollStart(parent, child);
            this.mOverScroller.fling(0, 0, 0, velocityY, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.postOnAnimation();
        }

        public void startScroll(CoordinatorLayout parent, View child, int dy, int duration) {
            this.onFlingOrScrollStart(parent, child);
            this.mOverScroller.startScroll(0, 0, 0, dy, duration);
            this.postOnAnimation();
        }

        private void onFlingOrScrollStart(CoordinatorLayout parent, View child) {
            QMUIContinuousNestedTopAreaBehavior.this.isInFlingOrScroll = true;
            if (QMUIContinuousNestedTopAreaBehavior.this.mCallback != null) {
                QMUIContinuousNestedTopAreaBehavior.this.mCallback.onTopBehaviorFlingOrScrollStart();
            }
            this.mCurrentParent = parent;
            this.mCurrentChild = child;
            this.mLastFlingY = 0;
            if (this.mInterpolator != QMUIInterpolatorStaticHolder.QUNITIC_INTERPOLATOR) {
                this.mInterpolator = QMUIInterpolatorStaticHolder.QUNITIC_INTERPOLATOR;
                this.mOverScroller = new OverScroller(this.mCurrentParent.getContext(), QMUIInterpolatorStaticHolder.QUNITIC_INTERPOLATOR);
            }
        }

        public void stop() {
            if (this.mCurrentChild != null) {
                this.mCurrentChild.removeCallbacks((Runnable)this);
            }
            this.mOverScroller.abortAnimation();
            this.mCurrentChild = null;
            this.mCurrentParent = null;
            this.onFlingOrScrollEnd();
        }

        private void onFlingOrScrollEnd() {
            if (QMUIContinuousNestedTopAreaBehavior.this.mCallback != null && QMUIContinuousNestedTopAreaBehavior.this.isInFlingOrScroll) {
                QMUIContinuousNestedTopAreaBehavior.this.mCallback.onTopBehaviorFlingOrScrollEnd();
            }
            QMUIContinuousNestedTopAreaBehavior.this.isInFlingOrScroll = false;
        }
    }
}

