package com.qiniu.bigdata;

import com.qiniu.http.AsyncCallback;
import com.qiniu.http.Client;
import com.qiniu.util.StringMap;

import java.util.List;
import java.util.Map;

//import org.json.JSONObject;

/**
 * Created by long on 2017/7/25.
 */

public final class Pipeline {
    private static final String HTTPHeaderAuthorization = "Authorization";
    private static final String TEXT_PLAIN = "text/plain";
    private final Configuration config;
    private final Client client;

    public Pipeline(Configuration config) {
        this.config = Configuration.copy(config);
        this.client = new Client();
    }

    public <V> void pump(String repo, Map<String, V> data, String token, AsyncCallback handler) {
        StringBuilder b = new StringBuilder();
        Points.formatPoint(data, b);
        send(repo, b, token, handler);
    }

    public void pump(String repo, Object data, String token, AsyncCallback handler) {
        StringBuilder b = new StringBuilder();
        Points.formatPoint(data, b);
        send(repo, b, token, handler);
    }

    public <V> void pumpMulti(String repo, Map<String, V>[] data, String token, AsyncCallback handler) {
        StringBuilder b = Points.formatPoints(data);
        send(repo, b, token, handler);
    }

    public void pumpMultiObjects(String repo, Object[] data, String token, AsyncCallback handler) {
        StringBuilder b = Points.formatPoints(data);
        send(repo, b, token, handler);
    }

    public <V> void pumpMultiObjects(String repo, List<V> data, String token, AsyncCallback handler) {
        StringBuilder b = Points.formatPointsObjects(data);
        send(repo, b, token, handler);
    }

    public <V> void pumpMulti(String repo, List<Map<String, V>> data, String token, AsyncCallback handler) {
        StringBuilder b = Points.formatPoints(data);
        send(repo, b, token, handler);
    }

    private void send(String repo, StringBuilder builder, String token, final AsyncCallback handler) {
        if (handler == null) {
            throw new IllegalArgumentException("no CompletionHandler");
        }
//        if (StringUtils.isBlank(token)) {
//            throw new IllegalArgumentException("no token");
//        }
//        if (StringUtils.isBlank(repo)) {
//            throw new IllegalArgumentException("no repo");
//        }
        byte[] data = builder.toString().getBytes();
        StringMap headers = new StringMap();
        headers.put(HTTPHeaderAuthorization, token);
        client.asyncPost(url(repo), data, 0, data.length, headers, "text/plain", handler);
    }

    private String url(String repo) {
        return config.pipelineHost + "/v2/repos/" + repo + "/data";
    }


}
