/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Recorder;
import com.qiniu.storage.ResumeUploadPerformer;
import com.qiniu.storage.ResumeUploadPerformerV1;
import com.qiniu.storage.ResumeUploadPerformerV2;
import com.qiniu.storage.ResumeUploadSource;
import com.qiniu.storage.ResumeUploadSourceFile;
import com.qiniu.storage.ResumeUploadSourceStream;
import com.qiniu.storage.UploadOptions;
import com.qiniu.storage.UploadToken;
import com.qiniu.util.StringMap;
import java.io.File;
import java.io.InputStream;

public class ResumeUploader {
    private final Client client;
    private final String key;
    private final String upToken;
    private final ResumeUploadSource source;
    private final Recorder recorder;
    private final UploadOptions options;
    final Configuration config;
    ResumeUploadPerformer uploadPerformer;

    public ResumeUploader(Client client, String upToken, String key, File file, StringMap params, String mime, Recorder recorder, Configuration configuration) {
        this(client, key, upToken, new ResumeUploadSourceFile(file, configuration, ResumeUploader.getRecorderKey(key, file, recorder), ResumeUploader.getRegionTargetId(upToken, configuration)), recorder, new UploadOptions.Builder().params(params).metaData(params).mimeType(mime).build(), configuration);
    }

    public ResumeUploader(Client client, String upToken, String key, InputStream stream, StringMap params, String mime, Configuration configuration) {
        this(client, upToken, key, stream, null, params, mime, configuration);
    }

    public ResumeUploader(Client client, String upToken, String key, InputStream stream, String fileName, StringMap params, String mime, Configuration configuration) {
        this(client, key, upToken, new ResumeUploadSourceStream(stream, configuration, null, ResumeUploader.getRegionTargetId(upToken, configuration), fileName), null, new UploadOptions.Builder().params(params).metaData(params).mimeType(mime).build(), configuration);
    }

    private ResumeUploader(Client client, String key, String upToken, ResumeUploadSource source, Recorder recorder, UploadOptions options, Configuration configuration) {
        this.client = client;
        this.key = key;
        this.upToken = upToken;
        this.source = source;
        this.recorder = recorder;
        this.options = options == null ? UploadOptions.defaultOptions() : options;
        this.config = configuration;
    }

    public Response upload() throws QiniuException {
        try {
            Response response = this.uploadFlows();
            return response;
        }
        finally {
            this.close();
        }
    }

    private Response uploadFlows() throws QiniuException {
        this.checkParam();
        UploadToken token = new UploadToken(this.upToken);
        this.uploadPerformer = this.config.resumableUploadAPIVersion == Configuration.ResumableUploadAPIVersion.V2 ? new ResumeUploadPerformerV2(this.client, this.key, token, this.source, this.recorder, this.options, this.config) : new ResumeUploadPerformerV1(this.client, this.key, token, this.source, this.recorder, this.options, this.config);
        this.uploadPerformer.recoverUploadProgressFromLocal();
        Response response = null;
        if (this.uploadPerformer.shouldUploadInit() && !(response = this.uploadPerformer.uploadInit()).isOK()) {
            return response;
        }
        if (!this.uploadPerformer.isAllBlocksUploaded() && !(response = this.uploadData()).isOK()) {
            return response;
        }
        response = this.uploadPerformer.completeUpload();
        if (response.isOK()) {
            this.uploadPerformer.removeUploadProgressFromLocal();
        }
        return response;
    }

    Response uploadData() throws QiniuException {
        Response response = null;
        do {
            if ((response = this.uploadPerformer.uploadNextData()) == null || !response.isOK()) continue;
            this.uploadPerformer.saveUploadProgressToLocal();
        } while (!this.uploadPerformer.isAllBlocksUploadingOrUploaded());
        return response;
    }

    private void close() {
        try {
            this.source.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkParam() throws QiniuException {
        if (this.client == null) {
            throw QiniuException.unrecoverable(new Exception("client can't be empty"));
        }
        if (this.config == null) {
            throw QiniuException.unrecoverable(new Exception("Configuration can't be empty"));
        }
        if (this.config.zone == null && this.config.region == null) {
            throw QiniuException.unrecoverable(new Exception("Configuration.region can't be empty"));
        }
        if (!this.source.isValid()) {
            throw QiniuException.unrecoverable(new Exception("InputStream or File is invalid"));
        }
        UploadToken token = new UploadToken(this.upToken);
        if (!token.isValid()) {
            throw QiniuException.unrecoverable(new Exception("token is invalid"));
        }
    }

    private static String getRecorderKey(String key, File file, Recorder recorder) {
        if (recorder == null) {
            return null;
        }
        return recorder.recorderKeyGenerate(key, file);
    }

    private static String getRegionTargetId(String upToken, Configuration config) {
        if (config == null || upToken == null) {
            return null;
        }
        UploadToken token = null;
        try {
            token = new UploadToken(upToken);
        }
        catch (QiniuException qiniuException) {
            // empty catch block
        }
        if (token == null || !token.isValid()) {
            return null;
        }
        return config.region.getRegion(token);
    }
}

