/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.MethodType;
import com.qiniu.storage.ApiUpload;
import com.qiniu.storage.ApiUtils;
import com.qiniu.storage.UploadToken;
import com.qiniu.util.StringUtils;
import java.util.List;

public class ApiUploadV2ListParts
extends ApiUpload {
    public ApiUploadV2ListParts(Client client) {
        super(client);
    }

    public Response request(Request request) throws QiniuException {
        return new Response(this.requestByClient(request));
    }

    public static class Response
    extends ApiUpload.Response {
        protected Response(com.qiniu.http.Response response) throws QiniuException {
            super(response);
        }

        public String getUploadId() {
            return this.getStringValueFromDataMap("uploadId");
        }

        public Long getExpireAt() {
            return this.getLongValueFromDataMap("expireAt");
        }

        public Integer getPartNumberMarker() {
            return this.getIntegerValueFromDataMap("partNumberMarker");
        }

        public List getParts() {
            Object value = this.getValueFromDataMap("parts");
            if (value instanceof List) {
                return (List)value;
            }
            return null;
        }
    }

    public static class Request
    extends ApiUpload.Request {
        private String key;
        private String uploadId;
        private Integer maxParts;
        private Integer partNumberMarker;

        public Request(String urlPrefix, String token, String uploadId) {
            super(urlPrefix);
            this.setToken(token);
            this.setMethod(MethodType.GET);
            this.uploadId = uploadId;
        }

        public Request setKey(String key) {
            this.key = key;
            return this;
        }

        public Request setMaxParts(Integer maxParts) {
            this.maxParts = maxParts;
            return this;
        }

        public Request setPartNumberMarker(Integer partNumberMarker) {
            this.partNumberMarker = partNumberMarker;
            return this;
        }

        @Override
        protected void buildQuery() throws QiniuException {
            if (this.maxParts != null) {
                this.addQueryPair("max-parts", this.maxParts + "");
            }
            if (this.partNumberMarker != null) {
                this.addQueryPair("part-number-marker", this.partNumberMarker + "");
            }
            super.buildQuery();
        }

        @Override
        protected void buildPath() throws QiniuException {
            UploadToken token = this.getUploadToken();
            if (token == null || !token.isValid()) {
                ApiUtils.throwInvalidRequestParamException("token");
            }
            if (StringUtils.isNullOrEmpty(this.uploadId)) {
                ApiUtils.throwInvalidRequestParamException("uploadId");
            }
            String bucket = token.getBucket();
            this.addPathSegment("buckets");
            this.addPathSegment(bucket);
            this.addPathSegment("objects");
            this.addPathSegment(ApiUtils.resumeV2EncodeKey(this.key));
            this.addPathSegment("uploads");
            this.addPathSegment(this.uploadId);
            super.buildPath();
        }
    }
}

