/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.common;

import com.qiniu.common.QiniuException;
import com.qiniu.common.Zone;
import com.qiniu.common.ZoneReqInfo;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Deprecated
public final class AutoZone
extends Zone {
    public static AutoZone instance = new AutoZone();
    public final String ucServer;
    private Map<ZoneIndex, ZoneInfo> zones;
    private Map<String, Zone> inferDomainsMap;
    private Client client;

    public AutoZone() {
        this("https://uc.qbox.me");
    }

    public AutoZone(String ucServer) {
        this.ucServer = ucServer;
        this.client = new Client();
        this.zones = new ConcurrentHashMap<ZoneIndex, ZoneInfo>();
        this.inferDomainsMap = new ConcurrentHashMap<String, Zone>();
        this.inferDomainsMap.put("http://up.qiniu.com", AutoZone.zone0());
        this.inferDomainsMap.put("http://up-z1.qiniu.com", AutoZone.zone1());
        this.inferDomainsMap.put("http://up-z2.qiniu.com", AutoZone.zone2());
        this.inferDomainsMap.put("http://up-na0.qiniu.com", AutoZone.zoneNa0());
        this.inferDomainsMap.put("http://up-as0.qiniu.com", AutoZone.zoneAs0());
    }

    private UCRet getZoneJson(ZoneIndex index) throws QiniuException {
        String address = this.ucServer + "/v1/query?ak=" + index.accessKey + "&bucket=" + index.bucket;
        Response r = this.client.get(address);
        return r.jsonToObject(UCRet.class);
    }

    public ZoneInfo queryZoneInfo(String accessKey, String bucket) throws QiniuException {
        ZoneIndex index = new ZoneIndex(accessKey, bucket);
        ZoneInfo info = this.zones.get(index);
        if (info == null) {
            UCRet ret = this.getZoneJson(index);
            try {
                info = ZoneInfo.buildFromUcRet(ret);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (info != null) {
                this.zones.put(index, info);
            }
        }
        return info;
    }

    public ZoneInfo queryZoneInfo(ZoneReqInfo zoneReqInfo) {
        try {
            return this.queryZoneInfo(zoneReqInfo.getAccessKey(), zoneReqInfo.getBucket());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getUpHttp(ZoneReqInfo zoneReqInfo) {
        ZoneInfo info = this.queryZoneInfo(zoneReqInfo);
        if (info == null) {
            return "";
        }
        return info.upHttp;
    }

    @Override
    public String getUpBackupHttp(ZoneReqInfo zoneReqInfo) {
        ZoneInfo info = this.queryZoneInfo(zoneReqInfo);
        if (info == null) {
            return "";
        }
        return info.upBackupHttp;
    }

    @Override
    public String getUpIpHttp(ZoneReqInfo zoneReqInfo) {
        ZoneInfo info = this.queryZoneInfo(zoneReqInfo);
        if (info == null) {
            return "";
        }
        return info.upIpHttp;
    }

    @Override
    public String getIovipHttp(ZoneReqInfo zoneReqInfo) {
        ZoneInfo info = this.queryZoneInfo(zoneReqInfo);
        if (info == null) {
            return "";
        }
        return info.iovipHttp;
    }

    @Override
    public String getUpHttps(ZoneReqInfo zoneReqInfo) {
        ZoneInfo info = this.queryZoneInfo(zoneReqInfo);
        if (info == null) {
            return "";
        }
        return info.upHttps;
    }

    @Override
    public String getUpBackupHttps(ZoneReqInfo zoneReqInfo) {
        ZoneInfo info = this.queryZoneInfo(zoneReqInfo);
        if (info == null) {
            return "";
        }
        return info.upBackupHttps;
    }

    @Override
    public String getUpIpHttps(ZoneReqInfo zoneReqInfo) {
        ZoneInfo info = this.queryZoneInfo(zoneReqInfo);
        if (info == null) {
            return "";
        }
        return info.upIpHttps;
    }

    @Override
    public String getIovipHttps(ZoneReqInfo zoneReqInfo) {
        ZoneInfo info = this.queryZoneInfo(zoneReqInfo);
        if (info == null) {
            return "";
        }
        return info.iovipHttps;
    }

    @Override
    public String getRsHttp(ZoneReqInfo zoneReqInfo) {
        ZoneInfo info = this.queryZoneInfo(zoneReqInfo);
        if (info == null) {
            return super.getRsHttp();
        }
        Zone zone = this.inferDomainsMap.get(info.upHttp);
        if (zone != null) {
            return zone.getRsHttp();
        }
        return super.getRsHttp();
    }

    @Override
    public String getRsHttps(ZoneReqInfo zoneReqInfo) {
        ZoneInfo info = this.queryZoneInfo(zoneReqInfo);
        if (info == null) {
            return super.getRsHttps();
        }
        Zone zone = this.inferDomainsMap.get(info.upHttp);
        if (zone != null) {
            return zone.getRsHttps();
        }
        return super.getRsHttps();
    }

    @Override
    public String getRsfHttp(ZoneReqInfo zoneReqInfo) {
        ZoneInfo info = this.queryZoneInfo(zoneReqInfo);
        if (info == null) {
            return super.getRsfHttp();
        }
        Zone zone = this.inferDomainsMap.get(info.upHttp);
        if (zone != null) {
            return zone.getRsfHttp();
        }
        return super.getRsfHttp();
    }

    @Override
    public String getRsfHttps(ZoneReqInfo zoneReqInfo) {
        ZoneInfo info = this.queryZoneInfo(zoneReqInfo);
        if (info == null) {
            return super.getRsfHttps();
        }
        Zone zone = this.inferDomainsMap.get(info.upHttp);
        if (zone != null) {
            return zone.getRsfHttps();
        }
        return super.getRsfHttps();
    }

    @Override
    public String getApiHttp(ZoneReqInfo zoneReqInfo) {
        ZoneInfo info = this.queryZoneInfo(zoneReqInfo);
        if (info == null) {
            return super.getApiHttp();
        }
        Zone zone = this.inferDomainsMap.get(info.upHttp);
        if (zone != null) {
            return zone.getApiHttp();
        }
        return super.getApiHttp();
    }

    @Override
    public String getApiHttps(ZoneReqInfo zoneReqInfo) {
        ZoneInfo info = this.queryZoneInfo(zoneReqInfo);
        if (info == null) {
            return super.getApiHttps();
        }
        Zone zone = this.inferDomainsMap.get(info.upHttp);
        if (zone != null) {
            return zone.getApiHttps();
        }
        return super.getApiHttps();
    }

    private static class ZoneIndex {
        private final String accessKey;
        private final String bucket;

        ZoneIndex(String accessKey, String bucket) {
            this.accessKey = accessKey;
            this.bucket = bucket;
        }

        public int hashCode() {
            return this.accessKey.hashCode() * 37 + this.bucket.hashCode();
        }

        public boolean equals(Object obj) {
            return obj == this || obj != null && obj instanceof ZoneIndex && ((ZoneIndex)obj).accessKey.equals(this.accessKey) && ((ZoneIndex)obj).bucket.equals(this.bucket);
        }
    }

    private class UCRet {
        Map<String, List<String>> http;
        Map<String, List<String>> https;

        private UCRet() {
        }
    }

    static class ZoneInfo {
        final String upHttp;
        final String upBackupHttp;
        final String upIpHttp;
        final String iovipHttp;
        final String upHttps;
        final String upBackupHttps;
        final String upIpHttps;
        final String iovipHttps;

        private ZoneInfo(String upHttp, String upBackupHttp, String upIpHttp, String iovipHttp, String upHttps, String upBackupHttps, String upIpHttps, String iovipHttps) {
            this.upHttp = upHttp;
            this.upBackupHttp = upBackupHttp;
            this.upIpHttp = upIpHttp;
            this.iovipHttp = iovipHttp;
            this.upHttps = upHttps;
            this.upBackupHttps = upBackupHttps;
            this.upIpHttps = upIpHttps;
            this.iovipHttps = iovipHttps;
        }

        static ZoneInfo buildFromUcRet(UCRet ret) {
            String upHttps;
            List<String> upsHttp = ret.http.get("up");
            String upHttp = upsHttp.get(0);
            String upBackupHttp = upsHttp.get(1);
            String upIpHttp = upsHttp.get(2).split(" ")[2].split("//")[1];
            String ioHttp = ret.http.get("io").get(0);
            List<String> upsHttps = ret.https.get("up");
            String upBackupHttps = upHttps = upsHttps.get(0);
            String upIpHttps = "";
            if (upsHttps.size() > 1) {
                upBackupHttps = upsHttps.get(1);
            }
            if (upsHttps.size() > 2) {
                upIpHttps = upsHttps.get(2).split(" ")[2].split("//")[1];
            }
            String ioHttps = ret.https.get("io").get(0);
            return new ZoneInfo(upHttp, upBackupHttp, upIpHttp, ioHttp, upHttps, upBackupHttps, upIpHttps, ioHttps);
        }
    }
}

