/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.storage.Configuration;
import com.qiniu.storage.ResumeUploadSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;

public class ResumeUploadSourceStream
extends ResumeUploadSource {
    private long readOffset = 0L;
    private boolean isAllDataRead;
    private final InputStream inputStream;
    private final String fileName;

    ResumeUploadSourceStream(InputStream inputStream, Configuration config, String recordKey, String fileName) {
        super(config, recordKey);
        this.inputStream = inputStream;
        this.fileName = fileName;
        this.blockList = new LinkedList();
    }

    @Override
    boolean isAllBlocksUploadingOrUploaded() {
        if (!this.isAllDataRead) {
            return false;
        }
        return super.isAllBlocksUploadingOrUploaded();
    }

    @Override
    boolean isAllBlocksUploaded() {
        if (!this.isAllDataRead) {
            return false;
        }
        return super.isAllBlocksUploaded();
    }

    @Override
    ResumeUploadSource.Block getNextUploadingBlock() throws IOException {
        ResumeUploadSource.Block block = super.getNextUploadingBlock();
        if (block != null) {
            return block;
        }
        block = new ResumeUploadSource.Block(this.config, this.readOffset, this.getBlockSize(this.config), this.blockList.size());
        block.data = this.getBlockData(block);
        if (block.size == 0) {
            return null;
        }
        this.blockList.add(block);
        return block;
    }

    @Override
    void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
    }

    @Override
    boolean isValid() {
        return this.inputStream != null;
    }

    @Override
    long getSize() {
        return this.readOffset;
    }

    @Override
    String getFileName() {
        return this.fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getBlockData(ResumeUploadSource.Block block) throws IOException {
        if (block.data != null) {
            return block.data;
        }
        byte[] buffer = null;
        ResumeUploadSourceStream resumeUploadSourceStream = this;
        synchronized (resumeUploadSourceStream) {
            block7: {
                while (true) {
                    if (this.readOffset == block.offset) {
                        int readSize;
                        int ret;
                        buffer = new byte[block.size];
                        for (readSize = 0; readSize < block.size; readSize += ret) {
                            ret = this.inputStream.read(buffer, readSize, block.size - readSize);
                            if (ret >= 0) continue;
                            this.isAllDataRead = true;
                            break;
                        }
                        block.data = buffer;
                        block.size = readSize;
                        this.readOffset += (long)readSize;
                        break block7;
                    }
                    if (this.readOffset >= block.offset) break;
                    this.readOffset += this.inputStream.skip(block.offset - this.readOffset);
                }
                throw new IOException("read block data error");
            }
        }
        return buffer;
    }
}

