/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.common;

import com.qiniu.http.Error;
import com.qiniu.http.Response;
import java.io.IOException;

public final class QiniuException
extends IOException {
    public final Response response;
    private String error;
    private boolean isUnrecoverable = false;

    public QiniuException(Response response) {
        super(response != null ? response.getInfo() : null);
        this.response = response;
        if (response != null) {
            response.close();
        }
    }

    public static QiniuException unrecoverable(Exception e) {
        QiniuException exception = new QiniuException(e);
        exception.isUnrecoverable = true;
        return exception;
    }

    public static QiniuException unrecoverable(String msg) {
        QiniuException exception = new QiniuException(null, msg);
        exception.isUnrecoverable = true;
        return exception;
    }

    public QiniuException(Exception e) {
        this(e, null);
    }

    public QiniuException(Exception e, String msg) {
        super(msg != null ? msg : (e != null ? e.getMessage() : null), e);
        this.response = null;
        this.error = msg;
    }

    public String url() {
        return this.response != null ? this.response.url() : "";
    }

    public int code() {
        return this.response != null ? this.response.statusCode : -1;
    }

    public boolean isUnrecoverable() {
        return this.isUnrecoverable;
    }

    public String error() {
        if (this.error != null) {
            return this.error;
        }
        if (this.response == null || this.response.statusCode / 100 == 2 || !this.response.isJson()) {
            return null;
        }
        Error e = null;
        try {
            e = this.response.jsonToObject(Error.class);
        }
        catch (QiniuException e1) {
            e1.printStackTrace();
        }
        this.error = e == null ? "" : e.error;
        return this.error;
    }
}

