/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.utils;

import java.util.Arrays;
import org.apache.flink.api.java.utils.Option;
import org.apache.flink.api.java.utils.OptionType;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.api.java.utils.RequiredParameters;
import org.apache.flink.api.java.utils.RequiredParametersException;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

@Deprecated
public class RequiredParametersTest
extends TestLogger {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testAddWithAlreadyExistingParameter() throws RequiredParametersException {
        this.expectedException.expect(RequiredParametersException.class);
        this.expectedException.expectMessage("Option with key berlin already exists.");
        RequiredParameters required = new RequiredParameters();
        required.add(new Option("berlin"));
        required.add(new Option("berlin"));
    }

    @Test
    public void testStringBasedAddWithAlreadyExistingParameter() throws RequiredParametersException {
        this.expectedException.expect(RequiredParametersException.class);
        this.expectedException.expectMessage("Option with key berlin already exists.");
        RequiredParameters required = new RequiredParameters();
        required.add("berlin");
        required.add("berlin");
    }

    @Test
    public void testApplyToWithMissingParameters() throws RequiredParametersException {
        this.expectedException.expect(RequiredParametersException.class);
        this.expectedException.expectMessage(CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Missing arguments for:"), (Matcher)CoreMatchers.containsString((String)"munich ")));
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[0]);
        RequiredParameters required = new RequiredParameters();
        required.add(new Option("munich"));
        required.applyTo(parameter);
    }

    @Test
    public void testApplyToWithMissingDefaultValues() throws RequiredParametersException {
        this.expectedException.expect(RequiredParametersException.class);
        this.expectedException.expectMessage("No default value for undefined parameter berlin");
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"--berlin"});
        RequiredParameters required = new RequiredParameters();
        required.add(new Option("berlin"));
        required.applyTo(parameter);
    }

    @Test
    public void testApplyToWithInvalidParameterValueBasedOnOptionChoices() throws RequiredParametersException {
        this.expectedException.expect(RequiredParametersException.class);
        this.expectedException.expectMessage("Value river is not in the list of valid choices for key berlin");
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"--berlin", "river"});
        RequiredParameters required = new RequiredParameters();
        required.add(new Option("berlin").choices(new String[]{"city", "metropolis"}));
        required.applyTo(parameter);
    }

    @Test
    public void testApplyToWithParameterDefinedOnShortAndLongName() throws RequiredParametersException {
        this.expectedException.expect(RequiredParametersException.class);
        this.expectedException.expectMessage("Value passed for parameter berlin is ambiguous. Value passed for short and long name.");
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"--berlin", "value", "--b", "another"});
        RequiredParameters required = new RequiredParameters();
        required.add(new Option("berlin").alt("b"));
        required.applyTo(parameter);
    }

    @Test
    public void testApplyToMovesValuePassedOnShortNameToLongNameIfLongNameIsUndefined() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"--b", "value"});
        RequiredParameters required = new RequiredParameters();
        try {
            required.add(new Option("berlin").alt("b"));
            parameter = required.applyTo(parameter);
            Assert.assertEquals(parameter.data.get("berlin"), (Object)"value");
            Assert.assertEquals(parameter.data.get("b"), (Object)"value");
        }
        catch (RequiredParametersException e) {
            Assert.fail((String)("Exception thrown " + e.getMessage()));
        }
    }

    @Test
    public void testDefaultValueDoesNotOverrideValuePassedOnShortKeyIfLongKeyIsNotPassedButPresent() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"--berlin", "--b", "value"});
        RequiredParameters required = new RequiredParameters();
        try {
            required.add(new Option("berlin").alt("b").defaultValue("something"));
            parameter = required.applyTo(parameter);
            Assert.assertEquals(parameter.data.get("berlin"), (Object)"value");
            Assert.assertEquals(parameter.data.get("b"), (Object)"value");
        }
        catch (RequiredParametersException e) {
            Assert.fail((String)("Exception thrown " + e.getMessage()));
        }
    }

    @Test
    public void testApplyToWithNonCastableType() throws RequiredParametersException {
        this.expectedException.expect(RequiredParametersException.class);
        this.expectedException.expectMessage("Value for parameter flag cannot be cast to type BOOLEAN");
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"--flag", "15"});
        RequiredParameters required = new RequiredParameters();
        required.add(new Option("flag").type(OptionType.BOOLEAN));
        required.applyTo(parameter);
    }

    @Test
    public void testApplyToWithSimpleOption() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"--berlin", "value"});
        RequiredParameters required = new RequiredParameters();
        try {
            required.add(new Option("berlin"));
            parameter = required.applyTo(parameter);
            Assert.assertEquals(parameter.data.get("berlin"), (Object)"value");
        }
        catch (RequiredParametersException e) {
            Assert.fail((String)("Exception thrown " + e.getMessage()));
        }
    }

    @Test
    public void testApplyToWithOptionAndDefaultValue() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"--berlin"});
        RequiredParameters required = new RequiredParameters();
        try {
            required.add(new Option("berlin").defaultValue("value"));
            parameter = required.applyTo(parameter);
            Assert.assertEquals(parameter.data.get("berlin"), (Object)"value");
        }
        catch (RequiredParametersException e) {
            Assert.fail((String)("Exception thrown " + e.getMessage()));
        }
    }

    @Test
    public void testApplyToWithOptionWithLongAndShortNameAndDefaultValue() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"--berlin"});
        RequiredParameters required = new RequiredParameters();
        try {
            required.add(new Option("berlin").alt("b").defaultValue("value"));
            parameter = required.applyTo(parameter);
            Assert.assertEquals(parameter.data.get("berlin"), (Object)"value");
            Assert.assertEquals(parameter.data.get("b"), (Object)"value");
        }
        catch (RequiredParametersException e) {
            Assert.fail((String)("Exception thrown " + e.getMessage()));
        }
    }

    @Test
    public void testApplyToWithOptionMultipleOptionsAndOneDefaultValue() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[]{"--input", "abc"});
        RequiredParameters rq = new RequiredParameters();
        try {
            rq.add("input");
            rq.add(new Option("parallelism").alt("p").defaultValue("1").type(OptionType.INTEGER));
            parameter = rq.applyTo(parameter);
            Assert.assertEquals(parameter.data.get("parallelism"), (Object)"1");
            Assert.assertEquals(parameter.data.get("p"), (Object)"1");
            Assert.assertEquals(parameter.data.get("input"), (Object)"abc");
        }
        catch (RequiredParametersException e) {
            Assert.fail((String)("Exception thrown " + e.getMessage()));
        }
    }

    @Test
    public void testApplyToWithMultipleTypes() {
        ParameterTool parameter = ParameterTool.fromArgs((String[])new String[0]);
        RequiredParameters required = new RequiredParameters();
        try {
            required.add(new Option("berlin").defaultValue("value"));
            required.add(new Option("count").defaultValue("15"));
            required.add(new Option("someFlag").alt("sf").defaultValue("true"));
            parameter = required.applyTo(parameter);
            Assert.assertEquals(parameter.data.get("berlin"), (Object)"value");
            Assert.assertEquals(parameter.data.get("count"), (Object)"15");
            Assert.assertEquals(parameter.data.get("someFlag"), (Object)"true");
            Assert.assertEquals(parameter.data.get("sf"), (Object)"true");
        }
        catch (RequiredParametersException e) {
            Assert.fail((String)("Exception thrown " + e.getMessage()));
        }
    }

    @Test
    public void testPrintHelpForFullySetOption() {
        RequiredParameters required = new RequiredParameters();
        try {
            required.add(new Option("option").defaultValue("some").help("help").alt("o").choices(new String[]{"some", "options"}));
            String helpText = required.getHelp();
            Assert.assertThat((Object)helpText, (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Required Parameters:"), (Matcher)CoreMatchers.containsString((String)"-o, --option"), (Matcher)CoreMatchers.containsString((String)"default: some"), (Matcher)CoreMatchers.containsString((String)"choices: "), (Matcher)CoreMatchers.containsString((String)"some"), (Matcher)CoreMatchers.containsString((String)"options")));
        }
        catch (RequiredParametersException e) {
            Assert.fail((String)("Exception thrown " + e.getMessage()));
        }
    }

    @Test
    public void testPrintHelpForMultipleParams() {
        RequiredParameters required = new RequiredParameters();
        try {
            required.add("input");
            required.add("output");
            required.add(new Option("parallelism").alt("p").help("Set the parallelism for all operators").type(OptionType.INTEGER));
            String helpText = required.getHelp();
            Assert.assertThat((Object)helpText, (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Required Parameters:"), (Matcher)CoreMatchers.containsString((String)"--input"), (Matcher)CoreMatchers.containsString((String)"--output"), (Matcher)CoreMatchers.containsString((String)"-p, --parallelism"), (Matcher)CoreMatchers.containsString((String)"Set the parallelism for all operators")));
            Assert.assertThat((Object)helpText, (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"choices")), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"default"))));
        }
        catch (RequiredParametersException e) {
            Assert.fail((String)("Exception thrown " + e.getMessage()));
        }
    }

    @Test
    public void testPrintHelpWithMissingParams() {
        RequiredParameters required = new RequiredParameters();
        String helpText = required.getHelp(Arrays.asList("param1", "param2", "paramN"));
        Assert.assertThat((Object)helpText, (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Missing arguments for:"), (Matcher)CoreMatchers.containsString((String)"param1 "), (Matcher)CoreMatchers.containsString((String)"param2 "), (Matcher)CoreMatchers.containsString((String)"paramN ")));
    }
}

