/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.utils;

import java.util.Arrays;
import java.util.Collections;
import org.apache.flink.api.java.utils.AbstractParameterTool;
import org.apache.flink.api.java.utils.AbstractParameterToolTest;
import org.apache.flink.api.java.utils.MultipleParameterTool;
import org.junit.Assert;
import org.junit.Test;

public class MultipleParameterToolTest
extends AbstractParameterToolTest {
    @Test
    public void testFromCliArgsWithMultipleParameters() {
        MultipleParameterTool parameter = (MultipleParameterTool)this.createParameterToolFromArgs(new String[]{"--input", "myInput", "-expectedCount", "15", "--multi", "multiValue1", "--multi", "multiValue2", "--withoutValues", "--negativeFloat", "-0.58", "-isWorking", "true", "--maxByte", "127", "-negativeShort", "-1024"});
        Assert.assertEquals((long)8L, (long)parameter.getNumberOfParameters());
        this.validate((AbstractParameterTool)parameter);
        Assert.assertTrue((boolean)parameter.has("withoutValues"));
        Assert.assertEquals((double)-0.58, (double)parameter.getFloat("negativeFloat"), (double)0.1);
        Assert.assertTrue((boolean)parameter.getBoolean("isWorking"));
        Assert.assertEquals((long)127L, (long)parameter.getByte("maxByte"));
        Assert.assertEquals((long)-1024L, (long)parameter.getShort("negativeShort"));
        this.exception.expect(IllegalStateException.class);
        this.exception.expectMessage("Key multi should has only one value");
        parameter.get("multi");
    }

    @Test
    public void testUnrequestedMultiParameter() {
        MultipleParameterTool parameter = (MultipleParameterTool)this.createParameterToolFromArgs(new String[]{"--multi", "v1", "--multi", "v2", "--multi2", "vv1"});
        Assert.assertEquals(MultipleParameterToolTest.createHashSet("multi", "multi2"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals(Arrays.asList("v1", "v2"), (Object)parameter.getMultiParameter("multi"));
        Assert.assertEquals(MultipleParameterToolTest.createHashSet("multi2"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals(Collections.singletonList("vv1"), (Object)parameter.getMultiParameterRequired("multi2"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testMerged() {
        MultipleParameterTool parameter1 = (MultipleParameterTool)this.createParameterToolFromArgs(new String[]{"--input", "myInput", "--merge", "v1", "--merge", "v2"});
        MultipleParameterTool parameter2 = (MultipleParameterTool)this.createParameterToolFromArgs(new String[]{"--multi", "multiValue1", "--multi", "multiValue2", "-expectedCount", "15", "--merge", "v3"});
        MultipleParameterTool parameter = parameter1.mergeWith(parameter2);
        this.validate((AbstractParameterTool)parameter);
        Assert.assertEquals(Arrays.asList("v1", "v2", "v3"), (Object)parameter.getMultiParameter("merge"));
    }

    @Override
    protected AbstractParameterTool createParameterToolFromArgs(String[] args) {
        return MultipleParameterTool.fromArgs((String[])args);
    }
}

