/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.api.java.summarize.StringColumnSummary;
import org.apache.flink.api.java.summarize.aggregation.AggregateCombineHarness;
import org.apache.flink.api.java.summarize.aggregation.StringSummaryAggregator;
import org.junit.Assert;
import org.junit.Test;

public class StringSummaryAggregatorTest {
    @Test
    public void testMixedGroup() {
        StringColumnSummary summary = this.summarize("abc", "", null, "  ", "defghi", "foo", null, null, "", " ");
        Assert.assertEquals((long)10L, (long)summary.getTotalCount());
        Assert.assertEquals((long)3L, (long)summary.getNullCount());
        Assert.assertEquals((long)7L, (long)summary.getNonNullCount());
        Assert.assertEquals((long)2L, (long)summary.getEmptyCount());
        Assert.assertEquals((long)0L, (long)summary.getMinLength().intValue());
        Assert.assertEquals((long)6L, (long)summary.getMaxLength().intValue());
        Assert.assertEquals((double)2.142857, (double)summary.getMeanLength(), (double)0.001);
    }

    @Test
    public void testAllNullStrings() {
        StringColumnSummary summary = this.summarize(null, null, null, null);
        Assert.assertEquals((long)4L, (long)summary.getTotalCount());
        Assert.assertEquals((long)4L, (long)summary.getNullCount());
        Assert.assertEquals((long)0L, (long)summary.getNonNullCount());
        Assert.assertEquals((long)0L, (long)summary.getEmptyCount());
        Assert.assertNull((Object)summary.getMinLength());
        Assert.assertNull((Object)summary.getMaxLength());
        Assert.assertNull((Object)summary.getMeanLength());
    }

    @Test
    public void testAllWithValues() {
        StringColumnSummary summary = this.summarize("cat", "hat", "dog", "frog");
        Assert.assertEquals((long)4L, (long)summary.getTotalCount());
        Assert.assertEquals((long)0L, (long)summary.getNullCount());
        Assert.assertEquals((long)4L, (long)summary.getNonNullCount());
        Assert.assertEquals((long)0L, (long)summary.getEmptyCount());
        Assert.assertEquals((long)3L, (long)summary.getMinLength().intValue());
        Assert.assertEquals((long)4L, (long)summary.getMaxLength().intValue());
        Assert.assertEquals((double)3.25, (double)summary.getMeanLength(), (double)0.0);
    }

    protected StringColumnSummary summarize(String ... values) {
        return (StringColumnSummary)new AggregateCombineHarness<String, StringColumnSummary, StringSummaryAggregator>(){

            @Override
            protected void compareResults(StringColumnSummary result1, StringColumnSummary result2) {
                Assert.assertEquals((long)result1.getEmptyCount(), (long)result2.getEmptyCount());
                Assert.assertEquals((Object)result1.getMaxLength(), (Object)result2.getMaxLength());
                Assert.assertEquals((Object)result1.getMinLength(), (Object)result2.getMinLength());
                if (result1.getMeanLength() == null) {
                    Assert.assertEquals((Object)result1.getMeanLength(), (Object)result2.getMeanLength());
                } else {
                    Assert.assertEquals((double)result1.getMeanLength(), (double)result2.getMeanLength(), (double)1.0E-5);
                }
                Assert.assertEquals((long)result1.getNullCount(), (long)result2.getNullCount());
                Assert.assertEquals((long)result1.getNonNullCount(), (long)result2.getNonNullCount());
            }
        }.summarize(values);
    }
}

