/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.junit.Assert;
import org.junit.Test;

public class GroupingTest {
    private final List<Tuple5<Integer, Long, String, Long, Integer>> emptyTupleData = new ArrayList<Tuple5<Integer, Long, String, Long, Integer>>();
    private final TupleTypeInfo<Tuple5<Integer, Long, String, Long, Integer>> tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
    private final TupleTypeInfo<Tuple4<Integer, Long, CustomType, Long[]>> tupleWithCustomInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, TypeExtractor.createTypeInfo(CustomType.class), BasicArrayTypeInfo.LONG_ARRAY_TYPE_INFO});
    private final List<Long> emptyLongData = new ArrayList<Long>();
    private final List<CustomType> customTypeData = new ArrayList<CustomType>();
    private final List<Tuple4<Integer, Long, CustomType, Long[]>> tupleWithCustomData = new ArrayList<Tuple4<Integer, Long, CustomType, Long[]>>();
    private final List<Tuple2<byte[], byte[]>> byteArrayData = new ArrayList<Tuple2<byte[], byte[]>>();

    @Test
    public void testGroupByKeyFields1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        try {
            tupleDs.groupBy(new int[]{0});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test(expected=InvalidProgramException.class)
    public void testGroupByKeyFields2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource longDs = env.fromCollection(this.emptyLongData, (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO);
        longDs.groupBy(new int[]{0});
    }

    @Test(expected=InvalidProgramException.class)
    public void testGroupByKeyFields3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        this.customTypeData.add(new CustomType());
        DataSource customDs = env.fromCollection(this.customTypeData);
        customDs.groupBy(new int[]{0});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testGroupByKeyFields4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        tupleDs.groupBy(new int[]{5});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testGroupByKeyFields5() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        tupleDs.groupBy(new int[]{-1});
    }

    @Test
    public void testGroupByKeyFieldsOnPrimitiveArray() {
        this.byteArrayData.add((Tuple2<byte[], byte[]>)new Tuple2((Object)new byte[]{0}, (Object)new byte[]{1}));
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.byteArrayData);
        tupleDs.groupBy(new int[]{0});
    }

    @Test
    public void testGroupByKeyExpressions1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        this.customTypeData.add(new CustomType());
        DataSource ds = env.fromCollection(this.customTypeData);
        try {
            ds.groupBy(new String[]{"myInt"});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test(expected=InvalidProgramException.class)
    public void testGroupByKeyExpressions2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource longDs = env.fromCollection(this.emptyLongData, (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO);
        longDs.groupBy(new String[]{"myInt"});
    }

    @Test(expected=InvalidProgramException.class)
    public void testGroupByKeyExpressions3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        this.customTypeData.add(new CustomType());
        DataSource customDs = env.fromCollection(this.customTypeData);
        customDs.groupBy(new int[]{0});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGroupByKeyExpressions4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds = env.fromCollection(this.customTypeData);
        ds.groupBy(new String[]{"myNonExistent"});
    }

    @Test
    public void testGroupByKeyExpressions1Nested() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        this.customTypeData.add(new CustomType());
        DataSource ds = env.fromCollection(this.customTypeData);
        try {
            ds.groupBy(new String[]{"nested.myInt"});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGroupByKeyExpressions2Nested() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds = env.fromCollection(this.customTypeData);
        ds.groupBy(new String[]{"nested.myNonExistent"});
    }

    @Test
    public void testGroupByKeySelector1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        this.customTypeData.add(new CustomType());
        try {
            DataSource customDs = env.fromCollection(this.customTypeData);
            customDs.groupBy((KeySelector)new KeySelector<CustomType, Long>(){

                public Long getKey(CustomType value) {
                    return value.myLong;
                }
            });
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testGroupByKeySelector2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        this.customTypeData.add(new CustomType());
        try {
            DataSource customDs = env.fromCollection(this.customTypeData);
            customDs.groupBy((KeySelector)new KeySelector<CustomType, Tuple2<Integer, Long>>(){

                public Tuple2<Integer, Long> getKey(CustomType value) {
                    return new Tuple2((Object)value.myInt, (Object)value.myLong);
                }
            });
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testGroupByKeySelector3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        this.customTypeData.add(new CustomType());
        try {
            DataSource customDs = env.fromCollection(this.customTypeData);
            customDs.groupBy((KeySelector)new KeySelector<CustomType, CustomType>(){

                public CustomType getKey(CustomType value) {
                    return value;
                }
            });
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testGroupByKeySelector4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        this.customTypeData.add(new CustomType());
        try {
            DataSource customDs = env.fromCollection(this.customTypeData);
            customDs.groupBy((KeySelector)new KeySelector<CustomType, Tuple2<Integer, CustomType>>(){

                public Tuple2<Integer, CustomType> getKey(CustomType value) {
                    return new Tuple2((Object)value.myInt, (Object)value);
                }
            });
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test(expected=InvalidProgramException.class)
    public void testGroupByKeySelector5() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        this.customTypeData.add(new CustomType());
        DataSource customDs = env.fromCollection(this.customTypeData);
        customDs.groupBy((KeySelector)new KeySelector<CustomType, CustomType2>(){

            public CustomType2 getKey(CustomType value) {
                return new CustomType2();
            }
        });
    }

    @Test
    public void testGroupSortKeyFields1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        try {
            tupleDs.groupBy(new int[]{0}).sortGroup(0, Order.ASCENDING);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testGroupSortKeyFields2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        tupleDs.groupBy(new int[]{0}).sortGroup(5, Order.ASCENDING);
    }

    @Test(expected=InvalidProgramException.class)
    public void testGroupSortKeyFields3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource longDs = env.fromCollection(this.emptyLongData, (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO);
        longDs.groupBy((KeySelector)new KeySelector<Long, Long>(){
            private static final long serialVersionUID = 1L;

            public Long getKey(Long value) {
                return value;
            }
        }).sortGroup(0, Order.ASCENDING);
    }

    @Test(expected=InvalidProgramException.class)
    public void testGroupSortKeyFields4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        tupleDs.groupBy(new int[]{0}).sortGroup(2, Order.ASCENDING);
    }

    @Test(expected=InvalidProgramException.class)
    public void testGroupSortKeyFields5() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        tupleDs.groupBy(new int[]{0}).sortGroup(3, Order.ASCENDING);
    }

    @Test
    public void testChainedGroupSortKeyFields() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        try {
            tupleDs.groupBy(new int[]{0}).sortGroup(0, Order.ASCENDING).sortGroup(2, Order.DESCENDING);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testGroupSortByKeyExpression1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        try {
            tupleDs.groupBy(new String[]{"f0"}).sortGroup("f1", Order.ASCENDING);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testGroupSortByKeyExpression2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        try {
            tupleDs.groupBy(new String[]{"f0"}).sortGroup("f2.myString", Order.ASCENDING);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testGroupSortByKeyExpression3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        try {
            tupleDs.groupBy(new String[]{"f0"}).sortGroup("f2.myString", Order.ASCENDING).sortGroup("f1", Order.DESCENDING);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test(expected=InvalidProgramException.class)
    public void testGroupSortByKeyExpression4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        tupleDs.groupBy(new String[]{"f0"}).sortGroup("f2", Order.ASCENDING);
    }

    @Test(expected=InvalidProgramException.class)
    public void testGroupSortByKeyExpression5() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        tupleDs.groupBy(new String[]{"f0"}).sortGroup("f1", Order.ASCENDING).sortGroup("f2", Order.ASCENDING);
    }

    @Test(expected=InvalidProgramException.class)
    public void testGroupSortByKeyExpression6() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        tupleDs.groupBy(new String[]{"f0"}).sortGroup("f3", Order.ASCENDING);
    }

    @Test
    public void testGroupSortByKeySelector1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        tupleDs.groupBy((KeySelector)new KeySelector<Tuple4<Integer, Long, CustomType, Long[]>, Long>(){

            public Long getKey(Tuple4<Integer, Long, CustomType, Long[]> value) throws Exception {
                return (Long)value.f1;
            }
        }).sortGroup((KeySelector)new KeySelector<Tuple4<Integer, Long, CustomType, Long[]>, Integer>(){

            public Integer getKey(Tuple4<Integer, Long, CustomType, Long[]> value) throws Exception {
                return (Integer)value.f0;
            }
        }, Order.ASCENDING);
    }

    @Test(expected=InvalidProgramException.class)
    public void testGroupSortByKeySelector2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        tupleDs.groupBy((KeySelector)new KeySelector<Tuple4<Integer, Long, CustomType, Long[]>, Long>(){

            public Long getKey(Tuple4<Integer, Long, CustomType, Long[]> value) throws Exception {
                return (Long)value.f1;
            }
        }).sortGroup((KeySelector)new KeySelector<Tuple4<Integer, Long, CustomType, Long[]>, CustomType>(){

            public CustomType getKey(Tuple4<Integer, Long, CustomType, Long[]> value) throws Exception {
                return (CustomType)value.f2;
            }
        }, Order.ASCENDING);
    }

    @Test(expected=InvalidProgramException.class)
    public void testGroupSortByKeySelector3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        tupleDs.groupBy((KeySelector)new KeySelector<Tuple4<Integer, Long, CustomType, Long[]>, Long>(){

            public Long getKey(Tuple4<Integer, Long, CustomType, Long[]> value) throws Exception {
                return (Long)value.f1;
            }
        }).sortGroup((KeySelector)new KeySelector<Tuple4<Integer, Long, CustomType, Long[]>, Long[]>(){

            public Long[] getKey(Tuple4<Integer, Long, CustomType, Long[]> value) throws Exception {
                return (Long[])value.f3;
            }
        }, Order.ASCENDING);
    }

    @Test
    public void testGroupingAtomicType() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource dataSet = env.fromElements((Object[])new Integer[]{0, 1, 1, 2, 0, 0});
        dataSet.groupBy(new String[]{"*"});
    }

    @Test(expected=InvalidProgramException.class)
    public void testGroupAtomicTypeWithInvalid1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource dataSet = env.fromElements((Object[])new Integer[]{0, 1, 2, 3});
        dataSet.groupBy(new String[]{"*", "invalidField"});
    }

    @Test(expected=InvalidProgramException.class)
    public void testGroupAtomicTypeWithInvalid2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource dataSet = env.fromElements((Object[])new Integer[]{0, 1, 2, 3});
        dataSet.groupBy(new String[]{"invalidField"});
    }

    @Test(expected=InvalidProgramException.class)
    public void testGroupAtomicTypeWithInvalid3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource dataSet = env.fromElements((Object[])new ArrayList[]{new ArrayList()});
        dataSet.groupBy(new String[]{"*"});
    }

    public static class CustomType2
    implements Serializable {
        public int myInt;
        public Integer[] myIntArray;
    }

    public static class CustomType
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int myInt;
        public long myLong;
        public String myString;
        public Nest nested;

        public CustomType() {
        }

        public CustomType(int i, long l, String s) {
            this.myInt = i;
            this.myLong = l;
            this.myString = s;
        }

        public String toString() {
            return this.myInt + "," + this.myLong + "," + this.myString;
        }

        public static class Nest {
            public int myInt;
        }
    }
}

