/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operator;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.SingleInputSemanticProperties;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.GroupCombineOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.util.Collector;
import org.junit.Assert;
import org.junit.Test;

public class GroupCombineOperatorTest {
    private final List<Tuple5<Integer, Long, String, Long, Integer>> emptyTupleData = new ArrayList<Tuple5<Integer, Long, String, Long, Integer>>();
    private final TupleTypeInfo<Tuple5<Integer, Long, String, Long, Integer>> tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});

    @Test
    public void testSemanticPropsWithKeySelector1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        GroupCombineOperator combineOp = tupleDs.groupBy((KeySelector)new DummyTestKeySelector()).combineGroup((GroupCombineFunction)new DummyGroupCombineFunction1());
        SingleInputSemanticProperties semProps = combineOp.getSemanticProperties();
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 2).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 2).contains(Integer.valueOf(4)));
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 3).size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 3).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 3).contains(Integer.valueOf(3)));
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 4).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 4).contains(Integer.valueOf(2)));
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 5).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 6).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingSourceField(0, 0) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingSourceField(0, 1) == 3 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingSourceField(0, 2) == 4 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingSourceField(0, 3) == 3 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingSourceField(0, 4) == 2 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getReadFields(0).size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getReadFields(0).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)semProps.getReadFields(0).contains(Integer.valueOf(5)));
        Assert.assertTrue((boolean)semProps.getReadFields(0).contains(Integer.valueOf(6)));
    }

    @Test
    public void testSemanticPropsWithKeySelector2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        GroupCombineOperator combineOp = tupleDs.groupBy((KeySelector)new DummyTestKeySelector()).sortGroup((KeySelector)new DummyTestKeySelector(), Order.ASCENDING).combineGroup((GroupCombineFunction)new DummyGroupCombineFunction1());
        SingleInputSemanticProperties semProps = combineOp.getSemanticProperties();
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 2).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 3).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 4).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 4).contains(Integer.valueOf(4)));
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 5).size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 5).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 5).contains(Integer.valueOf(3)));
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 6).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 6).contains(Integer.valueOf(2)));
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 7).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 8).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingSourceField(0, 0) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingSourceField(0, 1) == 5 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingSourceField(0, 2) == 6 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingSourceField(0, 3) == 5 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingSourceField(0, 4) == 4 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getReadFields(0).size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getReadFields(0).contains(Integer.valueOf(4)));
        Assert.assertTrue((boolean)semProps.getReadFields(0).contains(Integer.valueOf(7)));
        Assert.assertTrue((boolean)semProps.getReadFields(0).contains(Integer.valueOf(8)));
    }

    @Test
    public void testSemanticPropsWithKeySelector3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        GroupCombineOperator combineOp = (GroupCombineOperator)tupleDs.groupBy((KeySelector)new DummyTestKeySelector()).combineGroup((GroupCombineFunction)new DummyGroupCombineFunction2()).withForwardedFields(new String[]{"0->4;1;1->3;2"});
        SingleInputSemanticProperties semProps = combineOp.getSemanticProperties();
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 2).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 2).contains(Integer.valueOf(4)));
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 3).size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 3).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 3).contains(Integer.valueOf(3)));
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 4).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 4).contains(Integer.valueOf(2)));
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 5).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 6).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingSourceField(0, 0) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingSourceField(0, 1) == 3 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingSourceField(0, 2) == 4 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingSourceField(0, 3) == 3 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingSourceField(0, 4) == 2 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getReadFields(0).size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getReadFields(0).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)semProps.getReadFields(0).contains(Integer.valueOf(5)));
        Assert.assertTrue((boolean)semProps.getReadFields(0).contains(Integer.valueOf(6)));
    }

    @Test
    public void testSemanticPropsWithKeySelector4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        GroupCombineOperator combineOp = (GroupCombineOperator)tupleDs.groupBy((KeySelector)new DummyTestKeySelector()).sortGroup((KeySelector)new DummyTestKeySelector(), Order.ASCENDING).combineGroup((GroupCombineFunction)new DummyGroupCombineFunction2()).withForwardedFields(new String[]{"0->4;1;1->3;2"});
        SingleInputSemanticProperties semProps = combineOp.getSemanticProperties();
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 2).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 3).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 4).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 4).contains(Integer.valueOf(4)));
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 5).size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 5).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 5).contains(Integer.valueOf(3)));
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 6).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 6).contains(Integer.valueOf(2)));
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 7).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 8).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingSourceField(0, 0) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingSourceField(0, 1) == 5 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingSourceField(0, 2) == 6 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingSourceField(0, 3) == 5 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingSourceField(0, 4) == 4 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getReadFields(0).size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getReadFields(0).contains(Integer.valueOf(4)));
        Assert.assertTrue((boolean)semProps.getReadFields(0).contains(Integer.valueOf(7)));
        Assert.assertTrue((boolean)semProps.getReadFields(0).contains(Integer.valueOf(8)));
    }

    @Test
    public void testSemanticPropsWithKeySelector5() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        GroupCombineOperator combineOp = (GroupCombineOperator)tupleDs.groupBy((KeySelector)new DummyTestKeySelector()).combineGroup((GroupCombineFunction)new DummyGroupCombineFunction3()).withForwardedFields(new String[]{"4->0;3;3->1;2"});
        SingleInputSemanticProperties semProps = combineOp.getSemanticProperties();
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 2).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 3).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 4).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 4).contains(Integer.valueOf(2)));
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 5).size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 5).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 5).contains(Integer.valueOf(3)));
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 6).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 6).contains(Integer.valueOf(0)));
        Assert.assertTrue((semProps.getForwardingSourceField(0, 0) == 6 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingSourceField(0, 1) == 5 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingSourceField(0, 2) == 4 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingSourceField(0, 3) == 5 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingSourceField(0, 4) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getReadFields(0) == null ? 1 : 0) != 0);
    }

    @Test
    public void testSemanticPropsWithKeySelector6() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        GroupCombineOperator combineOp = (GroupCombineOperator)tupleDs.groupBy((KeySelector)new DummyTestKeySelector()).sortGroup((KeySelector)new DummyTestKeySelector(), Order.ASCENDING).combineGroup((GroupCombineFunction)new DummyGroupCombineFunction3()).withForwardedFields(new String[]{"4->0;3;3->1;2"});
        SingleInputSemanticProperties semProps = combineOp.getSemanticProperties();
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 2).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 3).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 4).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 5).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 6).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 6).contains(Integer.valueOf(2)));
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 7).size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 7).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 7).contains(Integer.valueOf(3)));
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 8).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 8).contains(Integer.valueOf(0)));
        Assert.assertTrue((semProps.getForwardingSourceField(0, 0) == 8 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingSourceField(0, 1) == 7 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingSourceField(0, 2) == 6 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingSourceField(0, 3) == 7 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingSourceField(0, 4) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getReadFields(0) == null ? 1 : 0) != 0);
    }

    @Test
    public void testSemanticPropsWithKeySelector7() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        GroupCombineOperator combineOp = tupleDs.groupBy((KeySelector)new DummyTestKeySelector()).combineGroup((GroupCombineFunction)new DummyGroupCombineFunction4());
        SingleInputSemanticProperties semProps = combineOp.getSemanticProperties();
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 2).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 2).contains(Integer.valueOf(0)));
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 3).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 3).contains(Integer.valueOf(1)));
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 4).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 5).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 5).contains(Integer.valueOf(3)));
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 6).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingSourceField(0, 0) == 2 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingSourceField(0, 1) == 3 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingSourceField(0, 2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingSourceField(0, 3) == 5 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingSourceField(0, 4) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getReadFields(0) == null ? 1 : 0) != 0);
    }

    @FunctionAnnotation.NonForwardedFields(value={"2;4"})
    private static class DummyGroupCombineFunction4
    implements GroupCombineFunction<Tuple5<Integer, Long, String, Long, Integer>, Tuple5<Integer, Long, String, Long, Integer>> {
        private DummyGroupCombineFunction4() {
        }

        public void combine(Iterable<Tuple5<Integer, Long, String, Long, Integer>> values, Collector<Tuple5<Integer, Long, String, Long, Integer>> out) throws Exception {
        }
    }

    private static class DummyGroupCombineFunction3
    implements GroupCombineFunction<Tuple5<Integer, Long, String, Long, Integer>, Tuple5<Integer, Long, String, Long, Integer>> {
        private DummyGroupCombineFunction3() {
        }

        public void combine(Iterable<Tuple5<Integer, Long, String, Long, Integer>> values, Collector<Tuple5<Integer, Long, String, Long, Integer>> out) throws Exception {
        }
    }

    @FunctionAnnotation.ReadFields(value={"0;3;4"})
    private static class DummyGroupCombineFunction2
    implements GroupCombineFunction<Tuple5<Integer, Long, String, Long, Integer>, Tuple5<Integer, Long, String, Long, Integer>> {
        private DummyGroupCombineFunction2() {
        }

        public void combine(Iterable<Tuple5<Integer, Long, String, Long, Integer>> values, Collector<Tuple5<Integer, Long, String, Long, Integer>> out) throws Exception {
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0->4;1;1->3;2"})
    @FunctionAnnotation.ReadFields(value={"0;3;4"})
    private static class DummyGroupCombineFunction1
    implements GroupCombineFunction<Tuple5<Integer, Long, String, Long, Integer>, Tuple5<Integer, Long, String, Long, Integer>> {
        private DummyGroupCombineFunction1() {
        }

        public void combine(Iterable<Tuple5<Integer, Long, String, Long, Integer>> values, Collector<Tuple5<Integer, Long, String, Long, Integer>> out) throws Exception {
        }
    }

    private static class DummyTestKeySelector
    implements KeySelector<Tuple5<Integer, Long, String, Long, Integer>, Tuple2<Long, Integer>> {
        private DummyTestKeySelector() {
        }

        public Tuple2<Long, Integer> getKey(Tuple5<Integer, Long, String, Long, Integer> value) throws Exception {
            return new Tuple2();
        }
    }
}

