/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.functions;

import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.SelectByMaxFunction;
import org.apache.flink.api.java.functions.SelectByMinFunction;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.junit.Assert;
import org.junit.Test;

public class SelectByFunctionsTest {
    private final TupleTypeInfo<Tuple5<Integer, Long, String, Long, Integer>> tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
    private final Tuple5<Integer, Long, String, Long, Integer> bigger = new Tuple5((Object)10, (Object)100L, (Object)"HelloWorld", (Object)200L, (Object)20);
    private final Tuple5<Integer, Long, String, Long, Integer> smaller = new Tuple5((Object)5, (Object)50L, (Object)"Hello", (Object)50L, (Object)15);
    private final Tuple5<Integer, Long, String, Long, Integer> specialCaseBigger = new Tuple5((Object)10, (Object)100L, (Object)"HelloWorld", (Object)200L, (Object)17);
    private final Tuple5<Integer, Long, String, Long, Integer> specialCaseSmaller = new Tuple5((Object)5, (Object)50L, (Object)"Hello", (Object)50L, (Object)17);

    @Test
    public void testMaxByComparison() {
        SelectByMaxFunction maxByTuple = new SelectByMaxFunction(this.tupleTypeInfo, new int[]{0});
        try {
            Assert.assertSame((String)"SelectByMax must return bigger tuple", this.bigger, (Object)maxByTuple.reduce(this.smaller, this.bigger));
            Assert.assertSame((String)"SelectByMax must return bigger tuple", this.bigger, (Object)maxByTuple.reduce(this.bigger, this.smaller));
        }
        catch (Exception e) {
            Assert.fail((String)"No exception should be thrown while comparing both tuples");
        }
    }

    @Test
    public void testMaxByComparisonSpecialCase1() {
        SelectByMaxFunction maxByTuple = new SelectByMaxFunction(this.tupleTypeInfo, new int[]{0, 3});
        try {
            Assert.assertSame((String)"SelectByMax must return the first given tuple", this.specialCaseBigger, (Object)maxByTuple.reduce(this.specialCaseBigger, this.bigger));
            Assert.assertSame((String)"SelectByMax must return the first given tuple", this.bigger, (Object)maxByTuple.reduce(this.bigger, this.specialCaseBigger));
        }
        catch (Exception e) {
            Assert.fail((String)"No exception should be thrown while comparing both tuples");
        }
    }

    @Test
    public void testMaxByComparisonSpecialCase2() {
        SelectByMaxFunction maxByTuple = new SelectByMaxFunction(this.tupleTypeInfo, new int[]{0, 2, 1, 4, 3});
        try {
            Assert.assertSame((String)"SelectByMax must return bigger tuple", this.bigger, (Object)maxByTuple.reduce(this.specialCaseBigger, this.bigger));
            Assert.assertSame((String)"SelectByMax must return bigger tuple", this.bigger, (Object)maxByTuple.reduce(this.bigger, this.specialCaseBigger));
        }
        catch (Exception e) {
            Assert.fail((String)"No exception should be thrown while comparing both tuples");
        }
    }

    @Test
    public void testMaxByComparisonMultiple() {
        SelectByMaxFunction maxByTuple = new SelectByMaxFunction(this.tupleTypeInfo, new int[]{0, 1, 2, 3, 4});
        try {
            Assert.assertSame((String)"SelectByMax must return bigger tuple", this.bigger, (Object)maxByTuple.reduce(this.smaller, this.bigger));
            Assert.assertSame((String)"SelectByMax must return bigger tuple", this.bigger, (Object)maxByTuple.reduce(this.bigger, this.smaller));
        }
        catch (Exception e) {
            Assert.fail((String)"No exception should be thrown while comparing both tuples");
        }
    }

    @Test
    public void testMaxByComparisonMustReturnATuple() {
        SelectByMaxFunction maxByTuple = new SelectByMaxFunction(this.tupleTypeInfo, new int[]{0});
        try {
            Assert.assertSame((String)"SelectByMax must return bigger tuple", this.bigger, (Object)maxByTuple.reduce(this.bigger, this.bigger));
            Assert.assertSame((String)"SelectByMax must return smaller tuple", this.smaller, (Object)maxByTuple.reduce(this.smaller, this.smaller));
        }
        catch (Exception e) {
            Assert.fail((String)"No exception should be thrown while comparing both tuples");
        }
    }

    @Test
    public void testMinByComparison() {
        SelectByMinFunction minByTuple = new SelectByMinFunction(this.tupleTypeInfo, new int[]{0});
        try {
            Assert.assertSame((String)"SelectByMin must return smaller tuple", this.smaller, (Object)minByTuple.reduce(this.smaller, this.bigger));
            Assert.assertSame((String)"SelectByMin must return smaller tuple", this.smaller, (Object)minByTuple.reduce(this.bigger, this.smaller));
        }
        catch (Exception e) {
            Assert.fail((String)"No exception should be thrown while comparing both tuples");
        }
    }

    @Test
    public void testMinByComparisonSpecialCase1() {
        SelectByMinFunction minByTuple = new SelectByMinFunction(this.tupleTypeInfo, new int[]{0, 3});
        try {
            Assert.assertSame((String)"SelectByMin must return the first given tuple", this.specialCaseBigger, (Object)minByTuple.reduce(this.specialCaseBigger, this.bigger));
            Assert.assertSame((String)"SelectByMin must return the first given tuple", this.bigger, (Object)minByTuple.reduce(this.bigger, this.specialCaseBigger));
        }
        catch (Exception e) {
            Assert.fail((String)"No exception should be thrown while comparing both tuples");
        }
    }

    @Test
    public void testMinByComparisonSpecialCase2() {
        SelectByMinFunction minByTuple = new SelectByMinFunction(this.tupleTypeInfo, new int[]{0, 2, 1, 4, 3});
        try {
            Assert.assertSame((String)"SelectByMin must return smaller tuple", this.smaller, (Object)minByTuple.reduce(this.specialCaseSmaller, this.smaller));
            Assert.assertSame((String)"SelectByMin must return smaller tuple", this.smaller, (Object)minByTuple.reduce(this.smaller, this.specialCaseSmaller));
        }
        catch (Exception e) {
            Assert.fail((String)"No exception should be thrown while comparing both tuples");
        }
    }

    @Test
    public void testMinByComparisonMultiple() {
        SelectByMinFunction minByTuple = new SelectByMinFunction(this.tupleTypeInfo, new int[]{0, 1, 2, 3, 4});
        try {
            Assert.assertSame((String)"SelectByMin must return smaller tuple", this.smaller, (Object)minByTuple.reduce(this.smaller, this.bigger));
            Assert.assertSame((String)"SelectByMin must return smaller tuple", this.smaller, (Object)minByTuple.reduce(this.bigger, this.smaller));
        }
        catch (Exception e) {
            Assert.fail((String)"No exception should be thrown while comparing both tuples");
        }
    }
}

