/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.iot_explorer.mqtt;

import android.os.SystemClock;
import com.qcloud.iot_explorer.common.Status;
import com.qcloud.iot_explorer.device.CA;
import com.qcloud.iot_explorer.mqtt.TXMqttConnection;
import com.qcloud.iot_explorer.mqtt.TXOTACallBack;
import com.qcloud.iot_explorer.utils.TXLog;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.json.JSONException;
import org.json.JSONObject;

public class TXOTAImpl {
    private static final String TAG = TXOTAImpl.class.getName();
    private TXMqttConnection mConnection;
    private TXOTACallBack mCallback;
    private final String OTA_UPDATE_TOPIC;
    private final String OTA_REPORT_TOPIC;
    private final String mStoragePath;
    private static boolean mDownloadThreadRunning = false;
    private static Thread mDownloadThread = null;
    private boolean mSubscribedState = false;
    private final int DEFAULT_CONNECT_TIMEOUT = 10000;
    private final int DEFAULT_READ_TIMEOUT = 10000;
    private final int MAX_TRY_TIMES = 3;
    private static List<X509Certificate> serverCertList = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void prepareOTAServerCA() {
        if (serverCertList == null) {
            serverCertList = new ArrayList<X509Certificate>();
            for (String certStr : CA.cosServerCaCrtList) {
                ByteArrayInputStream caInput = null;
                try {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    caInput = new ByteArrayInputStream(certStr.getBytes());
                    X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(caInput);
                    if (certificate == null) continue;
                    serverCertList.add(certificate);
                }
                catch (Exception e) {
                    TXLog.e(TAG, "prepareOTAServerCA error:" + e);
                }
                finally {
                    if (caInput != null) {
                        try {
                            caInput.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
    }

    public TXOTAImpl(TXMqttConnection connection, String storagePath, TXOTACallBack callback) {
        this.mConnection = connection;
        this.mStoragePath = storagePath;
        this.mCallback = callback;
        this.OTA_UPDATE_TOPIC = "$ota/update/" + this.mConnection.mProductId + "/" + this.mConnection.mDeviceName;
        this.OTA_REPORT_TOPIC = "$ota/report/" + this.mConnection.mProductId + "/" + this.mConnection.mDeviceName;
        TXOTAImpl.prepareOTAServerCA();
    }

    public void setSubscribedState(boolean state) {
        this.mSubscribedState = state;
    }

    public void onSubscribeCompleted(Status status, IMqttToken token, Object userContext, String msg) {
        String[] topics;
        if (status == Status.OK && (topics = token.getTopics()) != null) {
            for (int i = 0; i < topics.length; ++i) {
                if (!topics[i].startsWith("$ota/")) continue;
                this.mSubscribedState = true;
            }
        }
    }

    public boolean processMessage(String topic, MqttMessage message) {
        if (!topic.startsWith("$ota/")) {
            return false;
        }
        try {
            byte[] payload = message.getPayload();
            JSONObject jsonObject = new JSONObject(new String(payload));
            String type = jsonObject.getString("type");
            if (type.equalsIgnoreCase("update_firmware")) {
                String firmwareURL = jsonObject.getString("url");
                String md5Sum = jsonObject.getString("md5sum");
                String version = jsonObject.getString("version");
                this.downloadFirmware(firmwareURL, this.mStoragePath + "/" + md5Sum, md5Sum, version);
            } else if (type.equalsIgnoreCase("report_version_rsp")) {
                String resultCode = jsonObject.getString("result_code");
                String resultMsg = jsonObject.getString("result_msg");
                String version = jsonObject.getString("version");
                if (this.mCallback != null) {
                    this.mCallback.onReportFirmwareVersion(Integer.valueOf(resultCode), version, resultMsg);
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return true;
    }

    public Status reportCurrentFirmwareVersion(String currentFirmwareVersion) {
        if (!this.mSubscribedState) {
            this.subscribeTopic(10000);
        }
        MqttMessage message = new MqttMessage();
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("type", (Object)"report_version");
            JSONObject obj = new JSONObject();
            obj.put("version", (Object)currentFirmwareVersion);
            jsonObject.put("report", (Object)obj);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        message.setPayload(jsonObject.toString().getBytes());
        Status status = this.mConnection.publish(this.OTA_REPORT_TOPIC, message, null);
        return status;
    }

    public Status reportUpdateFirmwareState(String state, int resultCode, String resultMsg, String version) {
        return this.reportMessage("report_progress", state, resultCode, resultMsg, version);
    }

    private Status reportMessage(String type, String state, int resultCode, String resultMsg, String version) {
        MqttMessage message = new MqttMessage();
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("type", (Object)type);
            JSONObject reportJsonObject = new JSONObject();
            JSONObject progressJsonObject = new JSONObject();
            progressJsonObject.put("state", (Object)state);
            progressJsonObject.put("result_code", (Object)String.valueOf(resultCode));
            progressJsonObject.put("result_msg", (Object)resultMsg);
            reportJsonObject.put("progress", (Object)progressJsonObject);
            reportJsonObject.put("version", (Object)version);
            jsonObject.put("report", (Object)reportJsonObject);
        }
        catch (JSONException reportJsonObject) {
            // empty catch block
        }
        message.setQos(0);
        message.setPayload(jsonObject.toString().getBytes());
        Status status = this.mConnection.publish(this.OTA_REPORT_TOPIC, message, null);
        return status;
    }

    private Status reportProgressMessage(int percent, String version) {
        MqttMessage message = new MqttMessage();
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("type", (Object)"report_progress");
            JSONObject reportJsonObject = new JSONObject();
            JSONObject progressJsonObject = new JSONObject();
            progressJsonObject.put("state", (Object)"downloading");
            progressJsonObject.put("percent", (Object)String.valueOf(percent));
            progressJsonObject.put("result_code", (Object)"0");
            progressJsonObject.put("result_msg", (Object)"");
            reportJsonObject.put("progress", (Object)progressJsonObject);
            reportJsonObject.put("version", (Object)version);
            jsonObject.put("report", (Object)reportJsonObject);
        }
        catch (JSONException reportJsonObject) {
            // empty catch block
        }
        message.setQos(0);
        message.setPayload(jsonObject.toString().getBytes());
        Status status = this.mConnection.publish(this.OTA_REPORT_TOPIC, message, null);
        return status;
    }

    private Status subscribeTopic(int timeout) {
        this.mConnection.subscribe(this.OTA_UPDATE_TOPIC, 1, null);
        long beginTime = SystemClock.uptimeMillis();
        while (!this.mSubscribedState) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (SystemClock.uptimeMillis() - beginTime <= (long)timeout) continue;
        }
        if (this.mSubscribedState) {
            return Status.OK;
        }
        return Status.ERROR_TOPIC_UNSUBSCRIBED;
    }

    private HttpURLConnection createURLConnection(String firmwareURL) throws Exception {
        if (firmwareURL.toLowerCase().startsWith("https://")) {
            URL url = new URL(firmwareURL);
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            SSLContext sslContext = SSLContext.getInstance("SSL");
            TrustManager[] tm = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    TXLog.w(TAG, "checkClientTrusted");
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    if (x509Certificates == null) {
                        throw new CertificateException("check OTA server x509Certificates is null");
                    }
                    if (x509Certificates.length <= 0) {
                        throw new CertificateException("check OTA server x509Certificates is empty");
                    }
                    int match = 0;
                    for (X509Certificate cert : x509Certificates) {
                        try {
                            cert.checkValidity();
                            for (X509Certificate c : serverCertList) {
                                if (!cert.equals(c)) continue;
                                ++match;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (match > 0 && match == CA.cosServerCaCrtList.length) {
                        TXLog.i(TAG, "checkServerTrusted OK!!!");
                        return;
                    }
                    throw new CertificateException("check OTA server x509Certificates failed");
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
            sslContext.init(null, tm, new SecureRandom());
            SSLSocketFactory ssf = sslContext.getSocketFactory();
            conn.setSSLSocketFactory(ssf);
            return conn;
        }
        URL url = new URL(firmwareURL);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        return conn;
    }

    private void downloadFirmware(final String firmwareURL, final String outputFile, final String md5Sum, final String version) {
        if (mDownloadThreadRunning) {
            return;
        }
        mDownloadThreadRunning = true;
        mDownloadThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int tryTimes = 0;
                do {
                    RandomAccessFile fos = null;
                    InputStream stream = null;
                    try {
                        String calcMD5;
                        int len;
                        ++tryTimes;
                        fos = new RandomAccessFile(outputFile, "rw");
                        TXLog.d(TAG, "fileLength " + fos.length() + " bytes");
                        long downloadBytes = 0L;
                        int lastPercent = 0;
                        if (downloadBytes > 0L) {
                            fos.seek(downloadBytes);
                        }
                        TXLog.d(TAG, "connect: " + firmwareURL);
                        HttpURLConnection conn = TXOTAImpl.this.createURLConnection(firmwareURL);
                        conn.setConnectTimeout(10000);
                        conn.setReadTimeout(10000);
                        conn.setRequestProperty("Range", "bytes=" + downloadBytes + "-");
                        conn.connect();
                        int totalLength = conn.getContentLength();
                        TXLog.d(TAG, "totalLength " + totalLength + " bytes");
                        stream = conn.getInputStream();
                        byte[] buffer = new byte[0x100000];
                        while (downloadBytes < (long)totalLength && (len = stream.read(buffer)) >= 0) {
                            fos.write(buffer, 0, len);
                            int percent = (int)((float)(downloadBytes += (long)len) / (float)totalLength * 100.0f);
                            if (percent == lastPercent) continue;
                            lastPercent = percent;
                            if (TXOTAImpl.this.mCallback != null) {
                                TXOTAImpl.this.mCallback.onDownloadProgress(percent, version);
                            }
                            TXLog.d(TAG, "download " + downloadBytes + " bytes. percent:" + percent);
                            TXOTAImpl.this.reportProgressMessage(percent, version);
                        }
                        if (fos != null) {
                            fos.close();
                        }
                        if (stream != null) {
                            stream.close();
                        }
                        if (!(calcMD5 = TXOTAImpl.fileToMD5(outputFile)).equalsIgnoreCase(md5Sum)) {
                            TXLog.e(TAG, "md5 checksum not match!!! calculated md5:" + calcMD5);
                            if (TXOTAImpl.this.mCallback != null) {
                                TXOTAImpl.this.mCallback.onDownloadFailure(-4, version);
                            }
                            new File(outputFile).delete();
                            continue;
                        }
                        if (TXOTAImpl.this.mCallback == null) break;
                        TXOTAImpl.this.mCallback.onDownloadCompleted(outputFile, version);
                        break;
                    }
                    catch (CertificateException e) {
                        if (TXOTAImpl.this.mCallback == null) continue;
                        TXOTAImpl.this.mCallback.onDownloadFailure(-4, version);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        if (fos != null) {
                            try {
                                fos.close();
                            }
                            catch (Exception e) {}
                        }
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Exception e) {}
                        }
                    }
                } while (tryTimes <= 3);
                mDownloadThreadRunning = false;
            }
        });
        mDownloadThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String fileToMD5(String filePath) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(filePath);
            byte[] buffer = new byte[1024];
            MessageDigest digest = MessageDigest.getInstance("MD5");
            int numRead = 0;
            while (numRead != -1) {
                numRead = ((InputStream)inputStream).read(buffer);
                if (numRead <= 0) continue;
                digest.update(buffer, 0, numRead);
            }
            byte[] md5Bytes = digest.digest();
            String string = TXOTAImpl.convertHashToString(md5Bytes);
            return string;
        }
        catch (Exception e) {
            String string = "";
            return string;
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static String convertHashToString(byte[] digestBytes) {
        String returnVal = "";
        for (int i = 0; i < digestBytes.length; ++i) {
            returnVal = returnVal + Integer.toString((digestBytes[i] & 0xFF) + 256, 16).substring(1);
        }
        return returnVal.toLowerCase();
    }
}

