/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.COSEncryptionClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSStaticCredentialsProvider;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.http.HttpProtocol;
import com.qcloud.cos.internal.crypto.CryptoConfiguration;
import com.qcloud.cos.internal.crypto.CryptoMode;
import com.qcloud.cos.internal.crypto.CryptoStorageMode;
import com.qcloud.cos.internal.crypto.EncryptionMaterials;
import com.qcloud.cos.internal.crypto.StaticEncryptionMaterialsProvider;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.region.Region;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class SymmetricKeyEncryptionClientDemo {
    private static final String keyFilePath = "secret.key";
    static String bucketName = "mybucket-1251668577";
    static String key = "testKMS/sym.txt";
    static File localFile = new File("len1m.txt");
    static COSClient cosClient = SymmetricKeyEncryptionClientDemo.createCosClient();

    static COSClient createCosClient() {
        return SymmetricKeyEncryptionClientDemo.createCosClient("ap-guangzhou");
    }

    static COSClient createCosClient(String region) {
        BasicCOSCredentials cred = new BasicCOSCredentials("AKIDxxxxxxxxxxxxxxxxxxxxxxxxxxxx", "yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy");
        ClientConfig clientConfig = new ClientConfig(new Region(region));
        clientConfig.setHttpProtocol(HttpProtocol.https);
        SecretKey symKey = null;
        try {
            symKey = SymmetricKeyEncryptionClientDemo.loadSymmetricAESKey();
        }
        catch (Exception e) {
            throw new CosClientException(e);
        }
        EncryptionMaterials encryptionMaterials = new EncryptionMaterials(symKey);
        CryptoConfiguration cryptoConf = new CryptoConfiguration(CryptoMode.AesCtrEncryption).withStorageMode(CryptoStorageMode.ObjectMetadata);
        COSEncryptionClient cosEncryptionClient = new COSEncryptionClient(new COSStaticCredentialsProvider(cred), new StaticEncryptionMaterialsProvider(encryptionMaterials), clientConfig, cryptoConf);
        return cosEncryptionClient;
    }

    public static void buildAndSaveSymmetricKey() throws IOException, NoSuchAlgorithmException {
        KeyGenerator symKeyGenerator = KeyGenerator.getInstance("AES");
        symKeyGenerator.init(256);
        SecretKey symKey = symKeyGenerator.generateKey();
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(symKey.getEncoded());
        FileOutputStream keyfos = new FileOutputStream(keyFilePath);
        keyfos.write(x509EncodedKeySpec.getEncoded());
        keyfos.close();
    }

    public static SecretKey loadSymmetricAESKey() throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException {
        File keyFile = new File(keyFilePath);
        FileInputStream keyfis = new FileInputStream(keyFile);
        byte[] encodedPrivateKey = new byte[(int)keyFile.length()];
        keyfis.read(encodedPrivateKey);
        keyfis.close();
        return new SecretKeySpec(encodedPrivateKey, "AES");
    }

    static void getObjectDemo() {
        GetObjectRequest getObjectRequest = new GetObjectRequest(bucketName, key);
        File downloadFile = new File("downSym.txt");
        ObjectMetadata objectMetadata = cosClient.getObject(getObjectRequest, downloadFile);
        System.out.println(objectMetadata.getRequestId());
    }

    static void putObjectDemo() {
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, key, localFile);
        PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
        System.out.println(putObjectResult.getRequestId());
    }

    static void deleteObjectDemo() {
        cosClient.deleteObject(bucketName, key);
    }

    public static void main(String[] args) throws Exception {
        SymmetricKeyEncryptionClientDemo.putObjectDemo();
        SymmetricKeyEncryptionClientDemo.getObjectDemo();
        cosClient.shutdown();
    }
}

