/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.model.COSObjectSummary;
import com.qcloud.cos.model.COSVersionSummary;
import com.qcloud.cos.model.ListObjectsRequest;
import com.qcloud.cos.model.ListVersionsRequest;
import com.qcloud.cos.model.ObjectListing;
import com.qcloud.cos.model.VersionListing;
import com.qcloud.cos.region.Region;
import java.util.List;

public class ListObjectsDemo {
    public static void listObjectsDemo() {
        BasicCOSCredentials cred = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-beijing-1"));
        COSClient cosclient = new COSClient(cred, clientConfig);
        String bucketName = "mybucket-1251668577";
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest();
        listObjectsRequest.setBucketName(bucketName);
        listObjectsRequest.setPrefix("");
        listObjectsRequest.setMaxKeys(1000);
        ObjectListing objectListing = null;
        try {
            objectListing = cosclient.listObjects(listObjectsRequest);
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
        List<String> commonPrefixs = objectListing.getCommonPrefixes();
        List<COSObjectSummary> cosObjectSummaries = objectListing.getObjectSummaries();
        for (COSObjectSummary cosObjectSummary : cosObjectSummaries) {
            String key = cosObjectSummary.getKey();
            String etag = cosObjectSummary.getETag();
            long fileSize = cosObjectSummary.getSize();
            String storageClasses = cosObjectSummary.getStorageClass();
            System.out.println("key: " + key);
        }
        cosclient.shutdown();
    }

    public static void listAllObjects() {
        BasicCOSCredentials cred = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-beijing-1"));
        COSClient cosclient = new COSClient(cred, clientConfig);
        String bucketName = "mybucket-1251668577";
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest();
        listObjectsRequest.setBucketName(bucketName);
        listObjectsRequest.setPrefix("");
        listObjectsRequest.setDelimiter("");
        listObjectsRequest.setMaxKeys(1000);
        ObjectListing objectListing = null;
        do {
            try {
                objectListing = cosclient.listObjects(listObjectsRequest);
            }
            catch (CosServiceException e) {
                e.printStackTrace();
                return;
            }
            catch (CosClientException e) {
                e.printStackTrace();
                return;
            }
            List<String> commonPrefixs = objectListing.getCommonPrefixes();
            List<COSObjectSummary> cosObjectSummaries = objectListing.getObjectSummaries();
            for (COSObjectSummary cosObjectSummary : cosObjectSummaries) {
                String key = cosObjectSummary.getKey();
                String etag = cosObjectSummary.getETag();
                long fileSize = cosObjectSummary.getSize();
                String string = cosObjectSummary.getStorageClass();
            }
            String nextMarker = objectListing.getNextMarker();
            listObjectsRequest.setMarker(nextMarker);
        } while (objectListing.isTruncated());
        cosclient.shutdown();
    }

    public static void listObjectsVersions() {
        BasicCOSCredentials cred = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-beijing-1"));
        COSClient cosclient = new COSClient(cred, clientConfig);
        String bucketName = "mybucket-1251668577";
        ListVersionsRequest listVersionsRequest = new ListVersionsRequest();
        listVersionsRequest.setBucketName(bucketName);
        listVersionsRequest.setPrefix("");
        VersionListing versionListing = null;
        do {
            try {
                versionListing = cosclient.listVersions(listVersionsRequest);
            }
            catch (CosServiceException e) {
                e.printStackTrace();
                return;
            }
            catch (CosClientException e) {
                e.printStackTrace();
                return;
            }
            List<COSVersionSummary> cosVersionSummaries = versionListing.getVersionSummaries();
            for (COSVersionSummary cosVersionSummary : cosVersionSummaries) {
                System.out.println(cosVersionSummary.getKey() + ":" + cosVersionSummary.getVersionId());
            }
            String keyMarker = versionListing.getNextKeyMarker();
            String versionIdMarker = versionListing.getNextVersionIdMarker();
            listVersionsRequest.setKeyMarker(keyMarker);
            listVersionsRequest.setVersionIdMarker(versionIdMarker);
        } while (versionListing.isTruncated());
        cosclient.shutdown();
    }

    public static void main(String[] args) {
        ListObjectsDemo.listObjectsVersions();
    }
}

