/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.track.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.text.TextUtils;
import java.net.NetworkInterface;
import java.net.SocketException;

public class NetworkUtils {
    public static boolean isIPAddr(String ipAddress) {
        if (ipAddress != null && !ipAddress.isEmpty()) {
            try {
                String[] tokens = ipAddress.split("\\.");
                if (tokens.length != 4) {
                    return false;
                }
                String[] var2 = tokens;
                int var3 = tokens.length;
                for (int var4 = 0; var4 < var3; ++var4) {
                    String token = var2[var4];
                    int i = Integer.parseInt(token);
                    if (i >= 0 && i <= 255) continue;
                    return false;
                }
                return true;
            }
            catch (Exception var7) {
                return false;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static String getLocalMachineIP() {
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
            if (networkInterfaces == null) {
                return null;
            }
            block2: while (true) {
                if (!networkInterfaces.hasMoreElements()) {
                    return null;
                }
                ni = networkInterfaces.nextElement();
                if (!ni.isUp()) continue;
                addresses = ni.getInetAddresses();
                do {
                    if (addresses.hasMoreElements()) ** break;
                    continue block2;
                } while ((address = addresses.nextElement()).isLinkLocalAddress() || address.getHostAddress() == null || (ipAddress = address.getHostAddress()).equals("127.0.0.1") || !NetworkUtils.isIPAddr(ipAddress));
                break;
            }
            return ipAddress;
        }
        catch (SocketException var5) {
            return null;
        }
    }

    public static String getNetworkType(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo info = cm.getActiveNetworkInfo();
        if (info == null || !info.isConnected()) {
            return "-";
        }
        if (info.getType() == 1) {
            return "WIFI";
        }
        if (info.getType() == 0) {
            int networkType = info.getSubtype();
            switch (networkType) {
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 11: 
                case 16: {
                    return "2G";
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: 
                case 17: {
                    return "3G";
                }
                case 13: 
                case 18: 
                case 19: {
                    return "4G";
                }
                case 20: {
                    return "5G";
                }
            }
            return "?";
        }
        return "?";
    }

    public static boolean isProxy() {
        String proxyAddress = System.getProperty("http.proxyHost");
        String portStr = System.getProperty("http.proxyPort");
        int proxyPort = Integer.parseInt(portStr != null ? portStr : "-1");
        return !TextUtils.isEmpty((CharSequence)proxyAddress) && proxyPort != -1;
    }
}

