/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.track.utils;

import android.content.Context;
import android.util.Log;
import com.tencent.qcloud.track.Constants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventFileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendEventToFile(Context context, String eventCode, Map<String, String> params) {
        long fileSizeInBytes;
        long fileSizeInMB;
        if (context == null) {
            return;
        }
        File file = new File(context.getExternalCacheDir() + File.separator + Constants.BEACON_EVENT_CACHE_FILE_NAME);
        File parentDir = file.getParentFile();
        if (parentDir != null && !parentDir.exists() && !parentDir.mkdirs()) {
            return;
        }
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    return;
                }
            }
            catch (IOException e) {
                Log.e((String)"FileUtils", (String)"Error creating new file", (Throwable)e);
                return;
            }
        }
        if ((fileSizeInMB = (fileSizeInBytes = file.length()) / 0x100000L) > 10L) {
            Log.e((String)"FileUtils", (String)"File size is larger than 10MB");
            return;
        }
        OutputStreamWriter outputStreamWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file, true);
            outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Event code: ").append(eventCode).append("\n");
            stringBuilder.append("Params: ").append("\n");
            for (Map.Entry<String, String> entry : params.entrySet()) {
                stringBuilder.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
            }
            stringBuilder.append("\n");
            outputStreamWriter.write(stringBuilder.toString());
            outputStreamWriter.flush();
        }
        catch (IOException e) {
            Log.e((String)"FileUtils", (String)"Error appending event to file", (Throwable)e);
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException e) {
                    Log.e((String)"FileUtils", (String)"Error closing OutputStreamWriter", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readEventFromFile(Context context, List<String> eventCodes, List<Map<String, String>> paramsList) {
        if (context == null) {
            return;
        }
        File file = new File(context.getExternalCacheDir() + File.separator + Constants.BEACON_EVENT_CACHE_FILE_NAME);
        BufferedReader bufferedReader = null;
        try {
            String line;
            FileInputStream fileInputStream = new FileInputStream(file);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            HashMap<String, String> params = new HashMap<String, String>();
            String eventCode = "";
            while ((line = bufferedReader.readLine()) != null) {
                if (line.startsWith("Event code: ")) {
                    if (!eventCode.isEmpty()) {
                        eventCodes.add(eventCode);
                        paramsList.add(params);
                        params = new HashMap();
                    }
                    eventCode = line.substring("Event code: ".length());
                    continue;
                }
                if (!line.contains(": ")) continue;
                String[] parts = line.split(": ", 2);
                params.put(parts[0], parts[1]);
            }
            if (!eventCode.isEmpty()) {
                eventCodes.add(eventCode);
                paramsList.add(params);
            }
        }
        catch (IOException e) {
            Log.e((String)"FileUtils", (String)"Error reading event from file", (Throwable)e);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    Log.e((String)"FileUtils", (String)"Error closing BufferedReader", (Throwable)e);
                }
            }
            if (file.exists() && !file.delete()) {
                Log.e((String)"FileUtils", (String)"Error deleting file");
            }
        }
    }

    public static boolean eventFileExists(Context context) {
        if (context == null) {
            return false;
        }
        File file = new File(context.getExternalCacheDir() + File.separator + Constants.BEACON_EVENT_CACHE_FILE_NAME);
        return file.exists();
    }
}

