/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.track.service;

import android.content.Context;
import android.util.Log;
import com.tencent.qcloud.track.cls.ClsAuthenticationException;
import com.tencent.qcloud.track.cls.ClsLifecycleCredentialProvider;
import com.tencent.qcloud.track.cls.ClsSessionCredentials;
import com.tencent.qcloud.track.service.ATrackService;
import com.tencentcloudapi.cls.android.producer.AsyncProducerClient;
import com.tencentcloudapi.cls.android.producer.AsyncProducerConfig;
import com.tencentcloudapi.cls.android.producer.common.LogItem;
import com.tencentcloudapi.cls.android.producer.errors.ProducerException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ClsTrackService
extends ATrackService {
    private static final String TAG = "ClsTrackService";
    private AsyncProducerClient clsClient;
    private String topicId;
    private ClsLifecycleCredentialProvider clsLifecycleCredentialProvider;
    private ExecutorService singleThreadExecutor = Executors.newSingleThreadExecutor();

    public void init(Context context, String topicId, String endpoint) {
        this.isInit = true;
        this.topicId = topicId;
        AsyncProducerConfig config = new AsyncProducerConfig(context.getApplicationContext(), endpoint, "secretId", "secretKey", "", null);
        this.clsClient = new AsyncProducerClient(config);
    }

    public void setSecurityCredential(String secretId, String secretKey) {
        this.clsClient.getProducerConfig().resetSecurityToken(secretId, secretKey, "");
    }

    public void setCredentialProvider(ClsLifecycleCredentialProvider lifecycleCredentialProvider) {
        this.clsLifecycleCredentialProvider = lifecycleCredentialProvider;
    }

    @Override
    public void report(String eventCode, Map<String, String> params) {
        if (this.isCloseReport() || !this.isInit || !ClsTrackService.isInclude()) {
            return;
        }
        if (this.clsLifecycleCredentialProvider == null) {
            this.putLogs(eventCode, params);
        } else {
            this.singleThreadExecutor.submit(() -> {
                ClsSessionCredentials credentials = null;
                try {
                    credentials = this.clsLifecycleCredentialProvider.getCredentials();
                }
                catch (ClsAuthenticationException e) {
                    e.printStackTrace();
                }
                if (credentials != null) {
                    this.clsClient.getProducerConfig().resetSecurityToken(credentials.getSecretId(), credentials.getSecretKey(), credentials.getToken());
                    this.putLogs(eventCode, params);
                }
            });
        }
    }

    private void putLogs(String eventCode, Map<String, String> params) {
        ArrayList<LogItem> logItems = new ArrayList<LogItem>();
        LogItem logItem = new LogItem();
        for (String key : params.keySet()) {
            logItem.PushBack(key, params.get(key));
        }
        logItems.add(logItem);
        try {
            this.clsClient.putLogs(this.topicId, logItems, result -> {
                if (this.isDebug()) {
                    StringBuilder mapAsString = new StringBuilder("{");
                    for (String key : params.keySet()) {
                        mapAsString.append(key).append("=").append((String)params.get(key)).append(", ");
                    }
                    mapAsString.delete(mapAsString.length() - 2, mapAsString.length()).append("}");
                    Log.i((String)TAG, (String)String.format("eventCode: %s, topicId: %s, params: %s => result: %s", eventCode, this.topicId, mapAsString, result.toString()));
                }
            });
        }
        catch (ProducerException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static boolean isInclude() {
        try {
            Class.forName("com.tencentcloudapi.cls.android.producer.AsyncProducerClient");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

