/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.track.cls;

import com.tencent.qcloud.track.cls.ClsAuthenticationException;
import com.tencent.qcloud.track.cls.ClsSessionCredentials;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public abstract class ClsLifecycleCredentialProvider {
    private volatile ClsSessionCredentials credentials;
    private ReentrantLock lock = new ReentrantLock();

    public ClsSessionCredentials getCredentials() throws ClsAuthenticationException {
        ClsSessionCredentials cred = this.safeGetCredentials();
        if (cred == null || !cred.isValid()) {
            this.refresh();
            return this.safeGetCredentials();
        }
        return cred;
    }

    public void refresh() throws ClsAuthenticationException {
        block10: {
            boolean locked = false;
            try {
                locked = this.lock.tryLock(20L, TimeUnit.SECONDS);
                if (!locked) {
                    throw new ClsAuthenticationException("lock timeout, no credential for sign");
                }
                ClsSessionCredentials cred = this.safeGetCredentials();
                if (cred != null && cred.isValid()) break block10;
                this.safeSetCredentials(null);
                try {
                    ClsSessionCredentials newCredentials = this.fetchNewCredentials();
                    this.safeSetCredentials(newCredentials);
                }
                catch (Exception e) {
                    if (e instanceof ClsAuthenticationException) {
                        throw e;
                    }
                    throw new ClsAuthenticationException("fetch credentials error happens: " + e.getMessage());
                }
            }
            catch (InterruptedException e) {
                throw new ClsAuthenticationException("interrupt when try to get credential: " + e.getMessage());
            }
            finally {
                if (locked) {
                    this.lock.unlock();
                }
            }
        }
    }

    public synchronized void forceInvalidationCredential() {
        this.safeSetCredentials(null);
    }

    private synchronized void safeSetCredentials(ClsSessionCredentials credentials) {
        this.credentials = credentials;
    }

    private synchronized ClsSessionCredentials safeGetCredentials() {
        return this.credentials;
    }

    protected abstract ClsSessionCredentials fetchNewCredentials() throws ClsAuthenticationException;
}

