/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.sonar.dns;

import com.tencent.qcloud.network.sonar.Sonar;
import com.tencent.qcloud.network.sonar.SonarRequest;
import com.tencent.qcloud.network.sonar.SonarResult;
import com.tencent.qcloud.network.sonar.SonarType;
import com.tencent.qcloud.network.sonar.dns.Dns;
import com.tencent.qcloud.network.sonar.dns.DnsResult;
import com.tencent.qcloud.network.sonar.utils.SonarLog;
import java.util.ArrayList;
import java.util.List;
import org.minidns.dnsmessage.Question;
import org.minidns.hla.DnssecResolverApi;
import org.minidns.hla.ResolverResult;
import org.minidns.record.CNAME;
import org.minidns.record.Record;

public class DnsSonar
implements Sonar<DnsResult> {
    @Override
    public SonarResult<DnsResult> start(SonarRequest request) {
        if (!request.isNetworkAvailable()) {
            return new SonarResult<DnsResult>(SonarType.DNS, new Exception("Network is not available"));
        }
        DnsResult dnsResult = new DnsResult();
        try {
            long startTime = System.currentTimeMillis();
            DnssecResolverApi.INSTANCE.getDnssecClient().setUseHardcodedDnsServers(false);
            Question question = new Question((CharSequence)request.getHost(), Record.TYPE.A);
            ResolverResult result = DnssecResolverApi.INSTANCE.resolve(question);
            List answerSection = result.getRawAnswer().answerSection;
            ArrayList<String> aList = new ArrayList<String>();
            ArrayList<String> cnameList = new ArrayList<String>();
            for (Record record : answerSection) {
                if (record.type == Record.TYPE.A) {
                    aList.add(record.getPayload().toString());
                    continue;
                }
                if (record.type != Record.TYPE.CNAME) continue;
                cnameList.add(((CNAME)record.getPayload()).target.toString());
            }
            dnsResult.a = String.join((CharSequence)",", aList);
            dnsResult.cname = String.join((CharSequence)",", cnameList);
            dnsResult.response = result.getDnsQueryResult().response.toString();
            long endTime = System.currentTimeMillis();
            dnsResult.localHosts = Dns.getLocalHost();
            dnsResult.lookupTime = endTime - startTime;
            if (!aList.isEmpty()) {
                dnsResult.ip = (String)aList.get(aList.size() - 1);
            }
            return new SonarResult<DnsResult>(SonarType.DNS, dnsResult);
        }
        catch (Exception e) {
            if (SonarLog.openLog) {
                e.printStackTrace();
            }
            return new SonarResult<DnsResult>(SonarType.DNS, e);
        }
    }

    @Override
    public void stop() {
    }
}

