/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.sonar;

import android.content.Context;
import com.tencent.qcloud.network.sonar.NetworkSonarCallback;
import com.tencent.qcloud.network.sonar.SonarRequest;
import com.tencent.qcloud.network.sonar.SonarResult;
import com.tencent.qcloud.network.sonar.SonarType;
import com.tencent.qcloud.network.sonar.dns.AndroidDnsServerLookup;
import com.tencent.qcloud.network.sonar.dns.DnsResult;
import com.tencent.qcloud.network.sonar.dns.DnsSonar;
import com.tencent.qcloud.network.sonar.http.HttpResult;
import com.tencent.qcloud.network.sonar.http.HttpSonar;
import com.tencent.qcloud.network.sonar.ping.PingResult;
import com.tencent.qcloud.network.sonar.ping.PingSonar;
import com.tencent.qcloud.network.sonar.traceroute.TracerouteResult;
import com.tencent.qcloud.network.sonar.traceroute.TracerouteSonar;
import com.tencent.qcloud.network.sonar.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import org.minidns.DnsClient;
import org.minidns.dnsserverlookup.AndroidUsingExec;
import org.minidns.dnsserverlookup.AndroidUsingReflection;
import org.minidns.dnsserverlookup.DnsServerLookupMechanism;
import org.minidns.dnsserverlookup.UnixUsingEtcResolvConf;

public class NetworkSonar {
    private static Context appContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sonar(Context appContext, SonarRequest request, List<SonarType> types, NetworkSonarCallback callback) {
        Class<NetworkSonar> clazz = NetworkSonar.class;
        synchronized (NetworkSonar.class) {
            if (NetworkSonar.appContext == null) {
                NetworkSonar.appContext = appContext;
                DnsClient.removeDNSServerLookupMechanism((DnsServerLookupMechanism)AndroidUsingExec.INSTANCE);
                DnsClient.removeDNSServerLookupMechanism((DnsServerLookupMechanism)AndroidUsingReflection.INSTANCE);
                DnsClient.removeDNSServerLookupMechanism((DnsServerLookupMechanism)UnixUsingEtcResolvConf.INSTANCE);
                DnsClient.addDnsServerLookupMechanism((DnsServerLookupMechanism)new AndroidDnsServerLookup(appContext));
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            request.setNetworkAvailable(Utils.isNetworkAvailable(appContext));
            ArrayList<SonarResult> results = new ArrayList<SonarResult>();
            for (int i = 0; i < types.size(); ++i) {
                SonarResult<Object> result = null;
                SonarType type = types.get(i);
                callback.onStart(type);
                switch (type) {
                    case DNS: {
                        result = NetworkSonar.sonarDns(request);
                        if (!result.isSuccess()) break;
                        DnsResult dnsResult = (DnsResult)result.getResult();
                        request.setIp(dnsResult.ip);
                        break;
                    }
                    case PING: {
                        result = NetworkSonar.sonarPing(request);
                        break;
                    }
                    case TRACEROUTE: {
                        result = NetworkSonar.sonarTraceroute(request);
                        break;
                    }
                    case HTTP: {
                        result = NetworkSonar.sonarHttp(request);
                    }
                }
                if (result.isSuccess()) {
                    callback.onSuccess(result);
                } else {
                    callback.onFail(result);
                }
                results.add(result);
                if (i != types.size() - 1) continue;
                callback.onFinish(results);
            }
            return;
        }
    }

    public static SonarResult<DnsResult> sonarDns(SonarRequest request) {
        return new DnsSonar().start(request);
    }

    public static SonarResult<PingResult> sonarPing(SonarRequest request) {
        return new PingSonar().start(request);
    }

    public static SonarResult<TracerouteResult> sonarTraceroute(SonarRequest request) {
        return new TracerouteSonar().start(request);
    }

    public static SonarResult<HttpResult> sonarHttp(SonarRequest request) {
        return NetworkSonar.sonarHttp(request, false);
    }

    public static SonarResult<HttpResult> sonarHttp(SonarRequest request, boolean bypassProxy) {
        return new HttpSonar(bypassProxy).start(request);
    }

    public static Context getAppContext() {
        return appContext;
    }
}

