/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.sonar.traceroute;

import android.text.TextUtils;
import com.tencent.qcloud.network.sonar.command.CommandStatus;
import com.tencent.qcloud.network.sonar.command.NetCommandResult;
import com.tencent.qcloud.network.sonar.utils.SonarLog;
import org.json.JSONException;
import org.json.JSONObject;

public class SingleNodeResult
extends NetCommandResult {
    private int hop;
    private String routeIp;
    private boolean isFinalRoute;
    protected float delay;

    protected SingleNodeResult(String targetIp, int hop) {
        super(targetIp);
        this.hop = hop;
        this.setRouteIp("*");
        this.delay = 0.0f;
    }

    public int getHop() {
        return this.hop;
    }

    public String getRouteIp() {
        return this.routeIp;
    }

    public boolean isFinalRoute() {
        return this.isFinalRoute;
    }

    public void setDelay(float delay) {
        this.delay = delay;
    }

    public float getDelay() {
        return this.delay;
    }

    SingleNodeResult setHop(int hop) {
        this.hop = hop;
        return this;
    }

    SingleNodeResult setRouteIp(String routeIp) {
        this.routeIp = routeIp;
        this.isFinalRoute = TextUtils.equals((CharSequence)this.targetIp, (CharSequence)routeIp);
        return this;
    }

    SingleNodeResult setFinalRoute(boolean isFinalRoute) {
        this.isFinalRoute = isFinalRoute;
        return this;
    }

    SingleNodeResult setStatus(CommandStatus status) {
        this.status = status;
        return this;
    }

    public String toString() {
        return this.toJson().toString();
    }

    @Override
    public JSONObject toJson() {
        JSONObject json;
        block2: {
            json = super.toJson();
            try {
                json.put("hop", this.hop);
                json.put("route_ip", (Object)this.routeIp);
                json.put("delay", (Object)String.format("%.2f", Float.valueOf(this.delay)));
                json.put("is_final_route", this.isFinalRoute);
            }
            catch (JSONException e) {
                if (!SonarLog.openLog) break block2;
                e.printStackTrace();
            }
        }
        return json;
    }
}

