/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import com.tencent.cos.xml.CosXmlBaseService;
import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.listener.CosXmlProgressListener;
import com.tencent.cos.xml.model.object.TransferRequest;
import com.tencent.cos.xml.model.object.UploadRequest;
import com.tencent.cos.xml.model.tag.UrlUploadPolicy;
import com.tencent.qcloud.core.http.RequestBodySerializer;
import com.tencent.qcloud.core.util.ContextHolder;
import com.tencent.qcloud.core.util.QCloudUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.xmlpull.v1.XmlPullParserException;

public class BasePutObjectRequest
extends UploadRequest
implements TransferRequest {
    protected String srcPath;
    protected byte[] data;
    protected InputStream inputStream;
    protected String strData;
    protected URL url;
    protected UrlUploadPolicy urlUploadPolicy;
    protected long fileLength;
    protected Uri uri;
    protected CosXmlProgressListener progressListener;

    protected BasePutObjectRequest(String bucket, String cosPath) {
        super(bucket, cosPath);
        this.setNeedMD5(true);
    }

    public BasePutObjectRequest(String bucket, String cosPath, String srcPath) {
        this(bucket, cosPath);
        this.srcPath = srcPath;
    }

    public BasePutObjectRequest(String bucket, String cosPath, Uri uri) {
        this(bucket, cosPath);
        this.uri = uri;
    }

    public BasePutObjectRequest(String bucket, String cosPath, byte[] data) {
        this(bucket, cosPath);
        this.data = data;
    }

    public BasePutObjectRequest(String bucket, String cosPath, StringBuilder stringBuilder) {
        this(bucket, cosPath);
        this.strData = stringBuilder.toString();
    }

    public BasePutObjectRequest(String bucket, String cosPath, InputStream inputStream) {
        this(bucket, cosPath);
        this.inputStream = inputStream;
    }

    public BasePutObjectRequest(String bucket, String cosPath, URL url) {
        this(bucket, cosPath);
        this.url = url;
        this.setNeedMD5(false);
    }

    @Override
    public String getMethod() {
        return "PUT";
    }

    public void setPriorityLow() {
        this.priority = 1;
    }

    public boolean isPriorityLow() {
        return this.priority == 1;
    }

    @Override
    protected RequestBodySerializer xmlBuilder() throws XmlPullParserException, IOException {
        if (this.srcPath != null) {
            return RequestBodySerializer.file((String)this.getContentType(), (File)new File(this.srcPath));
        }
        if (this.data != null) {
            return RequestBodySerializer.bytes((String)this.getContentType(), (byte[])this.data);
        }
        if (this.inputStream != null) {
            return RequestBodySerializer.stream((String)this.getContentType(), (File)new File(CosXmlBaseService.appCachePath, String.valueOf(System.currentTimeMillis())), (InputStream)this.inputStream);
        }
        if (this.strData != null) {
            return RequestBodySerializer.bytes((String)this.getContentType(), (byte[])this.strData.getBytes());
        }
        if (this.url != null) {
            return RequestBodySerializer.url((String)this.getContentType(), (URL)this.url);
        }
        if (this.uri != null && ContextHolder.getAppContext() != null) {
            return RequestBodySerializer.uri((String)this.getContentType(), (Uri)this.uri, (Context)ContextHolder.getAppContext());
        }
        return null;
    }

    @Override
    public void checkParameters() throws CosXmlClientException {
        Context appContext;
        File file;
        super.checkParameters();
        if (this.srcPath == null && this.data == null && this.inputStream == null && this.strData == null && this.uri == null && this.url == null) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "Data Source must not be null");
        }
        if (this.srcPath != null && !(file = new File(this.srcPath)).exists()) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "upload file does not exist");
        }
        if (this.uri != null && (appContext = ContextHolder.getAppContext()) != null && !QCloudUtils.doesUriFileExist((Uri)this.uri, (ContentResolver)appContext.getContentResolver())) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "upload file does not exist");
        }
    }

    public void setProgressListener(CosXmlProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public CosXmlProgressListener getProgressListener() {
        return this.progressListener;
    }

    public void setSrcPath(String srcPath) {
        this.srcPath = srcPath;
    }

    public String getSrcPath() {
        return this.srcPath;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setStrData(String strData) {
        this.strData = strData;
    }

    public String getStrData() {
        return this.strData;
    }

    public URL getUrl() {
        return this.url;
    }

    public UrlUploadPolicy getUrlUploadPolicy() {
        return this.urlUploadPolicy;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public void setUri(Uri uri) {
        this.uri = uri;
    }

    public Uri getUri() {
        return this.uri;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public byte[] getData() {
        return this.data;
    }

    public long getFileLength() {
        if (this.srcPath != null) {
            this.fileLength = new File(this.srcPath).length();
        } else if (this.data != null) {
            this.fileLength = this.data.length;
        } else if (this.strData != null) {
            this.fileLength = this.strData.getBytes().length;
        }
        return this.fileLength;
    }

    @Override
    public void setTrafficLimit(long limit) {
        this.addHeader("x-cos-traffic-limit", String.valueOf(limit));
    }

    public void setUrlUploadPolicy(UrlUploadPolicy urlUploadPolicy) {
        this.urlUploadPolicy = urlUploadPolicy;
    }
}

