/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.crypto;

import com.tencent.cos.xml.CosXmlSimpleService;
import com.tencent.cos.xml.crypto.COSDirect;
import com.tencent.cos.xml.crypto.CryptoModuleBase;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.listener.CosXmlResultListener;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.object.CompleteMultiUploadRequest;
import com.tencent.cos.xml.model.object.CompleteMultiUploadResult;
import com.tencent.cos.xml.model.object.GetObjectRequest;
import com.tencent.cos.xml.model.object.GetObjectResult;
import com.tencent.cos.xml.model.object.HeadObjectRequest;
import com.tencent.cos.xml.model.object.HeadObjectResult;
import com.tencent.cos.xml.model.object.InitMultipartUploadRequest;
import com.tencent.cos.xml.model.object.InitMultipartUploadResult;
import com.tencent.cos.xml.model.object.PutObjectRequest;
import com.tencent.cos.xml.model.object.PutObjectResult;
import com.tencent.cos.xml.model.object.UploadPartRequest;
import com.tencent.cos.xml.model.object.UploadPartResult;

public class COSDirectImpl
implements COSDirect {
    private CryptoModuleBase cryptoModule;
    private CosXmlSimpleService cosService;

    public COSDirectImpl(CosXmlSimpleService cosService, CryptoModuleBase cryptoModule) {
        this.cosService = cosService;
        this.cryptoModule = cryptoModule;
    }

    @Override
    public PutObjectResult putObject(PutObjectRequest request) throws CosXmlClientException, CosXmlServiceException {
        if (this.isTransferSecurely()) {
            return this.cryptoModule.putObjectSecurely(request);
        }
        if (this.cosService != null) {
            return this.cosService.putObject(request);
        }
        throw CosXmlClientException.internalException((String)"Api implementation not found");
    }

    @Override
    public GetObjectResult getObject(GetObjectRequest getObjectRequest) throws CosXmlClientException, CosXmlServiceException {
        if (this.isTransferSecurely()) {
            return this.cryptoModule.getObjectSecurely(getObjectRequest);
        }
        if (this.cosService != null) {
            return this.cosService.getObject(getObjectRequest);
        }
        throw CosXmlClientException.internalException((String)"Api implementation not found");
    }

    @Override
    public CompleteMultiUploadResult completeMultipartUpload(CompleteMultiUploadRequest request) throws CosXmlClientException, CosXmlServiceException {
        if (this.isTransferSecurely()) {
            return this.cryptoModule.completeMultipartUploadSecurely(request);
        }
        if (this.cosService != null) {
            return this.cosService.completeMultiUpload(request);
        }
        throw CosXmlClientException.internalException((String)"Api implementation not found");
    }

    @Override
    public InitMultipartUploadResult initMultipartUpload(InitMultipartUploadRequest request) throws CosXmlClientException, CosXmlServiceException {
        if (this.isTransferSecurely()) {
            return this.cryptoModule.initMultipartUploadSecurely(request);
        }
        if (this.cosService != null) {
            return this.cosService.initMultipartUpload(request);
        }
        throw CosXmlClientException.internalException((String)"Api implementation not found");
    }

    @Override
    public UploadPartResult uploadPart(UploadPartRequest request) throws CosXmlClientException, CosXmlServiceException {
        if (this.isTransferSecurely()) {
            return this.cryptoModule.uploadPartSecurely(request);
        }
        if (this.cosService != null) {
            return this.cosService.uploadPart(request);
        }
        throw CosXmlClientException.internalException((String)"Api implementation not found");
    }

    @Override
    public void uploadPartAsync(UploadPartRequest request, CosXmlResultListener resultListener) {
        if (this.isTransferSecurely()) {
            this.cryptoModule.uploadPartAsyncSecurely(request, resultListener);
        } else if (this.cosService != null) {
            this.cosService.uploadPartAsync(request, resultListener);
        } else {
            resultListener.onFail((CosXmlRequest)request, CosXmlClientException.internalException((String)"Api implementation not found"), null);
        }
    }

    @Override
    public HeadObjectResult headObject(HeadObjectRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.cosService.headObject(request);
    }

    @Override
    public boolean isTransferSecurely() {
        return this.cryptoModule != null;
    }

    @Override
    public CosXmlSimpleService getCosService() {
        return this.cosService;
    }

    @Override
    public CryptoModuleBase getCryptoModule() {
        return this.cryptoModule;
    }

    @Override
    public void cancel(CosXmlRequest request) {
        if (this.cosService != null) {
            this.cosService.cancel(request);
        }
    }

    @Override
    public void cancel(CosXmlRequest request, boolean now) {
        if (this.cosService != null) {
            this.cosService.cancel(request, now);
        }
    }
}

