/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud;

import com.fasterxml.jackson.databind.JsonNode;
import com.tencent.cloud.Policy;
import com.tencent.cloud.RegionCodeFilter;
import com.tencent.cloud.Response;
import com.tencent.cloud.Scope;
import com.tencent.cloud.Statement;
import com.tencent.cloud.assumerole.AssumeRoleParam;
import com.tencent.cloud.cos.util.Jackson;
import com.tencent.cloud.cos.util.Request;
import com.tencent.cloud.cos.util.Sign;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;

public class CosStsClient {
    private static final int DEFAULT_DURATION_SECONDS = 1800;
    public static final String STS_DEFAULT_HOST = "sts.tencentcloudapi.com";

    public static Response getCredential(TreeMap<String, Object> config) throws IOException {
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        Parameters parameters = new Parameters();
        parameters.parse(config);
        if (parameters.secretId == null) {
            throw new IllegalArgumentException("secretId is null");
        }
        if (parameters.secretKey == null) {
            throw new IllegalArgumentException("secretKey is null");
        }
        String policy = parameters.policy;
        if (policy != null) {
            params.put("Policy", policy);
        } else {
            params.put("Policy", CosStsClient.getPolicy(parameters));
        }
        params.put("DurationSeconds", parameters.duration);
        params.put("Name", "cos-sts-java");
        params.put("Action", "GetFederationToken");
        params.put("Version", "2018-08-13");
        String region = RegionCodeFilter.convert(parameters.region);
        params.put("Region", region);
        if (parameters.secretType != null) {
            params.put("SecretType", parameters.secretType);
        }
        String host = STS_DEFAULT_HOST;
        if (parameters.host != null) {
            host = parameters.host;
        }
        String stsHost = STS_DEFAULT_HOST;
        if (host.startsWith("sts.") && host.endsWith(".tencentcloudapi.com")) {
            stsHost = host;
        }
        String path = "/";
        String result = null;
        JsonNode jsonResult = null;
        try {
            result = Request.send(params, parameters.secretId, parameters.secretKey, "POST", host, stsHost, path);
            jsonResult = Jackson.jsonNodeOf(result);
            JsonNode data = jsonResult.get("Response");
            if (data == null) {
                data = jsonResult;
            }
            Response response = Jackson.fromJsonString(data.toString(), Response.class);
            long expiredTime = data.get("ExpiredTime").asLong();
            response.startTime = expiredTime - (long)parameters.duration;
            if (response.credentials.token != null) {
                response.credentials.sessionToken = response.credentials.token;
                response.credentials.token = null;
            }
            return response;
        }
        catch (Exception e) {
            JsonNode error;
            JsonNode response;
            if (jsonResult != null && (response = jsonResult.get("Response")) != null && (error = response.get("Error")) != null) {
                String message = error.get("Message").asText();
                String code = error.get("Code").asText();
                if ("InvalidParameterValue".equals(code) && message != null && message.contains("Region") && RegionCodeFilter.block(region)) {
                    return CosStsClient.getCredential(config);
                }
            }
            throw new IOException("result = " + result, e);
        }
    }

    public static Response getRoleCredential(AssumeRoleParam assumeRoleParam) throws Exception {
        if (assumeRoleParam == null) {
            throw new IllegalArgumentException("null assumeRoleParam");
        }
        assumeRoleParam.check();
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        params.put("Action", "AssumeRole");
        params.put("Region", assumeRoleParam.getRegion());
        params.put("Timestamp", System.currentTimeMillis() / 1000L);
        params.put("Version", "2018-08-13");
        params.put("Nonce", new Random().nextInt(Integer.MAX_VALUE));
        params.put("SignatureMethod", assumeRoleParam.getSignatureMethod());
        params.put("SecretId", assumeRoleParam.getSecretId());
        if (assumeRoleParam.getDurationSec() > 0) {
            params.put("DurationSeconds", assumeRoleParam.getDurationSec());
        }
        params.put("RoleArn", assumeRoleParam.getRoleArn());
        params.put("RoleSessionName", assumeRoleParam.getRoleSessionName());
        if (!assumeRoleParam.getPolicy().isEmpty()) {
            params.put("Policy", assumeRoleParam.getPolicy());
        }
        String stsHost = STS_DEFAULT_HOST;
        if (assumeRoleParam.getHost().startsWith("sts.") && assumeRoleParam.getHost().endsWith(".tencentcloudapi.com")) {
            stsHost = assumeRoleParam.getHost();
        }
        String path = "/";
        String url = "https://" + assumeRoleParam.getHost() + path;
        String method = "POST";
        String plainText = Sign.makeSignPlainText(params, method, stsHost, path);
        try {
            params.put("Signature", Sign.sign(plainText, assumeRoleParam.getSecretKey(), assumeRoleParam.getSignatureMethod()));
        }
        catch (Exception e) {
            System.out.println("fail to sign with plainText: " + plainText + ", SignatureMethod" + assumeRoleParam.getSignatureMethod());
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        String result = null;
        try {
            result = Request.sendRequest(url, params, method);
            System.out.println("assume role result: " + result);
        }
        catch (Exception e) {
            System.out.println("fail to exchange request. url=" + url);
            throw new Exception(e.getMessage(), e);
        }
        JsonNode jsonResult = Jackson.jsonNodeOf(result);
        if (!jsonResult.has("Response")) {
            System.out.println("there is no Response in jsonResult: " + jsonResult.toPrettyString());
            throw new Exception("there is no Response in jsonResult");
        }
        JsonNode jsonResponse = jsonResult.get("Response");
        if (!jsonResponse.has("Credentials")) {
            System.out.println("there is no Credentials in jsonResponse: " + jsonResponse.toPrettyString());
            throw new Exception("there is no Credentials in jsonResponse");
        }
        JsonNode jsonCredentials = jsonResponse.get("Credentials");
        Response response = new Response();
        if (!jsonCredentials.has("Token")) {
            System.out.println("there is no Token in jsonCredentials: " + jsonCredentials.toPrettyString());
            throw new Exception("there is no Token in jsonCredentials");
        }
        response.credentials.token = jsonCredentials.get("Token").asText();
        if (!jsonCredentials.has("TmpSecretId")) {
            System.out.println("there is no TmpSecretId in jsonCredentials: " + jsonCredentials.toPrettyString());
            throw new Exception("there is no TmpSecretId in jsonCredentials");
        }
        response.credentials.tmpSecretId = jsonCredentials.get("TmpSecretId").asText();
        if (!jsonCredentials.has("TmpSecretKey")) {
            System.out.println("there is no TmpSecretKey in jsonCredentials: " + jsonCredentials.toPrettyString());
            throw new Exception("there is no TmpSecretKey in jsonCredentials");
        }
        response.credentials.tmpSecretKey = jsonCredentials.get("TmpSecretKey").asText();
        if (!jsonResponse.has("ExpiredTime")) {
            System.out.println("there is no ExpiredTime in jsonResponse: " + jsonResponse.toPrettyString());
            throw new Exception("there is no ExpiredTime in jsonResponse");
        }
        response.expiredTime = jsonResponse.get("ExpiredTime").asLong();
        response.startTime = response.expiredTime - (long)assumeRoleParam.getDurationSec();
        if (!jsonResponse.has("Expiration")) {
            System.out.println("there is no Expiration in jsonResponse: " + jsonResponse.toPrettyString());
            throw new Exception("there is no Expiration in jsonResponse");
        }
        response.expiration = jsonResponse.get("Expiration").asText();
        if (jsonResponse.has("RequestId")) {
            response.requestId = jsonResponse.get("RequestId").asText();
        } else {
            System.out.println("there is no RequestId in jsonResponse: " + jsonResponse.toPrettyString());
        }
        System.out.println("succeed to assume role: " + response);
        return response;
    }

    public static String getPolicy(List<Scope> scopes) {
        if (scopes == null || scopes.size() == 0) {
            return null;
        }
        Policy policy = new Policy();
        policy.setVersion("2.0");
        for (Scope scope : scopes) {
            Statement statement = new Statement();
            statement.setEffect(scope.getEffect());
            statement.addAction(scope.getAction());
            statement.addResource(scope.getResource());
            policy.addStatement(statement);
        }
        return Jackson.toJsonPrettyString(policy);
    }

    static String getPolicy(Parameters parameters) {
        if (parameters.bucket == null) {
            throw new IllegalArgumentException("bucket == null");
        }
        if (parameters.allowPrefixes == null) {
            throw new IllegalArgumentException("allowPrefixes == null");
        }
        if (parameters.region == null) {
            throw new IllegalArgumentException("region == null");
        }
        Statement statement = new Statement();
        statement.setEffect("allow");
        for (String action : parameters.allowActions) {
            statement.addAction(action);
        }
        String bucket = parameters.bucket;
        String region = parameters.region;
        int lastSplit = bucket.lastIndexOf("-");
        String appId = bucket.substring(lastSplit + 1);
        for (String prefix : parameters.allowPrefixes) {
            String p = prefix;
            if (!p.startsWith("/")) {
                p = "/" + p;
            }
            String resource = String.format("qcs::cos:%s:uid/%s:%s%s", region, appId, bucket, p);
            statement.addResource(resource);
        }
        Policy policy = new Policy();
        policy.setVersion("2.0");
        policy.addStatement(statement);
        return Jackson.toJsonPrettyString(policy);
    }

    static class Parameters {
        String secretId;
        String secretKey;
        int duration = 1800;
        String bucket;
        String region;
        String[] allowPrefixes;
        String[] allowActions;
        String policy;
        Integer secretType;
        String host;

        Parameters() {
        }

        public void parse(Map<String, Object> config) {
            if (config == null) {
                throw new NullPointerException("config == null");
            }
            for (Map.Entry<String, Object> entry : config.entrySet()) {
                String key = entry.getKey();
                if ("SecretId".equalsIgnoreCase(key)) {
                    this.secretId = (String)entry.getValue();
                    continue;
                }
                if ("SecretKey".equalsIgnoreCase(key)) {
                    this.secretKey = (String)entry.getValue();
                    continue;
                }
                if ("durationSeconds".equalsIgnoreCase(key)) {
                    this.duration = (Integer)entry.getValue();
                    continue;
                }
                if ("bucket".equalsIgnoreCase(key)) {
                    this.bucket = (String)entry.getValue();
                    continue;
                }
                if ("region".equalsIgnoreCase(key)) {
                    this.region = (String)entry.getValue();
                    continue;
                }
                if ("allowPrefix".equalsIgnoreCase(key)) {
                    this.allowPrefixes = new String[]{(String)entry.getValue()};
                    continue;
                }
                if ("allowPrefixes".equalsIgnoreCase(key)) {
                    this.allowPrefixes = (String[])entry.getValue();
                    continue;
                }
                if ("policy".equalsIgnoreCase(key)) {
                    this.policy = (String)entry.getValue();
                    continue;
                }
                if ("allowActions".equalsIgnoreCase(key)) {
                    this.allowActions = (String[])entry.getValue();
                    continue;
                }
                if ("secretType".equalsIgnoreCase(key)) {
                    this.secretType = (Integer)entry.getValue();
                    continue;
                }
                if (!"host".equalsIgnoreCase(key)) continue;
                this.host = (String)entry.getValue();
            }
        }
    }
}

