package org.qas.qtest.api.services.user.model.transform;

import org.apache.commons.collections.CollectionUtils;
import org.qas.api.AuthClientException;
import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.user.model.AssignToProjectRequest;

/**
 * AssignToProjectRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id AssignToProjectRequestMarshaller 2014-07-10 21:42:30z dungvnguyen $
 * @since 1.0
 */
public class BatchAssignUsersRequestMarshaller extends AbstractMarshaller<Request, AssignToProjectRequest> {

  @Override
  protected void validateRequest(AssignToProjectRequest in) throws Exception {
    if (in == null) {
      throw new AuthClientException("Invalid request passed to call(...)");
    }

    if (in.getProjectId() == null || in.getProjectId() <= 0) {
      throw new AuthClientException("Invalid project identifier passed to call(...)");
    }

    if (CollectionUtils.isEmpty(in.getUserIds())) {
      throw new AuthClientException("Invalid userIds identifiers passed to call(...)");
    }
    if ((in.getAdminProfileId() == null && in.getUserProfileId() == null) ||
      (in.getAdminProfileId() != null && in.getAdminProfileId() <= 0 &&
        in.getUserProfileId() != null && in.getUserProfileId() <= 0)) {
      throw new AuthClientException("Invalid userProfileId or adminProfileId identifier passed to call(...)");
    }

  }

  @Override
  protected void build(Request request, AssignToProjectRequest in) {
    request.setHttpMethod(HttpMethod.POST);
  }

  @Override
  protected String getServiceName() {
    return "UserProfileService";
  }

  @Override
  protected String getActionName() {
    return "batchAssignUsers";
  }

  @Override
  protected String getContent(AssignToProjectRequest in) {
    return JsonMapper.toJson(in);
  }

  @Override
  protected StringBuilder getResourcePath(AssignToProjectRequest in, StringBuilder rpBuilder) {
    return rpBuilder.append("/api/v3/user-profiles/")
      .append(in.getProjectId())
      .append("/batch-assign-users");
  }
}
