package org.qas.qtest.api.services.user.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.qas.qtest.api.internal.model.QTestBaseModel;

/**
 * AssignProjectResult
 *
 * @author Dzung Nguyen
 * @version $Id AssignProjectResult 2014-07-10 15:10:30z dungvnguyen $
 * @since 1.0
 */
public class AssignToProjectResult extends QTestBaseModel<AssignToProjectResult> {
  @JsonProperty("project_id")
  private Long projectId;

  @JsonProperty("profile")
  private Profile profile;

  public AssignToProjectResult() {
  }

  /**
   * @return the current project identifier.
   */
  public Long getProjectId() {
    return projectId;
  }

  /**
   * Sets the current project identifier.
   *
   * @param projectId the given project project identifier.
   */
  public AssignToProjectResult setProjectId(Long projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * Sets the current project identifier.
   *
   * @param projectId the given project project identifier.
   * @return current instance.
   */
  public AssignToProjectResult withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return the user profile instance.
   */
  public Profile getProfile() {
    return profile;
  }

  /**
   * Sets the user profile.
   *
   * @param profile the given user profile instance to set.
   */
  public AssignToProjectResult setProfile(Profile profile) {
    this.profile = profile;
    return this;
  }

  /**
   * Sets the user profile.
   *
   * @param profile the given user profile instance to set.
   * @return the current instance.
   */
  public AssignToProjectResult withProfile(Profile profile) {
    setProfile(profile);
    return this;
  }

  @Override
  public User clone() {
    User that = new User();
    that.setPropertiesFrom(this);
    return that;
  }

  @Override
  public String elementName() {
    return "assign-to-project-result";
  }

  @Override
  public String jsonElementName() {
    return "assign_to_project_result";
  }
}
