package org.qas.qtest.api.services.user;

import org.qas.api.AuthClientException;
import org.qas.api.AuthServiceException;
import org.qas.api.ClientConfiguration;
import org.qas.api.Request;
import org.qas.api.internal.util.google.base.Throwables;
import org.qas.qtest.api.auth.DefaultQTestCredentialsProviderChain;
import org.qas.qtest.api.auth.QTestCredentials;
import org.qas.qtest.api.auth.QTestCredentialsProvider;
import org.qas.qtest.api.auth.StaticQTestCredentialsProvider;
import org.qas.qtest.api.internal.QTestApiWebServiceClient;
import org.qas.qtest.api.services.user.model.*;
import org.qas.qtest.api.services.user.model.transform.*;

import java.util.List;

/**
 * UserServiceClient
 *
 * @author Dzung Nguyen
 * @version $Id UserServiceClient 2014-07-09 11:02:30z dungvnguyen $
 * @since 1.0
 */
public class UserServiceClient extends QTestApiWebServiceClient<UserServiceClient>
  implements UserService {
  /**
   * Constructs a new client to invoke service method on UserService using
   * the default qTest credentials provider and default client configuration options.
   */
  public UserServiceClient() {
    this(new DefaultQTestCredentialsProviderChain(), new ClientConfiguration());
  }

  /**
   * Constructs a new client to invoke service method on UserService using
   * the default qTest credentials provider and client configuration options.
   *
   * @param clientConfiguration The client configuration options controlling how this
   *                            client connects to UserService
   */
  public UserServiceClient(ClientConfiguration clientConfiguration) {
    this(new DefaultQTestCredentialsProviderChain(), clientConfiguration);
  }

  /**
   * Constructs a new client to invoke service method on UserService using
   * the specified qTest credentials.
   *
   * @param credentials The qTest credentials which will provide
   *                    credentials to authenticate request with qTest services.
   */
  public UserServiceClient(QTestCredentials credentials) {
    this(credentials, new ClientConfiguration());
  }

  /**
   * Constructs a new client to invoke service method on UserService using
   * the specified qTest credentials and client configuration options.
   *
   * @param credentials         The qTest credentials which will provide
   *                            credentials to authenticate request with qTest services.
   * @param clientConfiguration The client configuration options controlling how this
   *                            client connects to UserService
   */
  public UserServiceClient(QTestCredentials credentials, ClientConfiguration clientConfiguration) {
    super(clientConfiguration);
    this.credentialsProvider = new StaticQTestCredentialsProvider(credentials);
    init();
  }

  /**
   * Constructs a new client to invoke service method on UserService using
   * the specified qTest credentials provider and client configuration options.
   *
   * @param credentialsProvider The qTest credentials provider which will provide
   *                            credentials to authenticate request with qTest services.
   */
  public UserServiceClient(QTestCredentialsProvider credentialsProvider) {
    this(credentialsProvider, new ClientConfiguration());
  }

  /**
   * Constructs a new client to invoke service method on UserService using
   * the specified qTest credentials provider and client configuration options.
   *
   * @param credentialsProvider The qTest credentials provider which will provide
   *                            credentials to authenticate request with qTest services.
   * @param clientConfiguration The client configuration options controlling how this
   *                            client connects to UserService
   */
  public UserServiceClient(QTestCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
    super(clientConfiguration);
    this.credentialsProvider = credentialsProvider;

    init();
  }

  @Override
  public User create(CreateUserRequest createUserRequest) throws AuthServiceException {
    try {
      Request request = new CreateUserRequestMarshaller().marshall(createUserRequest);
      return invoke(request, UserJsonUnmarshaller.getInstance());
    } catch (Exception ex) {
      Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
      throw new AuthClientException("An error occurs during create user to qTest service", ex);
    }
  }

  @Override
  public AssignToProjectResult assignToProject(AssignToProjectRequest assignToProjectRequest) throws AuthServiceException {
    try {
      Request request = new AssignToProjectRequestMarshaller().marshall(assignToProjectRequest);
      return invoke(request, AssignToProjectResultJsonUnmarshaller.getInstance());
    } catch (Exception ex) {
      Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
      throw new AuthClientException("An error occurs during assigning user to project", ex);
    }
  }

  @Override
  public List<User> listUser(ListUserRequest listUserRequest) throws AuthServiceException {
    try {
      Request request = new ListUserRequestMarshaller().marshall(listUserRequest);
      return invoke(request, ListUserJsonUnmarshaller.getInstance());
    } catch (Exception ex) {
      Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
      throw new AuthClientException("An error occurs during assigning user to project", ex);
    }
  }
}
