package org.qas.qtest.api.services.search.transform;

import com.fasterxml.jackson.core.type.TypeReference;
import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.search.model.History;
import org.qas.qtest.api.services.search.model.SearchResult;

/**
 * @author trongle
 * @since 1.4.9
 */
public class SearchHistoryUnmarshaller extends AbstractUnmarshaller<SearchResult, JsonUnmarshallerContext> {
  
  @Override
  public SearchResult<History> parse(String data) throws Exception {
    return JsonMapper.fromJson(data, new TypeReference<SearchResult<History>>() {
    });
  }
}
