package org.qas.qtest.api.services.search.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.qas.qtest.api.internal.model.QTestBaseModel;

import java.util.List;

/**
 * @author trongle
 * @since 1.4.9
 */
public class SearchResult<T> extends QTestBaseModel {
  @JsonProperty("page")
  private int page;
  @JsonProperty("page_size")
  private int pageSize;
  @JsonProperty("total")
  private long total;
  @JsonProperty("items")
  private List<T> items;
  
  public int getPage() {
    return page;
  }
  
  public SearchResult setPage(int page) {
    this.page = page;
    return this;
  }
  
  public int getPageSize() {
    return pageSize;
  }
  
  public SearchResult setPageSize(int pageSize) {
    this.pageSize = pageSize;
    return this;
  }
  
  public long getTotal() {
    return total;
  }
  
  public SearchResult setTotal(long total) {
    this.total = total;
    return this;
  }
  
  public List<T> getItems() {
    return items;
  }
  
  public SearchResult setItems(List<T> items) {
    this.items = items;
    return this;
  }
}
