package org.qas.qtest.api.services.search.model;

import org.qas.qtest.api.internal.model.ObjectType;

/**
 * @author trongle
 * @since 1.4.9
 */
public enum HistorySearchType {
  Requirement(ObjectType.Requirement),
  TestCase(ObjectType.TestCase),
  TestRun(ObjectType.TestRun),
  Defect(ObjectType.Defect),;
  private final ObjectType objectType;
  
  HistorySearchType(ObjectType objectType) {
    this.objectType = objectType;
  }
  
  public ObjectType getObjectType() {
    return objectType;
  }
}
