package org.qas.qtest.api.services.search.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.qas.api.DateTimeDeserializer;
import org.qas.api.DateTimeSerializer;
import org.qas.api.JsonModel;
import org.qas.qtest.api.internal.model.Link;

import java.util.Date;
import java.util.List;

@JsonModel
public class Comment {
  @JsonProperty("links")
  private List<Link> links;
  
  @JsonProperty("created")
  private Date created;
  
  @JsonProperty("updated")
  private Date updated;
  
  @JsonProperty("userId")
  private long userId;
  
  @JsonProperty("id")
  private long id;
  
  @JsonProperty("content")
  private String content;
  
  public List<Link> getLinks() {
    return links;
  }
  
  public Comment setLinks(List<Link> links) {
    this.links = links;
    return this;
  }
  
  @JsonSerialize(using = DateTimeSerializer.class, typing = JsonSerialize.Typing.STATIC, include = JsonSerialize.Inclusion.NON_NULL)
  public Date getCreated() {
    return created;
  }
  
  @JsonDeserialize(using = DateTimeDeserializer.class)
  public Comment setCreated(Date created) {
    this.created = created;
    return this;
  }
  
  @JsonSerialize(using = DateTimeSerializer.class, typing = JsonSerialize.Typing.STATIC, include = JsonSerialize.Inclusion.NON_NULL)
  public Date getUpdated() {
    return updated;
  }
  
  @JsonDeserialize(using = DateTimeDeserializer.class)
  public Comment setUpdated(Date updated) {
    this.updated = updated;
    return this;
  }
  
  public long getUserId() {
    return userId;
  }
  
  public Comment setUserId(long userId) {
    this.userId = userId;
    return this;
  }
  
  public long getId() {
    return id;
  }
  
  public Comment setId(long id) {
    this.id = id;
    return this;
  }
  
  public String getContent() {
    return content;
  }
  
  public Comment setContent(String content) {
    this.content = content;
    return this;
  }
}
