package org.qas.qtest.api.services.requirement.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.requirement.model.Requirement;

/**
 * RequirementJsonUnmarshaller
 *
 * @author Dzung Nguyen
 * @version $Id RequirementJsonUnmarshaller 2014-05-19 10:27:30z dungvnguyen $
 * @since 1.0
 */
public class RequirementJsonUnmarshaller extends AbstractUnmarshaller<Requirement, JsonUnmarshallerContext> {
  //~ class properties ========================================================
  private static RequirementJsonUnmarshaller instance;

  //~ class members ===========================================================
  public static RequirementJsonUnmarshaller getInstance() {
    if (instance == null) {
      instance = new RequirementJsonUnmarshaller();
    }

    return instance;
  }

  @Override
  public Requirement parse(String data) throws Exception {
    return JsonMapper.parseJson(data, Requirement.class);
  }
}
