package org.qas.qtest.api.services.requirement.model;

import org.qas.api.ApiServiceRequest;

/**
 * CreateRequirementRequest
 *
 * @author Dzung Nguyen
 * @version $Id CreateRequirementRequest 2014-05-19 10:50:30z dungvnguyen $
 * @since 1.0
 */
public class CreateRequirementRequest extends ApiServiceRequest {
  //~ class properties ========================================================
  private Long projectId;
  private Long parentId;
  private Requirement requirement;
  
  //~ class members ===========================================================
  
  /**
   * @return the project identifier that the requirement will attach to.
   */
  public Long getProjectId() {
    return projectId;
  }
  
  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier value to set.
   */
  public CreateRequirementRequest setProjectId(Long projectId) {
    this.projectId = projectId;
    return this;
  }
  
  /**
   * Sets the project identifier and return itself.
   *
   * @param projectId the given project identifier value to set.
   *
   * @return the create requirement request instance.
   */
  public CreateRequirementRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }
  
  /**
   * Set requirement parent.
   *
   * @param parentId the given parent identifier value.
   */
  public CreateRequirementRequest setParentId(Long parentId) {
    this.parentId = parentId;
    return this;
  }
  
  /**
   * Set requirement parent.
   *
   * @param parentId the given parent identifier value.
   *
   * @return the current create requirement request instance.
   */
  public CreateRequirementRequest withParentId(Long parentId) {
    setParentId(parentId);
    return this;
  }
  
  /**
   * @return the parent identifier.
   */
  public Long getParentId() {
    return this.parentId;
  }
  
  /**
   * @return the requirement information.
   */
  public Requirement getRequirement() {
    return requirement;
  }
  
  /**
   * Sets the requirement information.
   *
   * @param requirement the given requirement information to set.
   */
  public CreateRequirementRequest setRequirement(Requirement requirement) {
    this.requirement = requirement;
    return this;
  }
  
  /**
   * Sets the requirement information.
   *
   * @param requirement the given requirement information to set.
   *
   * @return current instance.
   */
  public CreateRequirementRequest withRequirement(Requirement requirement) {
    setRequirement(requirement);
    return this;
  }
  
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder(getClass().getName());
    
    builder.append("{").append("\n")
      .append("\tprojectId: ").append(projectId).append(",").append("\n")
      .append("\trequirement: \n")
      .append(requirement)
      .append("\n")
      .append("}");
    
    return builder.toString();
  }
}
